/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.AlertPolicyTable;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.EventFilterTable;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.trap.PETAcknowledge;

public class IPMIPEFCommand
extends IPMICommand {
    public static final byte SET_IN_PROGRESS = 1;
    public static final byte PEF_CONTROL = 2;
    public static final byte PEF_ACTION_GLOBAL_CONTROL = 2;
    public static final byte PEF_STARTUP_DELAY = 3;
    public static final byte PEF_ALERT_STARTUP_DELAY = 4;
    public static final byte NUMBER_OF_EVENT_FILTERS = 5;
    public static final byte EVENT_FILTER_TABLE = 6;
    public static final byte EVENT_FILTER_TABLE_DATA_1 = 7;
    public static final byte NUMBER_OF_ALERT_POLICY_ENTRIES = 8;
    public static final byte ALERT_POLICY_TABLE = 9;
    public static final byte SYSTEM_GUID = 10;
    public static final byte NUMBER_OF_ALERT_STRINGS = 11;
    public static final byte ALERT_STRING_KEYS = 12;
    public static final byte ALERT_STRINGS = 13;
    public static final byte NUMBER_OF_GROUP_CONTROL_TABLE_ENTRIES = 14;
    public static final byte GROUP_CONTROL_TABLE = 15;

    public IPMIPEFCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getPEFCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)16, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage armPEFPostoneTimerCommand(byte data1) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{data1};
        ipmiMessage.setCommandAndData((byte)16, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPEFConfigurationParametersCommand(byte paraSelector, byte[] paraData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + paraData.length];
        data[0] = paraSelector;
        System.arraycopy(paraData, 0, data, 1, paraData.length);
        ipmiMessage.setCommandAndData((byte)16, (byte)18, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPEFConfigurationParametersCommand(byte paraSelector, byte setSelector, byte blockSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{paraSelector, setSelector, blockSelector};
        ipmiMessage.setCommandAndData((byte)16, (byte)19, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setLastProcessedEventIDCommand(byte data1, byte[] recordID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{data1, recordID[0], recordID[1]};
        ipmiMessage.setCommandAndData((byte)16, (byte)20, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLastProcessedEventIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)16, (byte)21, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage alertImmediateCommand(byte channel, byte destinationSelector, byte alertStringSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, destinationSelector, alertStringSelector};
        ipmiMessage.setCommandAndData((byte)16, (byte)22, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage alertImmediateCommand(byte channel, byte destinationSelector, byte alertStringSelector, byte generatorID, byte evMRev, byte sensorType, byte sensorNumber, byte eventDirOrEventType, byte eventData1, byte eventData2, byte eventData3) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, destinationSelector, alertStringSelector, generatorID, evMRev, sensorType, sensorNumber, eventDirOrEventType, eventData1, eventData2, eventData3};
        ipmiMessage.setCommandAndData((byte)16, (byte)22, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage PETAcknowledgeCommand(byte[] seqNumber, byte[] localTimeStap, byte eventSourceType, byte sensorDevice, byte sensorNumber, byte[] eventData1to3) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{seqNumber[0], seqNumber[1], localTimeStap[0], localTimeStap[1], localTimeStap[2], localTimeStap[3], eventSourceType, sensorDevice, sensorNumber, eventData1to3[0], eventData1to3[1], eventData1to3[2]};
        ipmiMessage.setCommandAndData((byte)16, (byte)23, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public EventFilterTable getEventFilterTableEntry(byte index) {
        EventFilterTable eft = new EventFilterTable();
        IPMIMessage resMessage = this.getPEFConfigurationParametersCommand((byte)6, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[21];
                System.arraycopy(resMessage.data, 1, bytes, 0, bytes.length);
                eft.fromRaw(bytes);
                return eft;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return null;
    }

    public boolean setDefaultEventFilterTableEntry(byte index, byte policyNumber) {
        EventFilterTable eft = EventFilterTable.getDefault();
        eft.setAlertPolicyNumber(policyNumber);
        eft.setFilterNumber(index);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)6, eft.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setDefaultEventFilterTableEntryForAMI(byte index, byte policyNumber) {
        EventFilterTable eft = EventFilterTable.getDefaultForAMI();
        eft.setAlertPolicyNumber(policyNumber);
        eft.setFilterNumber(index);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)6, eft.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setDefaultEventFilterTableEntryForATEN(byte index, byte policyNumber) {
        EventFilterTable eft = EventFilterTable.getDefaultForATEN();
        eft.setAlertPolicyNumber(policyNumber);
        eft.setFilterNumber(index);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)6, eft.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setDefaultDisableEventFilterTableEntryForATEN(byte index) {
        EventFilterTable eft = EventFilterTable.getDefaultDisableForATEN();
        eft.setFilterNumber(index);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)6, eft.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public AlertPolicyTable getAlertPolicyTableEntry(byte index) {
        AlertPolicyTable apt = new AlertPolicyTable();
        IPMIMessage resMessage = this.getPEFConfigurationParametersCommand((byte)9, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[4];
                System.arraycopy(resMessage.data, 1, bytes, 0, bytes.length);
                apt.fromRaw(bytes);
                return apt;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return null;
    }

    public boolean setDefaultAlertPolicyTableEntry(byte index, byte policyNumber, byte destIndex) {
        AlertPolicyTable apt = new AlertPolicyTable();
        apt.setEntryNumber(index);
        apt.setPolicyNumber(policyNumber);
        apt.setDestination(destIndex);
        apt.setChannel((byte)1);
        apt.setIsEnable(true);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)9, apt.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setAlertPolicyTableEntry(byte index, byte policyNumber, boolean isEnable, byte channelNo, byte destIndex) {
        AlertPolicyTable apt = new AlertPolicyTable();
        apt.setEntryNumber(index);
        apt.setPolicyNumber(policyNumber);
        apt.setDestination(destIndex);
        apt.setChannel(channelNo);
        apt.setIsEnable(isEnable);
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)9, apt.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean sendAlertImmediate(byte destinationIndex) {
        IPMIMessage resMessage = this.alertImmediateCommand((byte)1, destinationIndex, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setPEFControl(byte enable) {
        byte[] data = new byte[]{enable};
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)1, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean setPEFActionGlobalControl(byte enable) {
        byte[] data = new byte[]{enable};
        IPMIMessage resMessage = this.setPEFConfigurationParametersCommand((byte)2, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public boolean sendPETAcknowledge(PETAcknowledge petAck) {
        IPMIMessage resMessage = this.PETAcknowledgeCommand(petAck.sequenceNumber, petAck.timestamp, petAck.eventSourceType, petAck.sensorDevice, petAck.sensorNumber, petAck.eventData);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return false;
    }

    public static void main_2(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.10.241");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPEFCommand.setIPMIInterface(rmcp);
        ipmiLanCommand.setIPMIInterface(rmcp);
        byte policyNumber = 0;
        byte destinationIndex = 1;
        boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(destinationIndex, policyNumber, destinationIndex);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(destinationIndex, "2.168.10.89", "00:00:00:00:00:00");
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(destinationIndex);
        destinationIndex = 2;
        ipmiPEFCommand.setDefaultAlertPolicyTableEntry(destinationIndex, policyNumber, destinationIndex);
        ipmiLanCommand.setDesitnationIPandMAC(destinationIndex, "2.168.10.42", "00:00:00:00:00:00");
        ipmiLanCommand.setDefaultPEFDestinationType(destinationIndex);
        System.out.println(b1);
        System.out.println(b2);
        System.out.println(b3);
        System.out.println(b4);
    }

    public static void main_org(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.10.241");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPEFCommand.setIPMIInterface(rmcp);
        EventFilterTable eft = EventFilterTable.getDefault();
        eft.setAlertPolicyNumber((byte)1);
        eft.setFilterNumber((byte)1);
        IPMIMessage resMessage = ipmiPEFCommand.setPEFConfigurationParametersCommand((byte)6, eft.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                System.out.println("set event filter table OK");
            } else {
                System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
        }
        AlertPolicyTable apt = new AlertPolicyTable();
        apt.setEntryNumber((byte)1);
        apt.setPolicyNumber((byte)1);
        apt.setDestination((byte)1);
        apt.setChannel((byte)1);
        apt.setIsEnable(true);
        resMessage = ipmiPEFCommand.setPEFConfigurationParametersCommand((byte)9, apt.toRaw());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                System.out.println("set alert policy table OK");
            } else {
                System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
        }
        if ((resMessage = ipmiPEFCommand.alertImmediateCommand((byte)1, (byte)1, (byte)-127)) != null) {
            if (resMessage.completionCode == 0) {
                System.out.println("alert immediate table OK");
            } else {
                System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
        }
        byte[] raw = new byte[]{1, 1, 84, 69, 83, 84, 0};
        resMessage = ipmiPEFCommand.setPEFConfigurationParametersCommand((byte)13, raw);
        if (resMessage.completionCode == 0) {
            System.out.println("Set Alert String OK");
        } else {
            System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            resMessage = ipmiPEFCommand.getPEFConfigurationParametersCommand((byte)13, (byte)i2, (byte)1);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                System.out.println("Alert String =" + new String(resMessage.data));
                System.out.println("Alert String =" + ByteUtility.bytesToHex(resMessage.data));
                continue;
            }
            System.out.println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        int i2;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.12.170");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiPEFCommand);
        ipmiLanCommand.setIPMIInterface(ipmiPEFCommand.getIPMIInterface());
        if (sessionController == null) {
            return;
        }
        for (i2 = 1; i2 < 17; ++i2) {
            EventFilterTable eventFilterTable = ipmiPEFCommand.getEventFilterTableEntry((byte)i2);
        }
        for (i2 = 1; i2 < 17; ++i2) {
            ipmiPEFCommand.getAlertPolicyTableEntry((byte)i2);
        }
        int numberOfDestination = ipmiLanCommand.getNumberOfDestination();
        MessageCenter.getInstance().put("Number of Destination = " + numberOfDestination);
        for (int j2 = 0; j2 < numberOfDestination + 1; ++j2) {
            String dIP = ipmiLanCommand.getDestinationIP((byte)j2);
            String dMAC = ipmiLanCommand.getDestinationMAC((byte)j2);
            if (dIP == null) continue;
            System.out.println(j2 + ": Destination IP address : " + dIP + ", MAC : " + dMAC);
        }
    }
}

