/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import java.util.Arrays;

public class IPMISoftwareFRUCommand
extends IPMICommand {
    private static final int block_size = 128;
    private static final byte read_Software_FRU = 20;
    private static final byte write_Software_FRU = 21;
    private static final byte read_Software_FRU_1E = 30;
    private static final byte write_Software_FRU_1F = 31;
    private static final byte read_Sign_Software_FRU = 34;
    private static final byte write_Sign_Software_FRU = 35;
    public Type type = Type.Unknown;

    private IPMIMessage readSoftwareFRUCommand(byte fruID, byte[] offset, byte readCount) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{20, fruID, offset[0], offset[1], readCount};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage writeSoftwareFRUCommand(byte fruID, byte[] offset, byte[] swFRU) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[swFRU.length + 4];
        data[0] = 21;
        data[1] = fruID;
        data[2] = offset[0];
        data[3] = offset[1];
        System.arraycopy(swFRU, 0, data, 4, swFRU.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage readSoftwareFRUBy1ECommand(byte fruID, byte[] offset, byte readCount) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{30, fruID, offset[0], offset[1], readCount};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage writeSoftwareFRUBy1FCommand(byte fruID, byte[] offset, byte[] swFRU) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[swFRU.length + 4];
        data[0] = 31;
        data[1] = fruID;
        data[2] = offset[0];
        data[3] = offset[1];
        System.arraycopy(swFRU, 0, data, 4, swFRU.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage readSignSoftwareFRUCommand(byte fruID, byte[] offset, byte readCount) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{34, fruID, offset[0], offset[1], readCount};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage writeSignSoftwareFRUCommand(byte fruID, byte[] offset, byte[] swFRU) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[swFRU.length + 4];
        data[0] = 35;
        data[1] = fruID;
        data[2] = offset[0];
        data[3] = offset[1];
        System.arraycopy(swFRU, 0, data, 4, swFRU.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private IPMIMessage readSoftwareFRU(byte fruID, byte[] offset, byte readCount) {
        if (this.type == Type.Legacy) {
            return this.readSoftwareFRUCommand(fruID, offset, readCount);
        }
        return null;
    }

    private IPMIMessage writeSoftwareFRU(byte fruID, byte[] offset, byte[] swFRU) {
        if (this.type == Type.Legacy) {
            return this.writeSoftwareFRUCommand(fruID, offset, swFRU);
        }
        return null;
    }

    public IPMISoftwareFRUCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public byte[] readSoftwareFRUByID(byte fruID) throws IPMIException {
        byte[] fru = new byte[256];
        int i2 = 0;
        while (i2 < fru.length) {
            byte[] offset = new byte[2];
            ByteUtility.intTo2Bytes(offset, 0, i2);
            IPMIMessage message = this.readSoftwareFRU(fruID, offset, (byte)-128);
            if (message.completionCode != 0) {
                throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
            }
            System.arraycopy(message.data, 1, fru, i2, 128);
            i2 += 128;
        }
        return fru;
    }

    public void writeSoftwareFRUByID(byte fruID, byte[] fru) throws IPMIException {
        int i2 = 0;
        while (i2 < fru.length) {
            byte[] offset = new byte[2];
            ByteUtility.intTo2Bytes(offset, 0, i2);
            IPMIMessage message = this.writeSoftwareFRU(fruID, offset, Arrays.copyOfRange(fru, i2, i2 + 128));
            if (message.completionCode != 0) {
                throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
            }
            i2 += 128;
        }
    }

    public void writeSoftwareFRUIndexByID(byte fruID, int index, byte[] value) throws IPMIException {
        byte[] offset = new byte[2];
        ByteUtility.intTo2Bytes(offset, 0, index);
        IPMIMessage message = this.writeSoftwareFRU(fruID, offset, value);
        if (message.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
        }
    }

    public byte[] readSignSoftwareFRUByID(byte fruID) throws IPMIException {
        byte[] fru = new byte[256];
        int i2 = 0;
        while (i2 < fru.length) {
            byte[] offset = new byte[2];
            ByteUtility.intTo2Bytes(offset, 0, i2);
            IPMIMessage message = this.readSignSoftwareFRUCommand(fruID, offset, (byte)(i2 + 128));
            if (message.completionCode != 0) {
                throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
            }
            System.arraycopy(message.data, 1, fru, i2, 128);
            i2 += 128;
        }
        return fru;
    }

    public void writeSignSoftwareFRUByID(byte fruID, byte[] fru) throws IPMIException {
        int i2 = 0;
        while (i2 < fru.length) {
            byte[] offset = new byte[2];
            ByteUtility.intTo2Bytes(offset, 0, i2);
            IPMIMessage message = this.writeSignSoftwareFRUCommand(fruID, offset, Arrays.copyOfRange(fru, i2, i2 + -128));
            if (message.completionCode != 0) {
                throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
            }
            i2 += 128;
        }
    }

    public void writeSignSoftwareFRUIndexByID(byte fruID, int index, byte[] value) throws IPMIException {
        byte[] offset = new byte[2];
        ByteUtility.intTo2Bytes(offset, 0, index);
        IPMIMessage message = this.writeSignSoftwareFRUCommand(fruID, offset, value);
        if (message.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
        }
    }

    public boolean checkIfSoftwareFRUExist() throws IPMIException {
        byte[] offset = new byte[2];
        IPMIMessage message = this.readSoftwareFRUCommand((byte)0, offset, (byte)1);
        return message.completionCode != -52;
    }

    public Type getActivationType() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiInterface);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        this.type = IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isRenesasAddOnATENGUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isTwinBladeCMMGUID(guid) || IPMIMessagingCommand.isATENGUID(guid) ? Type.NotSupported : Type.Legacy;
        return this.type;
    }

    public static enum Type {
        Unknown,
        NotSupported,
        Legacy;

    }
}

