/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIPayloadCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionInfo;

public class IPMIStaticCommand {
    public static boolean isSOLEnabled(IPMIInterfaceConfig config) {
        return IPMIStaticCommand.isSOLEnabled(config.getIp(), config.getUserName(), config.getPassword(), config.getPrivilege(), config.isSmcRAKP());
    }

    public static boolean isSOLEnabled(String ip, String username, String password, byte priviledge) {
        return IPMIStaticCommand.isSOLEnabled(ip, username, password, priviledge, false);
    }

    public static boolean isSOLEnabled(String ip, String username, String password, byte priviledge, boolean isSMCRAKP) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege(priviledge);
        config.setSmcRAKP(isSMCRAKP);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPayloadCommand ipmiPayloadCommand = new IPMIPayloadCommand(null);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return false;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiPayloadCommand.setIPMIInterface(rmcp);
        ipmiMessagingCommand.setIPMIInterface(rmcp);
        SessionInfo sessionInfo = ipmiMessagingCommand.getCurrentlySessionInfo(((RMCPPlus)rmcp).rmcpPlusSession.sessionID);
        boolean isSOLEnabled = ipmiPayloadCommand.isSOLEnabled(sessionInfo.getUserID());
        sessionController.closeSession();
        return isSOLEnabled;
    }

    public static void main(String[] args) {
        boolean b2 = IPMIStaticCommand.isSOLEnabled("2.168.12.157", "c", "c", (byte)4);
        System.out.println("b = " + b2);
    }
}

