/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;

public class IPMITASCommand
extends IPMICommand {
    public IPMITASCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void CMD_______________________() {
    }

    public IPMIMessage getSystemInfoParametersCommand(byte selector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, selector, 0, 0};
        ipmiMessage.setCommandAndData((byte)24, (byte)89, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInfoParametersCommand(byte[] data) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)24, (byte)89, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSystemInfoParametersCommand(byte selector, byte[] dataToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + dataToWrite.length];
        data[0] = selector;
        System.arraycopy(dataToWrite, 0, data, 1, dataToWrite.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)88, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_______________________() {
    }

    public boolean setTasPausebyKey(byte[] key) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 1;
        data[keylength + 11] = 1;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS Pause failed");
    }

    public boolean setTasResumebyKey(byte[] key) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 1;
        data[keylength + 11] = 2;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS Resume failed");
    }

    public boolean setTasRefreshbyKey(byte[] key) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 11];
        data[0] = 16;
        data[1] = (byte)(keylength + 4);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 4);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 5;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS Refresh failed");
    }

    public boolean setTasClearbyKey(byte[] key) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 11];
        data[0] = 16;
        data[1] = (byte)(keylength + 4);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 4);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 3;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS Clear failed");
    }

    public boolean setTasPeriodbyKey(byte[] key, int period) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 2;
        data[keylength + 11] = (byte)period;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS set period failed");
    }

    public boolean TasEXECbyKey(byte[] key, byte[] b2) throws IPMIException {
        int keylength = key.length;
        int dataLength = b2.length;
        if (keylength + dataLength + 4 > 127) {
            throw new IPMIException("Command length exceed limits");
        }
        byte[] data = new byte[keylength + dataLength + 11];
        data[0] = 16;
        data[1] = (byte)(keylength + dataLength + 4);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + dataLength + 4);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 4;
        System.arraycopy(b2, 0, data, keylength + 11, b2.length);
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("TAS execute command failed failed");
    }

    public byte[] getTASInfoArray() throws IPMIException {
        byte[] data = new byte[]{16, -52, 0, 0, 0, 0, 0, 32};
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte dataLength = resMessage.data[6];
                byte[] result = new byte[dataLength];
                System.arraycopy(resMessage.data, 7, result, 0, dataLength);
                return result;
            }
            if ((byte)(resMessage.completionCode & 0xFF) == -44) {
                throw new IPMIException("Firmware does not support TAS command");
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Get TAS Info failed");
    }

    public byte[] getTASLastUpdateTime() throws IPMIException {
        byte[] data = new byte[]{16, -54, 0, 0, 0, 0, 0, 32};
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0 && resMessage.data.length > 7) {
                byte[] result = new byte[4];
                System.arraycopy(resMessage.data, 7, result, 0, 4);
                return result;
            }
            if (resMessage.completionCode == 0) {
                return null;
            }
            if ((byte)(resMessage.completionCode & 0xFF) == -44) {
                throw new IPMIException("Firmware does not support TAS command");
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Get TAS Info failed");
    }

    public int getNVMEDeviceCount() throws IPMIException {
        byte[] data = new byte[]{16, -51, 0, 0, 0, 0, 0, 2};
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return ByteUtility.twoBytesToIntLSB(resMessage.data, 7);
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Get SMART Info failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSmartTotalDataLength(int device) throws IPMIException {
        byte[] data = new byte[8];
        ByteUtility.intTo2Bytes(data, 3, device);
        data[0] = 16;
        data[1] = -50;
        data[2] = 0;
        data[5] = 0;
        data[6] = 0;
        data[7] = 32;
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage == null) throw new IPMIException("Get SMART Info failed");
        if (resMessage.completionCode == 0) {
            return ByteUtility.twoBytesToIntLSB(resMessage.data, 2);
        }
        if (resMessage.completionCode != -56 && resMessage.completionCode != -52) throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        IPMIMessage resMessage2 = this.getSystemInfoParametersCommand(data);
        if (resMessage2 == null) throw new IPMIException("Get SMART Info failed, resMessage2 == null");
        if (resMessage2.completionCode != 0) throw new IPMIException("Get SMART Info failed");
        return ByteUtility.twoBytesToIntLSB(resMessage2.data, 2);
    }

    public boolean isFlagAvailable() throws IPMIException {
        byte[] data = new byte[]{16, -49, 0, 0, 0, 0, 0, 32};
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data.length <= 8;
            }
            if ((byte)(resMessage.completionCode & 0xFF) == -44) {
                throw new IPMIException("Firmware does not support TAS command");
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Get TAS Info failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNvmeDeviceName(int device) throws IPMIException {
        byte[] data = new byte[8];
        ByteUtility.intTo2Bytes(data, 3, device);
        data[0] = 16;
        data[1] = -50;
        data[2] = 0;
        data[5] = 0;
        data[6] = 0;
        data[7] = 32;
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage == null) throw new IPMIException("Get SMART Info failed");
        if (resMessage.completionCode == 0) {
            byte[] result = new byte[resMessage.data[6]];
            System.arraycopy(resMessage.data, 7, result, 0, result.length);
            String name = new String(result);
            return name.substring(name.indexOf(58) + 1, name.indexOf(59));
        }
        if (resMessage.completionCode != -56) {
            if (resMessage.completionCode != -52) throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        IPMIMessage resMessage2 = this.getSystemInfoParametersCommand(data);
        if (resMessage2 == null) throw new IPMIException("Get SMART Info failed, resMessage2 == null");
        if (resMessage2.completionCode != 0) throw new IPMIException("Get SMART Info failed");
        byte[] result = new byte[resMessage2.data[6]];
        System.arraycopy(resMessage2.data, 7, result, 0, result.length);
        String name = new String(result);
        return name.substring(name.indexOf(58) + 1, name.indexOf(59));
    }

    public void setNvmeRemovebyKey(byte[] key, int device) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 6;
        data[keylength + 11] = (byte)device;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Set NVME in band function failed");
    }

    public void setNvmeLocatebyKey(byte[] key, int device) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 7;
        data[keylength + 11] = (byte)device;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Set NVME in band function failed");
    }

    public void setNvmeStopLocatebyKey(byte[] key, int device) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 12];
        data[0] = 16;
        data[1] = (byte)(keylength + 5);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 5);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 8;
        data[keylength + 11] = (byte)device;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Set NVME in band function failed");
    }

    public void rescanbyKey(byte[] key) throws IPMIException {
        int keylength = key.length;
        byte[] data = new byte[keylength + 11];
        data[0] = 16;
        data[1] = (byte)(keylength + 4);
        data[2] = 0;
        data[3] = 0;
        data[4] = 0;
        data[5] = (byte)(keylength + 4);
        data[6] = 0;
        data[7] = 49;
        data[8] = 59;
        System.arraycopy(key, 0, data, 9, keylength);
        data[keylength + 9] = 59;
        data[keylength + 10] = 9;
        IPMIMessage resMessage = this.setSystemInfoParametersCommand((byte)-49, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Set NVME in band function failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getSmartRetunInfo(int device, int bitOffSet) throws IPMIException {
        byte[] data = new byte[8];
        ByteUtility.intTo2Bytes(data, 3, device);
        ByteUtility.intTo2Bytes(data, 5, bitOffSet);
        data[0] = 16;
        data[1] = -50;
        data[2] = 0;
        data[7] = 32;
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage == null) throw new IPMIException("Get SMART Info failed");
        if (resMessage.completionCode == 0) {
            return resMessage.data;
        }
        if (resMessage.completionCode != -56 && resMessage.completionCode != -52) throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        IPMIMessage resMessage2 = this.getSystemInfoParametersCommand(data);
        if (resMessage2 == null) throw new IPMIException("Get SMART Info failed, resMessage2 == null");
        if (resMessage2.completionCode != 0) throw new IPMIException("Get SMART Info failed");
        return resMessage2.data;
    }

    public byte[] getCommandResponse() throws IPMIException {
        byte[] data = new byte[]{16, -48, 0, 0, 0, 0, 0, 32};
        IPMIMessage resMessage = this.getSystemInfoParametersCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte responseLength = resMessage.data[6];
                if (responseLength == 0) {
                    return null;
                }
                byte[] result = new byte[responseLength];
                System.arraycopy(resMessage.data, 8, result, 0, responseLength);
                return result;
            }
            if ((byte)(resMessage.completionCode & 0xFF) == -44) {
                throw new IPMIException("Firmware does not support TAS command");
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Get TAS Info failed");
    }

    public boolean checkTASAlive() throws IPMIException {
        byte[] raw = this.getTASInfoArray();
        TASInfo tasInfo = this.createTASInfo(raw);
        if (tasInfo.isnull) {
            System.out.println("Please make sure TAS exist and restart TAS.");
            return false;
        }
        if (!tasInfo.status.equalsIgnoreCase("Running")) {
            System.out.println("TAS status is " + tasInfo.status);
            return false;
        }
        return true;
    }

    public SmartInfo createSmartStructure(String rawString) {
        SmartInfo smartInfo = new SmartInfo();
        smartInfo.fromRawString(rawString);
        return smartInfo;
    }

    public TASInfo createTASInfo(byte[] raw) {
        TASInfo tasInfo = new TASInfo();
        tasInfo.fromRaw(raw);
        return tasInfo;
    }

    public static void main(String[] args) throws IPMIException, IOException {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMITASCommand ipmiTASCommand = new IPMITASCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiTASCommand.setIPMIInterface(rmcp);
    }

    public static byte[] getModifiedMacAsKey() {
        InetAddress ip = null;
        byte[] mac = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (Exception e2) {
            boolean isIPv4 = true;
            try {
                ip = IPMITASCommand.getFirstNonLoopbackAddress(isIPv4, !isIPv4);
            }
            catch (Exception e1) {
                try {
                    ip = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException e22) {
                    e22.printStackTrace();
                }
            }
        }
        try {
            NetworkInterface network = null;
            network = IPMITASCommand.isWindowsPlatform() ? NetworkInterface.getByInetAddress(ip) : NetworkInterface.getByName("eth0");
            if (network != null) {
                mac = network.getHardwareAddress();
            } else {
                mac = new byte[5];
                for (int i2 = 0; i2 < 5; ++i2) {
                    mac[i2] = (byte)(Math.random() * 254.0);
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        if (mac != null) {
            for (int i3 = 0; i3 < mac.length; ++i3) {
                if (mac[i3] != 0 && mac[i3] != 59) continue;
                int n = i3;
                mac[n] = (byte)(mac[n] + 1);
            }
        }
        return mac;
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static boolean compareKeyFromResponse(byte[] originalKey, byte[] response) {
        int i2;
        int EndIndex = 0;
        for (i2 = 0; i2 < response.length; ++i2) {
            if (response[i2] != 59) continue;
            EndIndex = i2;
            break;
        }
        if (EndIndex != originalKey.length) {
            return false;
        }
        for (i2 = 0; i2 < originalKey.length; ++i2) {
            if (originalKey[i2] == response[i2]) continue;
            return false;
        }
        return true;
    }

    public static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws Exception {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i2 = en.nextElement();
            Enumeration<InetAddress> en2 = i2.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return InetAddress.getByName("127.0.0.1");
    }

    public class TASInfo {
        public boolean isnull = false;
        public String version;
        public String build;
        public String protocol_version;
        public String status;
        public String startTime;
        public String lastUpdateTime;

        public void fromRaw(byte[] raw) {
            LinkedList<byte[]> l = new LinkedList<byte[]>();
            int blockStart = 0;
            for (int i2 = 0; i2 < raw.length; ++i2) {
                if (raw[i2] != 59 || l.size() >= 4) continue;
                l.add(Arrays.copyOfRange(raw, blockStart, i2));
                i2 = blockStart = i2 + 1;
            }
            if (l.size() == 4) {
                l.add(Arrays.copyOfRange(raw, raw.length - 5, raw.length - 1));
            }
            if (l.size() != 5) {
                this.isnull = true;
                return;
            }
            this.version = new String((byte[])l.get(0));
            this.build = new String((byte[])l.get(1));
            this.protocol_version = new String((byte[])l.get(2));
            switch (((byte[])l.get(3))[0]) {
                case 48: {
                    this.status = "Paused";
                    break;
                }
                case 49: {
                    this.status = "Running";
                    break;
                }
                case 50: {
                    this.status = "Stopped";
                    break;
                }
                default: {
                    this.status = "Unknown";
                }
            }
            this.startTime = ByteUtility.fourByteToDateFormat2((byte[])l.get(4));
        }

        public void createLastUpdateTime(byte[] timestamp) {
            this.lastUpdateTime = ByteUtility.fourByteToDateFormat2(timestamp);
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-31s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-31s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f2, "Version", this.version));
            fStr.append(String.format(f2, "Build data", this.build));
            fStr.append(String.format(f2, "Protocol version", this.protocol_version));
            fStr.append(String.format(f2, "Status", this.status));
            fStr.append(String.format(f2, "TAS start time", this.startTime));
            fStr.append(String.format(f2, "Last Update Time", this.lastUpdateTime));
            return fStr.toString();
        }
    }

    public class SmartInfo
    implements Comparable<SmartInfo> {
        public int numberOfItems = 19;
        public String name;
        public String criticalWarning;
        public String temperature;
        public String spare;
        public String spareThreshold;
        public String percentageUsed;
        public String dataUnitsRead;
        public String dataUnitsWrite;
        public String hostRead;
        public String hostWrite;
        public String controllerBusyTime;
        public String powerCycle;
        public String powerOnHours;
        public String unsafeShutDowns;
        public String mediaErrors;
        public String errorEntries;
        public String vendor;
        public long capacity;
        public String serialNumber;
        public IPMINVMECommand.VPD vpd;

        public void fromRawString(String source) {
            for (int j2 = 0; j2 < this.numberOfItems; ++j2) {
                switch (j2) {
                    case 0: {
                        this.name = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 1: {
                        this.criticalWarning = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 2: {
                        this.temperature = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 3: {
                        this.spare = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 4: {
                        this.spareThreshold = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 5: {
                        this.percentageUsed = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 6: {
                        this.dataUnitsRead = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 7: {
                        this.dataUnitsWrite = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 8: {
                        this.hostRead = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 9: {
                        this.hostWrite = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 10: {
                        this.controllerBusyTime = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 11: {
                        this.powerCycle = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 12: {
                        this.powerOnHours = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 13: {
                        this.unsafeShutDowns = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 14: {
                        this.mediaErrors = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 15: {
                        this.errorEntries = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 16: {
                        this.vendor = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                        break;
                    }
                    case 17: {
                        try {
                            this.capacity = Long.parseLong(source.substring(source.indexOf(58) + 1, source.indexOf(59)));
                        }
                        catch (NumberFormatException e2) {
                            this.capacity = 0L;
                        }
                        break;
                    }
                    case 18: {
                        this.serialNumber = source.substring(source.indexOf(58) + 1, source.indexOf(59));
                    }
                }
                if (j2 == this.numberOfItems - 1) continue;
                source = source.substring(source.indexOf(59) + 1);
            }
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-31s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-31s | %20s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f2, "Device name", this.name));
            fStr.append(String.format(f2, "Critical warning", this.criticalWarning));
            fStr.append(String.format(f2, "IB Temp.", this.temperature));
            fStr.append(String.format(f2, "Available spare", this.spare));
            fStr.append(String.format(f2, "Available spare threshold", this.spareThreshold));
            fStr.append(String.format(f2, "Percentage used", this.percentageUsed));
            fStr.append(String.format(f2, "Data units read (512k bytes)", this.dataUnitsRead));
            fStr.append(String.format(f2, "Data units written (512k bytes)", this.dataUnitsWrite));
            fStr.append(String.format(f2, "Host read commands", this.hostRead));
            fStr.append(String.format(f2, "Host write commands", this.hostWrite));
            fStr.append(String.format(f2, "Controller busy time (minutes)", this.controllerBusyTime));
            fStr.append(String.format(f2, "Power cycles", this.powerCycle));
            fStr.append(String.format(f2, "Power on hours", this.powerOnHours));
            fStr.append(String.format(f2, "Unsafe shutdowns", this.unsafeShutDowns));
            fStr.append(String.format(f2, "Media errors", this.mediaErrors));
            fStr.append(String.format(f2, "Error log entries", this.errorEntries));
            return fStr.toString();
        }

        @Override
        public int compareTo(SmartInfo o) {
            if (this.name.length() <= 2 || o.name.length() <= 2) {
                return 0;
            }
            char ch = this.name.charAt(this.name.length() - 2);
            int number = ch >= '0' && ch <= '9' ? Integer.parseInt(this.name.substring(this.name.length() - 2)) : Integer.parseInt(this.name.substring(this.name.length() - 1));
            ch = o.name.charAt(o.name.length() - 2);
            int number1 = ch >= '0' && ch <= '9' ? Integer.parseInt(o.name.substring(o.name.length() - 2)) : Integer.parseInt(o.name.substring(o.name.length() - 1));
            return number - number1;
        }
    }
}

