/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.text.MOut;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class IPMITwinProMCUUpdater
extends IPMICommand {
    MOut mout = MOut.G();
    byte busID = (byte)7;
    byte enterToUpdateModeOffset = (byte)-6;
    IPMIMessagingCommand ipmiMessageCommand;
    IPMITwinProCommand ipmiTwinProCommand;
    IPMIAMIOEMCommand ipmiAMIOEMCommand;
    String mcuFirmwareName;

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMITwinProMCUUpdater(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.ipmiTwinProCommand = new IPMITwinProCommand(ipmiInterface);
        this.ipmiAMIOEMCommand = new IPMIAMIOEMCommand(ipmiInterface);
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiMessageCommand.setIPMIInterface(ipmiInterface);
        this.ipmiTwinProCommand.setIPMIInterface(ipmiInterface);
        this.ipmiAMIOEMCommand.setIPMIInterface(ipmiInterface);
    }

    public MCUFirmwareFile createMCUFirmwareFile(String filename) {
        return new MCUFirmwareFile(filename);
    }

    public void setMCUFirmwareName(String filename) {
        this.mcuFirmwareName = filename;
    }

    public boolean update() throws Exception {
        byte[] result;
        MCUFirmwareFile mcuFile;
        long start;
        int lastProgress;
        int currentProgress;
        block30: {
            currentProgress = 0;
            lastProgress = 0;
            start = System.currentTimeMillis();
            mcuFile = new MCUFirmwareFile(this.mcuFirmwareName);
            mcuFile.readToByteArray();
            try {
                if (this.ipmiAMIOEMCommand.getFirmwareUpdateStatus() != 0) {
                    this.mout.println("BMC is updating firmware");
                    return false;
                }
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
            try {
                if (!this.ipmiTwinProCommand.isSupportTwinProCommand()) {
                    this.mout.println("Not a compatible MCU");
                    return false;
                }
            }
            catch (Exception e1) {
                this.mout.println("No MCU exist");
                return false;
            }
            byte[] mcuVersion = this.ipmiTwinProCommand.getMCUVersion();
            if (mcuVersion != null) {
                this.mout.println("MCU Firmware :" + mcuVersion[0] + "." + ByteUtility.byteToHex(mcuVersion[1]));
                if (mcuVersion[0] == 1 && mcuVersion[1] == 0) {
                    this.enterToUpdateModeOffset = (byte)-11;
                }
            } else {
                this.mout.println("MCU Firmware : null");
            }
            this.mout.print("Enter to update mode... ");
            result = this.sendEnterToUpdateModeCommand();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int count = 0;
            while (true) {
                block29: {
                    try {
                        result = this.sendHandShakeCommand();
                        if (result[0] != 105 || result[1] != -45 || result[2] != -46 || result[3] != 38) break block29;
                        this.mout.println("OK");
                        break block30;
                    }
                    catch (IPMIException e2) {
                        e2.getIPMIMessage();
                        if (e2.getIPMIMessage().completionCode == -125) {
                            continue;
                        }
                    }
                    catch (Exception ei) {
                        throw ei;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ei) {
                    // empty catch block
                }
                if (count++ > 10) break;
            }
            this.mout.println("Failed: hand shake failed (try 10 times)");
            return false;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ei) {
            // empty catch block
        }
        this.mout.print("Progress:|");
        for (int i2 = 0; i2 < mcuFile.rawSize(); ++i2) {
            int retryCount = 0;
            boolean isRetry = true;
            do {
                try {
                    result = this.sendRawData(mcuFile.getRaw(i2));
                    isRetry = false;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IPMIException e3) {
                    ++retryCount;
                    isRetry = true;
                    this.mout.print(".");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (retryCount != 5) continue;
                    throw e3;
                }
            } while (isRetry);
            currentProgress = i2 * 100 / mcuFile.rawSize();
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        System.out.println("Done");
        return true;
    }

    private void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public byte[] sendEnterToUpdateModeCommand() throws Exception {
        byte[] dataToWrite = new byte[]{this.enterToUpdateModeOffset, -78, -91, 101, 75};
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, (byte)-128, (byte)0, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public byte[] sendHandShakeCommand() throws Exception {
        byte[] dataToWrite = new byte[]{-78, -91, 101, 75};
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, (byte)-86, (byte)4, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public byte[] sendRawData(byte[] dataToWrite) throws Exception {
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, (byte)-86, (byte)4, dataToWrite);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (TwinPro)");
    }

    public static void main_testFile(String[] args) throws Exception {
        IPMITwinProMCUUpdater i2 = new IPMITwinProMCUUpdater(null);
        MCUFirmwareFile f2 = i2.createMCUFirmwareFile("c:\\twinpro_1.06_0522.srec");
        f2.readToByteArray();
        System.out.println(f2.toString());
    }

    public class MCUFirmwareFile {
        ArrayList<byte[]> rawArray;
        String filename = "";

        public MCUFirmwareFile(String filename) {
            this.filename = filename;
            this.rawArray = new ArrayList();
        }

        public int rawSize() {
            return this.rawArray.size();
        }

        public byte[] getRaw(int index) {
            return this.rawArray.get(index);
        }

        public void readToByteArray() throws Exception {
            String line;
            File f2 = new File(this.filename);
            if (!f2.exists()) {
                throw new Exception("File is not exist");
            }
            BufferedReader in = new BufferedReader(new FileReader(this.filename));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0) continue;
                byte[] temp = this.srecToByteArray(line);
                this.rawArray.add(temp);
            }
            in.close();
        }

        public byte[] srecToByteArray(String record) throws Exception {
            if (record.length() < 4) {
                throw new Exception("Invalid firmware file: invalid record");
            }
            if (record.charAt(0) != 'S') {
                throw new Exception("Invalid firmware file: start char is not S");
            }
            if (record.charAt(1) < '0' || record.charAt(1) > '9') {
                throw new Exception("Invalid firmware file: 2nd char is not valid");
            }
            byte length = Byte.parseByte(record.substring(2, 4), 16);
            if (length != record.length() / 2 - 2) {
                throw new Exception("Invalid firmware file: record length is not match");
            }
            byte[] byteArray = new byte[record.length() / 2 + 1];
            byteArray[0] = 83;
            byteArray[1] = (byte)(48 + (byte)(record.charAt(1) - 48));
            byte[] tempArray = ByteUtility.hexToBytes(record.substring(2));
            System.arraycopy(tempArray, 0, byteArray, 2, tempArray.length);
            return byteArray;
        }

        public String toString() {
            String result = "";
            for (int i2 = 0; i2 < this.rawArray.size(); ++i2) {
                byte[] temp = this.rawArray.get(i2);
                result = result + ByteUtility.bytesToHex(temp) + "\n";
            }
            result = result + "Total = " + this.rawArray.size();
            return result;
        }
    }
}

