/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.RMCPPlusSessionController;
import com.supermicro.ipmi.RMCPSessionController;

public class IPMIVersion {
    public static int checkIPMIVersion(IPMIInterfaceConfig config) {
        RMCP rmcp = new RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
        MessageCenter.getInstance().put("Test RMCP+");
        IPMIMessage resMessage = ipmiMessagingCommand.GetChannelAuthenticationCapabilitiesCommandForPlus();
        if (resMessage != null && resMessage.completionCode == 0 && (resMessage.data[1] & 0xFFFFFF80 & 0xFF) > 1) {
            rmcp.closeSocket();
            return 2;
        }
        MessageCenter.getInstance().put("Test RMCP");
        resMessage = ipmiMessagingCommand.GetChannelAuthenticationCapabilitiesCommand();
        rmcp.closeSocket();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data[3] == 2) {
                    return 1;
                }
                return 0;
            }
            return 121;
        }
        return 121;
    }

    public static ISessionController getSessionController(IPMIInterfaceConfig config) {
        ISessionController sessionController = null;
        int version = IPMIVersion.checkIPMIVersion(config);
        switch (version) {
            case 1: {
                sessionController = new RMCPSessionController();
                break;
            }
            case 2: {
                sessionController = new RMCPPlusSessionController();
                break;
            }
            case 121: {
                return sessionController;
            }
            default: {
                sessionController = new RMCPPlusSessionController();
            }
        }
        return sessionController;
    }

    public static void main(String[] args) {
        RMCPSessionController rmcpSessionStartup = new RMCPSessionController();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.133.99.61");
        int version = IPMIVersion.checkIPMIVersion(config);
        switch (version) {
            case 0: {
                MessageCenter.getInstance().put("IPMI Version = 1.5");
                break;
            }
            case 1: {
                MessageCenter.getInstance().put("IPMI Version = 2.0");
                break;
            }
            case 2: {
                MessageCenter.getInstance().put("IPMI Version = 2.0+");
                break;
            }
            case 121: {
                MessageCenter.getInstance().put("IPMI Version unknown");
            }
        }
    }
}

