/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Checksum;
import org.apache.commons.codec.binary.Hex;

public class IPMIeBayPSUUpdateCommand
extends IPMICommand {
    IPMIMessagingCommand ipmiMessageCommand;
    ArrayList<BinaryData> bDataArray;
    byte busID = (byte)7;
    byte address = (byte)22;
    byte[] splitArray = new byte[]{0, 1, -120, 0};
    int splitIndex;

    public IPMIeBayPSUUpdateCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
    }

    public ArrayList<BinaryData> getbDataArray() {
        return this.bDataArray;
    }

    public boolean parseFile(String fileName) {
        try {
            Path path = Paths.get(fileName, new String[0]);
            byte[] originalContent = Files.readAllBytes(path);
            byte[] fwContent = Arrays.copyOfRange(originalContent, 0, originalContent.length - 1416);
            ByteArrayInputStream is = null;
            is = new ByteArrayInputStream(fwContent);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            this.bDataArray = new ArrayList();
            while (br.ready()) {
                BinaryData bData = new BinaryData();
                String str = br.readLine();
                if (str.length() != 0) {
                    bData.setLength((byte)Integer.parseInt(str.substring(1, 3), 16));
                    bData.setChecksum(Hex.decodeHex(str.substring(3, 7).toCharArray()));
                    bData.setOffset(Hex.decodeHex(str.substring(7, 15).toCharArray()));
                    if (str.length() > 15) {
                        bData.setData(Hex.decodeHex(str.substring(15, str.length()).toCharArray()));
                    }
                    this.bDataArray.add(bData);
                    continue;
                }
                break;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    private byte calcPEC(byte[] array) {
        CRC8 crc = new CRC8();
        crc.reset();
        crc.update(array);
        return (byte)crc.getValue();
    }

    private byte[] blockRead(byte slaveAddress, byte cmd, byte count) throws Exception {
        IPMIMessage resMessage;
        int retry = 5;
        byte[] dataArray = new byte[]{cmd};
        while ((resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, slaveAddress, count, dataArray)) != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            if (resMessage.completionCode == -125 && retry > 0) {
                --retry;
                Thread.sleep(1000L);
                continue;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call Block Read filed");
    }

    private void blockWriteWithPEC(byte slaveAddress, byte cmd, byte[] data) throws Exception {
        IPMIMessage resMessage;
        int retry = 5;
        byte[] dataArray = new byte[data.length + 3];
        byte[] pecArray = new byte[data.length + 3];
        pecArray[0] = slaveAddress;
        pecArray[1] = cmd;
        pecArray[2] = (byte)data.length;
        System.arraycopy(data, 0, pecArray, 3, data.length);
        dataArray[0] = cmd;
        dataArray[1] = (byte)data.length;
        System.arraycopy(data, 0, dataArray, 2, data.length);
        dataArray[dataArray.length - 1] = this.calcPEC(pecArray);
        while ((resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, slaveAddress, (byte)0, dataArray)) != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -125 && retry > 0) {
                --retry;
                Thread.sleep(1000L);
                continue;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call Block Write With PEC filed");
    }

    private void writeByteWithPEC(byte slaveAddress, byte cmd, byte data) throws Exception {
        IPMIMessage resMessage;
        int retry = 5;
        byte[] pecArray = new byte[3];
        byte[] dataArray = new byte[3];
        pecArray[0] = slaveAddress;
        pecArray[1] = cmd;
        pecArray[2] = data;
        dataArray[0] = cmd;
        dataArray[1] = data;
        dataArray[2] = this.calcPEC(pecArray);
        while ((resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, slaveAddress, (byte)0, dataArray)) != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -125 && retry > 0) {
                --retry;
                Thread.sleep(1000L);
                continue;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call Write Byte With PEC filed");
    }

    private void sendByteWithPEC(byte slaveAddress, byte cmd) throws Exception {
        IPMIMessage resMessage;
        int retry = 5;
        byte[] pecArray = new byte[2];
        byte[] dataArray = new byte[2];
        pecArray[0] = slaveAddress;
        pecArray[1] = cmd;
        dataArray[0] = cmd;
        dataArray[1] = this.calcPEC(pecArray);
        while ((resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, slaveAddress, (byte)0, dataArray)) != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            if (resMessage.completionCode == -125 && retry > 0) {
                --retry;
                Thread.sleep(1000L);
                continue;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call Send Byte With PEC filed");
    }

    public byte[] enterRomMode(byte slaveAddress) throws Exception {
        byte[] data = new byte[]{-39};
        IPMIMessage resMessage = this.ipmiMessageCommand.masterWriteReadCommand(this.busID, slaveAddress, (byte)0, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call MasterWriteReadCommand failed (Enter ROM Mode)");
    }

    public byte[] determineDeviceTypeAndROMVersion() throws IPMIException {
        try {
            return this.blockRead(this.address, (byte)-20, (byte)5);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Determine Device Type And ROM Version)");
        }
    }

    public void enableAccessToControlRegisters() throws IPMIException {
        byte[] data = new byte[]{0, 1, -112, 16, 63, -78, 24, 107};
        try {
            this.blockWriteWithPEC(this.address, (byte)-11, data);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Eanble Access to Control Register)");
        }
    }

    public void enableAccessToTrimFlash() throws IPMIException {
        byte[] data = new byte[]{-1, -1, -2, 102, 0, 0, 4, 0};
        try {
            this.blockWriteWithPEC(this.address, (byte)-11, data);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Eanble Access to Trim Flash)");
        }
    }

    public void clearTheInfoBlockEnableBit() throws IPMIException {
        byte[] data = new byte[]{-1, -1, -2, 102, 0, 0, 0, 0};
        try {
            this.blockWriteWithPEC(this.address, (byte)-11, data);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Clear The Block Enable Bit)");
        }
    }

    public void setRAMLocationReplaceWithZero() throws Exception {
        byte[] data = new byte[]{0, 1, -112, 16, 0, 0, 0, 0};
        try {
            this.blockWriteWithPEC(this.address, (byte)-11, data);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Set RAM Location Replace With 0)");
        }
    }

    public void eraseAllOfProgramFlashStart() throws Exception {
        byte data = 1;
        try {
            this.writeByteWithPEC(this.address, (byte)-14, data);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Erase All Of Program Flash Start)");
        }
        Thread.sleep(25L);
    }

    public void startToProgram() throws Exception {
        for (int i2 = 0; i2 < this.bDataArray.size(); ++i2) {
            byte[] data = new byte[20];
            BinaryData bData = this.bDataArray.get(i2);
            if (bData.getData() == null || bData.getData().length <= 0) continue;
            if (ByteUtility.fourBytesToLong(bData.getOffset()) >= ByteUtility.fourBytesToLong(this.splitArray)) {
                this.splitIndex = i2;
                break;
            }
            Arrays.fill(data, (byte)0);
            if (bData.getData().length == 16 || bData.getData().length == 32) {
                System.arraycopy(bData.getOffset(), 0, data, 0, 4);
                data[1] = (byte)(data[1] + 1);
                System.arraycopy(bData.getData(), 0, data, 4, 16);
                try {
                    this.blockWriteWithPEC(this.address, (byte)-12, data);
                    Thread.sleep(25L);
                }
                catch (Exception e2) {
                    throw new IPMIException("Call MasterWriteReadCommand failed (Start To Program)");
                }
                if (bData.getData().length != 32) continue;
                System.arraycopy(bData.getData(), 16, data, 4, 16);
                data[3] = (byte)(data[3] + 16);
                try {
                    this.blockWriteWithPEC(this.address, (byte)-12, data);
                    Thread.sleep(25L);
                    continue;
                }
                catch (Exception e3) {
                    throw new IPMIException("Call MasterWriteReadCommand failed (Start To Program)");
                }
            }
            BinaryData nextBData = this.bDataArray.get(i2 + 1);
            if (nextBData.getData() == null || nextBData.getData().length == 0) {
                this.bDataArray.remove(i2 + 1);
                --i2;
                continue;
            }
            if (ByteUtility.fourBytesToLong(nextBData.getOffset()) >= ByteUtility.fourBytesToLong(this.splitArray)) {
                Arrays.fill(data, (byte)-1);
                System.arraycopy(bData.getOffset(), 0, data, 0, 4);
                data[1] = (byte)(data[1] + 1);
                System.arraycopy(bData.getData(), 0, data, 4, bData.getData().length);
                try {
                    this.blockWriteWithPEC(this.address, (byte)-12, data);
                    Thread.sleep(25L);
                    continue;
                }
                catch (Exception e4) {
                    throw new IPMIException("Call MasterWriteReadCommand failed (Start To Program)");
                }
            }
            int gap = bData.getData().length + nextBData.getData().length >= 32 ? 32 - bData.getData().length : nextBData.getData().length;
            byte[] tempData = new byte[bData.getData().length + gap];
            System.arraycopy(bData.getData(), 0, tempData, 0, bData.getData().length);
            System.arraycopy(nextBData.getData(), 0, tempData, bData.getData().length, gap);
            this.bDataArray.get(i2).setData(tempData);
            byte[] nextOffset = new byte[4];
            int nextOffsetVal = ByteUtility.fourBytesToInt(bData.getOffset()) + 32;
            nextOffset[0] = (byte)(nextOffsetVal >> 24);
            nextOffset[1] = (byte)(nextOffsetVal >> 16);
            nextOffset[2] = (byte)(nextOffsetVal >> 8);
            nextOffset[3] = (byte)nextOffsetVal;
            this.bDataArray.get(i2 + 1).setOffset(nextOffset);
            int nextDataLength = nextBData.getData().length - gap;
            if (nextDataLength > 0) {
                byte[] nextData = new byte[nextDataLength];
                System.arraycopy(nextBData.getData(), gap, nextData, 0, nextDataLength);
                this.bDataArray.get(i2 + 1).setData(nextData);
            } else {
                this.bDataArray.get(i2 + 1).setData(null);
            }
            --i2;
        }
    }

    public void eraseAllOfProgramFlashEnd() throws Exception {
        byte data = 0;
        try {
            this.writeByteWithPEC(this.address, (byte)-14, data);
            Thread.sleep(25L);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Erase All Of Program Flash End)");
        }
    }

    public void startToProgram2() throws Exception {
        for (int i2 = this.splitIndex; i2 < this.bDataArray.size(); ++i2) {
            byte[] data = new byte[20];
            BinaryData bData = this.bDataArray.get(i2);
            if (bData.getLength() <= 0) continue;
            if ((ByteUtility.fourBytesToLong(bData.getOffset()) & 0xFFFFFFFFFFFF8000L) != 98304L) {
                this.splitIndex = i2;
                break;
            }
            Arrays.fill(data, (byte)0);
            System.arraycopy(bData.getOffset(), 0, data, 0, 4);
            System.arraycopy(bData.getData(), 0, data, 4, bData.getData().length >= 16 ? 16 : bData.getData().length);
            try {
                this.blockWriteWithPEC(this.address, (byte)-12, data);
                Thread.sleep(25L);
            }
            catch (Exception e2) {
                throw new IPMIException("Call MasterWriteReadCommand failed (Start To Program 2)");
            }
            if (bData.getData().length <= 16) continue;
            Arrays.fill(data, (byte)0);
            System.arraycopy(bData.getOffset(), 0, data, 0, 4);
            System.arraycopy(bData.getData(), 16, data, 4, bData.getData().length >= 16 ? 16 : bData.getData().length);
            data[3] = (byte)(data[3] + 16);
            try {
                this.blockWriteWithPEC(this.address, (byte)-12, data);
                Thread.sleep(25L);
                continue;
            }
            catch (Exception e3) {
                throw new IPMIException("Call MasterWriteReadCommand failed (Start To Program 2)");
            }
        }
    }

    public void requiredCalculateCheckSum() throws Exception {
        byte[] data = new byte[]{0, 1, 0, 0, 0, 0, 127, -4};
        try {
            this.blockWriteWithPEC(this.address, (byte)-17, data);
            Thread.sleep(20L);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Required Calculate Checksum)");
        }
    }

    public byte[] getCheckSum() throws Exception {
        try {
            byte[] val = new byte[4];
            byte[] temp = this.blockRead(this.address, (byte)-18, (byte)5);
            System.arraycopy(temp, 1, val, 0, val.length);
            return val;
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Get Checksum)");
        }
    }

    public void writeCheckSum(byte[] checksum) throws Exception {
        byte[] data = new byte[]{0, 1, 127, -4, checksum[0], checksum[1], checksum[2], checksum[3]};
        try {
            this.blockWriteWithPEC(this.address, (byte)-11, data);
            Thread.sleep(20L);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Write Checksum)");
        }
    }

    public void reconfigure() throws Exception {
        try {
            this.sendByteWithPEC(this.address, (byte)-16);
        }
        catch (Exception e2) {
            throw new IPMIException("Call MasterWriteReadCommand failed (Reconfigure)");
        }
    }

    private class CRC8
    implements Checksum {
        private static final int poly = 263;
        private int crc = 0;

        private CRC8() {
        }

        @Override
        public void update(byte[] input, int offset, int len) {
            for (int i2 = 0; i2 < len; ++i2) {
                this.update(input[offset + i2]);
            }
        }

        @Override
        public void update(byte[] input) {
            this.update(input, 0, input.length);
        }

        private final void update(byte b2) {
            this.crc ^= b2;
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((this.crc & 0x80) != 0) {
                    this.crc = this.crc << 1 ^ 0x107;
                    continue;
                }
                this.crc <<= 1;
            }
            this.crc &= 0xFF;
        }

        @Override
        public void update(int b2) {
            this.update((byte)b2);
        }

        @Override
        public long getValue() {
            return this.crc & 0xFF;
        }

        @Override
        public void reset() {
            this.crc = 0;
        }
    }

    public class BinaryData {
        private byte length;
        private byte[] checksum;
        private byte[] offset;
        private byte[] data;

        public byte getLength() {
            return this.length;
        }

        public void setLength(byte length) {
            this.length = length;
        }

        public byte[] getChecksum() {
            return this.checksum;
        }

        public void setChecksum(byte[] checksum) {
            this.checksum = checksum;
        }

        public byte[] getOffset() {
            return this.offset;
        }

        public void setOffset(byte[] offset) {
            this.offset = offset;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }
    }
}

