/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.MCUUpdateInterface;
import java.util.Arrays;

class MCUA6Update
extends MCUUpdateInterface {
    MCUA6Update() {
    }

    @Override
    boolean validatePrerequisites() {
        try {
            if (this.ipmiTwinProComm.getNodeID() != 1) {
                this.mout.println("The operation node must be A node.");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    boolean verifyFileFormat() {
        this.ver = new byte[]{85, 72};
        int position = this.indexOf(this.mcuFirmware, this.ver);
        if (position == -1) {
            this.mout.println("Can't get CPLD platform information from this file.");
            return false;
        }
        String mbBPNFromFile = new String(Arrays.copyOfRange(this.mcuFirmware, position + 2, position + 6));
        String mbBPN = null;
        byte readCount = 2;
        byte[] dataToWrite = new byte[]{125};
        try {
            mbBPN = ByteUtility.bytesToHexNoSpace(this.ipmiTwinProComm.sendTwinPro80hCommand(readCount, dataToWrite));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        if (!mbBPN.equals(mbBPNFromFile)) {
            this.mout.println("CPLD platform is not matched.");
            return false;
        }
        return true;
    }

    @Override
    boolean isNodesShutdown() {
        try {
            for (int i2 = 0; i2 < this.ipmiTwinProComm.getTwinProMCU().nodeSize; ++i2) {
                if (!"Active".equals(this.ipmiTwinProComm.getTwinProMCU().displayPsonString((byte)i2))) continue;
                this.mout.println("Please power off all nodes for mcu updating.");
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }
}

