/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.MCUUpdateInterface;

class MCUA8Update
extends MCUUpdateInterface {
    MCUA8Update() {
    }

    @Override
    boolean validatePrerequisites() {
        try {
            if (this.ipmiTwinProComm.deviceType == 1 || this.ipmiTwinProComm.deviceType != 1 && (this.ipmiTwinProComm.getConfigID() == 5 || this.ipmiTwinProComm.getConfigID() != 5 && (this.ipmiTwinProComm.getBPLocation() == 1 || this.ipmiTwinProComm.getBPLocation() == 16))) {
                this.mout.println("This command is not supported.");
                return false;
            }
            if (this.ipmiTwinProComm.getNodeID() != 1) {
                this.mout.println("The operation node must be A node.");
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    boolean verifyFileFormat() {
        int position = this.indexOf(this.mcuFirmware, this.ver);
        if (position == -1) {
            this.mout.println("Can't get MUC ID from the file");
            return false;
        }
        String newFW = ByteUtility.byteToHex(this.mcuFirmware[position + 7]).trim();
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-3};
        String mcuID = "";
        try {
            mcuID = ByteUtility.bytesToHex(this.ipmiTwinProComm.sendTwinPro80hCommand(readCount, dataToWrite)).trim();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        if (!mcuID.equals(newFW)) {
            this.mout.println("MCU ID is not matched.");
            return false;
        }
        return true;
    }
}

