/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MDRRegionLockCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;

public class MDRRegionUpdateCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte smbiosRegion = 1;
    final byte iSCSIRegion = (byte)4;
    byte completionCode;
    byte result;
    boolean isResult;

    public MDRRegionUpdateCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public byte getResult() {
        return this.result;
    }

    public MDRRegionUpdateCommand setMDRRegionUpdate(byte sessionLock) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, sessionLock, 4};
        ipmiMessage.setCommandAndData((byte)-80, (byte)33, data);
        IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
        MDRRegionUpdateCommand mdrRegionUpdate = new MDRRegionUpdateCommand(this.getIPMIInterface());
        if (resMessage != null) {
            mdrRegionUpdate.completionCode = resMessage.completionCode;
            switch (this.completionCode) {
                case -127: {
                    MOut.G().print("Region is in use by another user (0x81)");
                    break;
                }
                case -55: {
                    MOut.G().print("Invalid Region Specified (0xC9)");
                    break;
                }
                case -43: {
                    MOut.G().print("Region is not locked (0xD5)");
                    break;
                }
                case 0: {
                    try {
                        mdrRegionUpdate.result = resMessage.data[0];
                        mdrRegionUpdate.isResult = true;
                        break;
                    }
                    catch (Exception e2) {
                        mdrRegionUpdate.isResult = false;
                    }
                }
            }
        }
        return mdrRegionUpdate;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %21s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-20s | %21s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Result", this.isResult ? "Normal (0x" + ByteUtility.byteToHex(this.completionCode) + ")" : "N/A"));
        fStr.append(String.format(format, "Type", this.isResult ? "Intel RSD Spec (0x" + ByteUtility.byteToHex(this.getResult()) + ")" : "N/A"));
        return fStr.toString();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        MDRRegionLockCommand mdrRegionLock = new MDRRegionLockCommand(rmcp);
        mdrRegionLock = mdrRegionLock.getMDRRegionLock();
        MDRRegionUpdateCommand mdrRegionUpdate = new MDRRegionUpdateCommand(rmcp);
        mdrRegionUpdate = mdrRegionUpdate.setMDRRegionUpdate(mdrRegionLock.getSessionLock());
        MOut.G().print(mdrRegionUpdate.toFormatedHeader());
        MOut.G().print(mdrRegionUpdate.toFormatedString());
    }
}

