/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class MarvellRaidCommand
extends IPMICommand {
    public static final byte MARV_RSP_SUCCESS = 0;
    public static final byte MARV_RSP_CHKSUM_ERR = 1;
    public static final byte MARV_RSP_INVALID_REQ = 2;
    public static final byte MARV_RSP_DEV_BUSY = 3;
    public static final byte MARV_RSP_DEV_NONE = 4;
    public static final byte MARV_RSP_DEV_FAIL = 5;
    public static final byte MARV_RSP_DEV_BGA_RUNNING = 6;
    public static final byte MARV_RSP_DEV_TIMEOUT = 7;
    public static final byte MARV_RSP_DEV_UNKOWN = -1;
    public static final byte MARV_CMD_GET_CTRL_INFO = 0;
    public static final byte MARV_CMD_GET_BACKEND_STAT = 1;
    public static final byte MARV_CMD_GET_COMP_VER_INFO = 2;
    public static final byte MARV_CMD_GET_VD_INFO = 3;
    public static final byte MARV_CMD_GET_PD_INFO = 4;
    public static final byte MARV_CMD_GET_MEDIA_PATROL_INFO = 5;
    public static final byte MARV_CMD_CREATE_VD = 6;
    public static final byte MARV_CMD_DELETE_VD = 7;
    public static final byte MARV_CMD_REBUILD_VD = 8;
    public static final byte MARV_CMD_IMPORT_VD = 9;
    public static final byte MARV_CMD_SET_MEDIA_PATROL = 10;
    public static final byte MARV_CMD_SET_PD_ATA_DATA = 11;
    public static final byte MARV_CMD_GET_PD_ATA_DATA = 12;
    public static final byte MARV_CMD_FW_START_UPDATE = 13;
    public static final byte MARV_CMD_FW_TRANSMIT_DATA = 14;
    public static final byte MARV_CMD_FW_CHECK_STATUS = 15;
    public static final byte MARV_CMD_FW_VERIFY_CHECKSUM = 16;
    public static final byte MARV_CMD_FW_RETURN_CHECKSUM = 17;
    public static final byte MARV_CMD_GET_VPD = 18;
    public static final byte MARV_CMD_SET_VPD = 19;
    public static final byte MARV_CMD_OPERATE_VPD_FLASH = 20;
    public static final int PNStrPosition = 3;
    public static final int PNLength = 24;
    public static final int PCBVerPosition = 35;
    public static final int PCBVerLength = 8;
    public static final int SerialNumberPosition = 67;
    public static final int SerailNumberLength = 24;
    public static final int FWStrPosition = 115;
    public static final int FWLength = 29;
    public static final int MfgDateTimeStrPosition = 144;
    public static final int MfgDateTimeStrLength = 16;
    public static final int BatchStrPosition = 160;
    public static final int BatchStrLength = 8;
    public static final int ControllerStrPosition = 176;
    public static final int ControllerStrLength = 24;

    public MarvellRaidCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage MarvellRaidStatusCommand(byte dataSync, byte aoc, byte index, byte[] array) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + array.length];
        data[0] = dataSync;
        data[1] = aoc;
        data[2] = index;
        System.arraycopy(array, 0, data, 3, array.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-78, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getComponentVersionCommand(byte aoc, byte componentID) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, aoc, 2, componentID};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-78, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte LoadSPIFlash(byte datasync, byte aoc) throws IPMIException {
        byte[] data = new byte[]{0};
        IPMIMessage resMessage = this.MarvellRaidStatusCommand(datasync, aoc, (byte)20, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDCommand failed");
    }

    public byte StoreSPIFlash(byte datasync, byte aoc) throws IPMIException {
        byte[] data = new byte[]{1};
        IPMIMessage resMessage = this.MarvellRaidStatusCommand(datasync, aoc, (byte)20, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getNVMEVPDCommand failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readVPDbyPage(byte datasync, byte aoc, byte page) {
        byte[] VPD2 = new byte[16];
        byte[] data = new byte[]{page};
        IPMIMessage resMessage = this.MarvellRaidStatusCommand(datasync, aoc, (byte)18, data);
        if (resMessage == null) return VPD2;
        if (resMessage.completionCode != 0) return null;
        if (resMessage.data[0] != 0) return null;
        System.arraycopy(resMessage.data, 1, VPD2, 0, 16);
        return VPD2;
    }

    public byte writeVPDbyPage(byte datasync, byte aoc, byte page, byte[] value) throws IPMIException {
        byte[] data = new byte[17];
        data[0] = page;
        System.arraycopy(value, 0, data, 1, value.length);
        for (int i2 = value.length + 1; i2 < 17; ++i2) {
            data[i2] = -1;
        }
        IPMIMessage resMessage = this.MarvellRaidStatusCommand(datasync, aoc, (byte)19, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call writeVPDbyPage failed");
    }

    public boolean writePN(String value) {
        int page = 0;
        value = "PN:" + value;
        byte[] data = value.getBytes();
        if (data.length <= 16) {
            try {
                this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
                data = new byte[]{-1};
                this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), data);
                return true;
            }
            catch (IPMIException e2) {
                return false;
            }
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, 0, temp, 0, 16);
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, temp);
            temp = new byte[data.length - 16];
            System.arraycopy(data, 16, temp, 0, temp.length);
            this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), temp);
            return true;
        }
        catch (IPMIException e3) {
            return false;
        }
    }

    public boolean writePCBVersion(String value) {
        int page = 2;
        value = "VP:" + value;
        byte[] data = value.getBytes();
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
            return true;
        }
        catch (IPMIException e2) {
            return false;
        }
    }

    public boolean writeSerialNumber(String value) {
        int page = 4;
        value = "SN:" + value;
        byte[] data = value.getBytes();
        if (data.length <= 16) {
            try {
                this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
                data = new byte[]{-1};
                this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), data);
                return true;
            }
            catch (IPMIException e2) {
                return false;
            }
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, 0, temp, 0, 16);
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, temp);
            temp = new byte[data.length - 16];
            System.arraycopy(data, 16, temp, 0, temp.length);
            this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), temp);
            return true;
        }
        catch (IPMIException e3) {
            return false;
        }
    }

    public boolean writeFWVersion(String value) {
        int page = 7;
        value = "FW:" + value;
        byte[] data = value.getBytes();
        if (data.length <= 16) {
            try {
                this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
                data = new byte[]{-1};
                this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), data);
                return true;
            }
            catch (IPMIException e2) {
                return false;
            }
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, 0, temp, 0, 16);
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, temp);
            temp = new byte[data.length - 16];
            System.arraycopy(data, 16, temp, 0, temp.length);
            this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), temp);
            return true;
        }
        catch (IPMIException e3) {
            return false;
        }
    }

    public boolean writeMfgDateTime(String value) {
        int page = 9;
        byte[] data = value.getBytes();
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
            return true;
        }
        catch (IPMIException e2) {
            return false;
        }
    }

    public boolean writeBatch(String value) {
        int page = 10;
        byte[] data = value.getBytes();
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
            return true;
        }
        catch (IPMIException e2) {
            return false;
        }
    }

    public boolean writeController(String value) {
        int page = 11;
        byte[] data = value.getBytes();
        if (data.length <= 16) {
            try {
                this.writeVPDbyPage((byte)1, (byte)0, (byte)page, data);
                data = new byte[]{-1};
                this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), data);
                return true;
            }
            catch (IPMIException e2) {
                return false;
            }
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, 0, temp, 0, 16);
        try {
            this.writeVPDbyPage((byte)1, (byte)0, (byte)page, temp);
            temp = new byte[data.length - 16];
            System.arraycopy(data, 16, temp, 0, temp.length);
            this.writeVPDbyPage((byte)1, (byte)0, (byte)(page + 1), temp);
            return true;
        }
        catch (IPMIException e3) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getControllerVersion(byte aoc, byte componentID) throws IPMIException {
        String s = "";
        byte[] buildDate = new byte[2];
        IPMIMessage resMessage = this.getComponentVersionCommand(aoc, componentID);
        if (resMessage == null) return s;
        if (resMessage.completionCode != 0) return "N/A";
        if (resMessage.data[0] != 0) return "N/A";
        System.arraycopy(resMessage.data, 4, buildDate, 0, 2);
        return (resMessage.data[2] >> 4) + "." + (resMessage.data[2] & 0xF) + "." + resMessage.data[3] + "." + ByteUtility.twoBytesToIntMSB(buildDate);
    }

    public VPD getVPD(byte[] raw) {
        VPD vpd = new VPD();
        vpd.fromRaw(raw);
        return vpd;
    }

    public class VPD {
        public String PNStr;
        public String PCBVer;
        public String SerialNumber;
        public String FWVer;
        public String MfgDate;
        public String MfgTime;
        public String Batch;
        public String Controller;
        public byte checksum;

        public void fromRaw(byte[] raw) {
            byte[] temp = new byte[24];
            System.arraycopy(raw, 3, temp, 0, 24);
            this.PNStr = new String(temp);
            this.PNStr = this.PNStr.trim();
            temp = new byte[8];
            System.arraycopy(raw, 35, temp, 0, 8);
            this.PCBVer = new String(temp);
            this.PCBVer = this.PCBVer.trim();
            temp = new byte[24];
            System.arraycopy(raw, 67, temp, 0, 24);
            this.SerialNumber = new String(temp);
            this.SerialNumber = this.SerialNumber.trim();
            temp = new byte[29];
            System.arraycopy(raw, 115, temp, 0, 29);
            this.FWVer = new String(temp);
            this.FWVer = this.FWVer.trim();
            temp = new byte[8];
            System.arraycopy(raw, 144, temp, 0, 8);
            this.MfgDate = new String(temp);
            this.MfgDate = this.MfgDate.trim();
            temp = new byte[8];
            System.arraycopy(raw, 152, temp, 0, 8);
            this.MfgTime = new String(temp);
            this.MfgTime = this.MfgTime.trim();
            temp = new byte[8];
            System.arraycopy(raw, 160, temp, 0, 8);
            this.Batch = new String(temp);
            this.Batch = this.Batch.trim();
            temp = new byte[24];
            System.arraycopy(raw, 176, temp, 0, 24);
            this.Controller = new String(temp);
            this.Controller = this.Controller.trim();
            this.checksum = raw[255];
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %30s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f2 = " %-30s | %30s \n";
            StringBuffer fStr = new StringBuffer();
            String dateTime = this.MfgDate;
            if (this.MfgTime != null && this.MfgTime.length() != 0) {
                dateTime = dateTime + " / " + this.MfgTime;
            }
            fStr.append(String.format(f2, "PN: ", this.PNStr));
            fStr.append(String.format(f2, "AOC Version: ", this.PCBVer));
            fStr.append(String.format(f2, "Serial Number: ", this.SerialNumber));
            fStr.append(String.format(f2, "Firmware Version: ", this.FWVer));
            fStr.append(String.format(f2, "Manufactured Date/Time: ", dateTime));
            fStr.append(String.format(f2, "Batch: ", this.Batch));
            fStr.append(String.format(f2, "Controller: ", this.Controller));
            return fStr.toString();
        }
    }
}

