/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.stunnel.StunnelUtility;

public class PowerSwitchTest {
    public static void main(String[] args) {
        boolean GRACEFUL_OFF = false;
        boolean CHASSIS_OFF = true;
        String id = StunnelUtility.testADMIN();
        String pw = StunnelUtility.testADMIN();
        int testType = 0;
        int powerOnDelay = 0;
        int powerOffDelay = 0;
        int testCount = 0;
        if (args.length != 4) {
            System.out.println("Usage:");
            System.out.println("      PowerSwitchTest <type> <IP> <powerOnDelay> <powerOffDelay>");
            System.out.println("      <type> 0:graceful shutdown");
            System.out.println("      <type> 1:power down");
            return;
        }
        testType = Integer.parseInt(args[0]);
        String ip = args[1];
        powerOnDelay = Integer.parseInt(args[2]);
        powerOffDelay = Integer.parseInt(args[3]);
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(pw);
        config.setPrivilege((byte)4);
        while (true) {
            boolean b2;
            switch (testType) {
                case 0: {
                    b2 = PowerSwitchTest.gracefulPowerDown(config);
                    LogUtil.printLog("Graceful shutdown : " + (b2 ? "ok" : "fail"));
                    break;
                }
                case 1: {
                    b2 = PowerSwitchTest.powerDown(config);
                    LogUtil.printLog("Power down        : " + (b2 ? "ok" : "fail"));
                    break;
                }
            }
            try {
                Thread.sleep(powerOnDelay * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            b2 = PowerSwitchTest.powerUp(config);
            LogUtil.printLog("Power on          : " + (b2 ? "ok" : "fail") + "  (Test Counter : " + ++testCount + ")");
            try {
                Thread.sleep(powerOffDelay * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static boolean gracefulPowerDown(IPMIInterfaceConfig config) {
        boolean b2 = false;
        try {
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
            b2 = ipmiChassisCommand.softShutdown();
            sessionController.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b2;
    }

    public static boolean powerDown(IPMIInterfaceConfig config) {
        boolean b2 = false;
        try {
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
            b2 = ipmiChassisCommand.powerDown();
            sessionController.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b2;
    }

    public static boolean powerUp(IPMIInterfaceConfig config) {
        boolean b2 = false;
        try {
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
            b2 = ipmiChassisCommand.powerUp();
            sessionController.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b2;
    }
}

