/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.UART;
import com.supermicro.ipmi.UARTTerminalProtocol;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UARTImpl
implements UART {
    SerialPort serialPort;
    OutputStream out;
    InputStream in;

    @Override
    public void initialUART(String portName, int baudRate, int dataBits, int stopBits, int parity, int flowControl, String username, String password) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new Exception("Port in use!");
        }
        this.serialPort = (SerialPort)portIdentifier.open("BMC", 2000);
        this.serialPort.enableReceiveTimeout(500);
        this.serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
        this.serialPort.setFlowControlMode(flowControl);
        this.out = this.serialPort.getOutputStream();
        this.in = this.serialPort.getInputStream();
        if (!this.checkMode()) {
            throw new Exception("BMC serial port is not ready!");
        }
        if (!this.checkMode()) {
            throw new Exception("Authentication failed !");
        }
        System.out.println("Setup done!");
    }

    public boolean checkMode() throws Exception {
        byte[] bytes = new byte[1024];
        DataInputStream dis = new DataInputStream(this.in);
        this.out.write("[SYS TMODE]\n".getBytes());
        this.out.flush();
        int readCount = dis.read(bytes);
        if (readCount <= 0) {
            return false;
        }
        String result = new String(bytes);
        return result.indexOf("[OK TMODE]") != -1;
    }

    public boolean login(String username, String password) throws Exception {
        byte[] bytes = new byte[1024];
        DataInputStream dis = new DataInputStream(this.in);
        this.out.write(("[SYS PWD -U " + username + " " + password + "]\n").getBytes());
        this.out.flush();
        int readCount = dis.read(bytes);
        if (readCount <= 0) {
            return false;
        }
        String result = new String(bytes);
        return result.indexOf("[OK]") != -1;
    }

    @Override
    public IPMIMessage send(IIPMIMessage ipmiMessage) {
        try {
            int nRead;
            byte[] bytes = ipmiMessage.raw();
            this.out.write(UARTTerminalProtocol.toTerminalCommand(bytes).getBytes());
            this.out.flush();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = this.in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] resBytes = buffer.toByteArray();
            byte[] fromTerminalCommand = UARTTerminalProtocol.fromTerminalCommand(new String(resBytes));
            if (fromTerminalCommand != null) {
                IPMIMessage resMessage = IPMIMessage.fromRaw(fromTerminalCommand);
                return resMessage;
            }
            return null;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.serialPort.close();
    }

    @Override
    public void initialize(IPMIInterfaceConfig config) {
    }

    @Override
    public IPMIMessage receive() {
        return null;
    }

    @Override
    public void drop(IIPMIMessage ipmiMessage) {
    }
}

