/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.algo;

import com.supermicro.ipmi.CipherSuite;
import com.supermicro.ipmi.algo.HMAC_MD5_128;
import com.supermicro.ipmi.algo.HMAC_SHA1_96;
import com.supermicro.ipmi.algo.HMAC_SHA256_128;
import com.supermicro.ipmi.algo.IntegrityAlgorithm;
import com.supermicro.ipmi.algo.Integrity_NONE;
import com.supermicro.ipmi.algo.MD5_128;
import com.supermicro.ipmi.algo.RAKPAlgorithm;
import com.supermicro.ipmi.algo.RAKP_HMAC_MD5;
import com.supermicro.ipmi.algo.RAKP_HMAC_NONE;
import com.supermicro.ipmi.algo.RAKP_HMAC_SHA1;
import com.supermicro.ipmi.algo.RAKP_HMAC_SHA256;

public class CipherAlgorithmFactory {
    public static RAKPAlgorithm createRAKPAlgorithm(CipherSuite cipherSuite) {
        RAKPAlgorithm rakpAlgorithm = null;
        switch (cipherSuite.getAuthenticationAlgorithm()) {
            case 0: {
                rakpAlgorithm = new RAKP_HMAC_NONE();
                break;
            }
            case 2: {
                rakpAlgorithm = new RAKP_HMAC_MD5();
                break;
            }
            case 1: {
                rakpAlgorithm = new RAKP_HMAC_SHA1();
                break;
            }
            case 3: {
                rakpAlgorithm = new RAKP_HMAC_SHA256();
            }
        }
        return rakpAlgorithm;
    }

    public static IntegrityAlgorithm createIntegrityAlgorithm(CipherSuite cipherSuite) {
        IntegrityAlgorithm integirtyAlgorithm = null;
        switch (cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                integirtyAlgorithm = new Integrity_NONE();
                break;
            }
            case 1: {
                integirtyAlgorithm = new HMAC_SHA1_96();
                break;
            }
            case 2: {
                integirtyAlgorithm = new HMAC_MD5_128();
                break;
            }
            case 3: {
                integirtyAlgorithm = new MD5_128();
                break;
            }
            case 4: {
                integirtyAlgorithm = new HMAC_SHA256_128();
            }
        }
        return integirtyAlgorithm;
    }
}

