/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.algo;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.algo.IntegrityAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMAC_SHA256_128
extends IntegrityAlgorithm {
    @Override
    public byte[] code(byte[] key, byte[] plainText) {
        byte[] result = null;
        try {
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacSHA256");
            hmacSHA256.init(sks);
            result = hmacSHA256.doFinal(plainText);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] b1 = new byte[32];
        System.arraycopy(result, 0, b1, 0, 32);
        return b1;
    }

    public static void main(String[] args) throws Exception {
        HMAC_SHA256_128 sha = new HMAC_SHA256_128();
        String key = "SUPERMICRO-IPMI";
        String value = "SMC-201205-BMC_BIOS_UPDATE_TOOL";
        byte[] result = sha.code(key.getBytes(), value.getBytes());
        System.out.println("Key =" + key);
        System.out.println("Value =" + value);
        System.out.println("Private Key= " + ByteUtility.bytesToHex(result));
        for (int i2 = 0; i2 < 256; ++i2) {
            String macAddress = "0030480000" + String.format("%02X", i2);
            System.out.println("MAC Address = " + macAddress + " getByte() =" + ByteUtility.bytesToHex(macAddress.getBytes()));
            result = sha.code(result, macAddress.getBytes());
            System.out.println("result = " + ByteUtility.bytesToHex(result));
        }
    }
}

