/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CommandForGettingMELRecords
extends Command {
    @Override
    public Result execute(Host host) {
        boolean isBeforeX12 = this.isBeforeX12(host.config);
        Result result = new Result(this, host);
        RedfishHttpUtils utils = new RedfishHttpUtils();
        ArrayList output = new ArrayList();
        String url = "https://" + host.config.getIp() + "/redfish/v1/Managers/1/LogServices/Log1/Entries/";
        try {
            utils.sendRedfishGet(host.config, url);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            List<HashMap<String, String>> entryList = utils.getEntryList();
            for (int index = 0; index < entryList.size(); ++index) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(host.getHostname());
                arrayList.add(host.getIp());
                arrayList.add(entryList.get(index).get("Severity"));
                arrayList.add(utils.convertDatetimeFormat(entryList.get(index).get("Created")));
                arrayList.add(entryList.get(index).get("Oem/Supermicro/Interface"));
                arrayList.add(entryList.get(index).get("Oem/Supermicro/User"));
                arrayList.add(entryList.get(index).get("Oem/Supermicro/Source"));
                arrayList.add(entryList.get(index).get(isBeforeX12 ? "Description" : "Message"));
                output.add(arrayList);
            }
            result.booleanResult = true;
            result.description = result.description + "ok";
        }
        catch (Exception e2) {
            e2.printStackTrace();
            result.booleanResult = false;
            result.description = result.description + e2.getMessage();
        }
        host.melRecords = output;
        host.isBeforeX12 = isBeforeX12;
        return result;
    }

    private boolean isBeforeX12(IPMIInterfaceConfig ipmiInterfaceConfig) {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(ipmiInterfaceConfig, ipmiMessagingCommand);
        if (null != sessionController) {
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
            sessionController.closeSession();
            sessionController = null;
            return isBeforeX12;
        }
        return false;
    }
}

