/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.CommandForCheckRMCPVersion;
import com.supermicro.ipmi.group.CommandForCreateAccount;
import com.supermicro.ipmi.group.CommandForDisableUIDLED;
import com.supermicro.ipmi.group.CommandForEnableUIDLED;
import com.supermicro.ipmi.group.CommandForGettingACPIState;
import com.supermicro.ipmi.group.CommandForGettingDeviceInfo;
import com.supermicro.ipmi.group.CommandForGettingFRU;
import com.supermicro.ipmi.group.CommandForGettingLANConfiguration;
import com.supermicro.ipmi.group.CommandForGettingSELInfo;
import com.supermicro.ipmi.group.CommandForGettingSELRecords;
import com.supermicro.ipmi.group.CommandForGettingSNMPConfiguration;
import com.supermicro.ipmi.group.CommandForGracefulPowerCycle;
import com.supermicro.ipmi.group.CommandForGracefulReboot;
import com.supermicro.ipmi.group.CommandForGracefulShutdown;
import com.supermicro.ipmi.group.CommandForPowerCycle;
import com.supermicro.ipmi.group.CommandForPowerDown;
import com.supermicro.ipmi.group.CommandForPowerReset;
import com.supermicro.ipmi.group.CommandForPowerUp;
import com.supermicro.ipmi.group.CommandForReadingFan;
import com.supermicro.ipmi.group.CommandForReadingIntrusion;
import com.supermicro.ipmi.group.CommandForReadingPowerSupply;
import com.supermicro.ipmi.group.CommandForReadingPowerSupplyAndIntrusion;
import com.supermicro.ipmi.group.CommandForReadingSensors;
import com.supermicro.ipmi.group.CommandForReadingTemperature;
import com.supermicro.ipmi.group.CommandForReadingVoltage;
import com.supermicro.ipmi.group.CommandForSetGatewayIP;
import com.supermicro.ipmi.group.CommandForSetGatewayMAC;
import com.supermicro.ipmi.group.CommandForSetSNMPCommunity;
import com.supermicro.ipmi.group.CommandForSetSNMPDestination;
import com.supermicro.ipmi.group.CommandForSetSubnetMask;
import com.supermicro.ipmi.group.CommandForStartSOL;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.IPMIUserAccount;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.group.SnmpDestination;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;

public class HostManager
extends Observable {
    Hashtable nameToHost = new Hashtable();
    ArrayList hosts = new ArrayList();

    public void addHost(String name, Host host) {
        this.nameToHost.put(name, host);
        this.hosts.add(host);
    }

    public void removeHost(String name) {
        Object obj = this.nameToHost.get(name);
        this.hosts.remove(obj);
        this.nameToHost.remove(name);
    }

    public Object[] getHosts() {
        return this.hosts.toArray();
    }

    public Host getHost(String name) {
        return (Host)this.nameToHost.get(name);
    }

    public void setAllowTestForAll(boolean isAllowTest) {
        for (Host item : this.hosts) {
            item.setAllowTest(isAllowTest);
        }
    }

    public void setAllowTest(String name, boolean isAllowTest) {
        Host host = (Host)this.nameToHost.get(name);
        host.setAllowTest(isAllowTest);
    }

    public void run(Command command) {
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            Host aHost = (Host)this.hosts.get(i2);
            if (!aHost.isAllowTest()) continue;
            this.setChanged();
            this.notifyObservers(aHost);
            Result result = command.execute(aHost);
            this.setChanged();
            this.notifyObservers(result);
        }
    }

    public static void main_org(String[] args) {
        Command command = null;
        Host h240 = new Host("2.168.10.240", StunnelUtility.testADMIN(), StunnelUtility.testADMIN());
        Host h241 = new Host("2.168.10.241", StunnelUtility.testADMIN(), StunnelUtility.testADMIN());
        HostManager hostManager = new HostManager();
        hostManager.addHost("1", h240);
        hostManager.addHost("2", h241);
        command = new CommandForPowerUp();
        command = new CommandForPowerDown();
        command = new CommandForPowerCycle();
        command = new CommandForPowerReset();
        command = new CommandForReadingFan();
        command = new CommandForReadingIntrusion();
        command = new CommandForReadingPowerSupply();
        command = new CommandForReadingTemperature();
        command = new CommandForReadingVoltage();
        command = new CommandForReadingPowerSupplyAndIntrusion();
        command = new CommandForReadingSensors();
        command = new CommandForGettingACPIState();
        command = new CommandForGettingFRU();
        command = new CommandForGettingDeviceInfo();
        command = new CommandForGettingLANConfiguration();
        command = new CommandForGettingSELInfo();
        command = new CommandForGettingSELRecords();
        command = new CommandForGettingSNMPConfiguration();
        command = new CommandForEnableUIDLED();
        command = new CommandForDisableUIDLED();
        command = new CommandForGracefulPowerCycle();
        command = new CommandForGracefulReboot();
        command = new CommandForGracefulShutdown();
        command = new CommandForStartSOL();
        hostManager.run(command);
        IPMIUserAccount userAccount = new IPMIUserAccount();
        userAccount.userId = (byte)3;
        userAccount.username = "user";
        userAccount.password = "user";
        userAccount.userPrivilege = (byte)2;
        command = new CommandForCreateAccount();
        command.setOption(userAccount);
        command = new CommandForSetGatewayIP();
        command.setOption("2.168.10.254");
        command = new CommandForSetGatewayMAC();
        command.setOption("00:0d:48:09:01:a7");
        command = new CommandForSetSubnetMask();
        command.setOption("255.255.255.0");
        command = new CommandForSetSNMPCommunity();
        command.setOption("Public_SNMP");
        SnmpDestination snmpDestination = new SnmpDestination();
        snmpDestination.ip = "2.168.10.117";
        snmpDestination.mac = "00:06:1B:D9:91:60";
        snmpDestination.index = 1;
        command = new CommandForSetSNMPDestination();
        command.setOption(snmpDestination);
        command = new CommandForCheckRMCPVersion();
    }

    public static void main(String[] args) {
        for (int i2 = 0; i2 < 10000; ++i2) {
            if (i2 % 100 == 0) {
                System.out.println("i= " + i2);
            }
            CommandForGettingSELRecords command = null;
            Host h240 = new Host("2.168.10.240", StunnelUtility.testADMIN(), StunnelUtility.testADMIN());
            Host h241 = new Host("2.168.10.241", StunnelUtility.testADMIN(), StunnelUtility.testADMIN());
            HostManager hostManager = new HostManager();
            hostManager.addHost("1", h240);
            hostManager.addHost("2", h241);
            MessageCenter.getInstance().deleteObservers();
            command = new CommandForGettingSELRecords();
            hostManager.run(command);
        }
    }
}

