/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.junit.TestSuiteForIPMI;
import junit.framework.TestCase;

public class TestIPMILanCommand
extends TestCase {
    private IPMILanCommand ipmiLanCommand = null;
    ISessionController sessionController;

    public TestIPMILanCommand(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sessionController = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface ipmiInterface = this.sessionController.startup(TestSuiteForIPMI.getIPMIInterfaceConfig());
        this.ipmiLanCommand = new IPMILanCommand(ipmiInterface);
    }

    protected void tearDown() throws Exception {
        this.sessionController.closeSession();
    }

    public void testSetCommunityString() {
        String backup = this.ipmiLanCommand.getCommunityString();
        String communityString = "test";
        boolean actualReturn = this.ipmiLanCommand.setCommunityString(communityString);
        String compare = this.ipmiLanCommand.getCommunityString();
        TestIPMILanCommand.assertEquals((String)communityString, (String)compare);
        this.ipmiLanCommand.setCommunityString(backup);
    }

    public void testGetCommunityString() {
        String communityString = this.ipmiLanCommand.getCommunityString();
        TestIPMILanCommand.assertNotNull((Object)communityString);
        System.out.println("communityString =" + communityString);
    }

    public void testGetDestinationIP() {
        String ip1 = this.ipmiLanCommand.getDestinationIP((byte)1);
        String ip2 = this.ipmiLanCommand.getDestinationIP((byte)2);
        String ip3 = this.ipmiLanCommand.getDestinationIP((byte)3);
        TestIPMILanCommand.assertNotNull((Object)ip1);
        TestIPMILanCommand.assertNotNull((Object)ip2);
        TestIPMILanCommand.assertNotNull((Object)ip3);
        System.out.println("ip1 =" + ip1);
        System.out.println("ip2 =" + ip2);
        System.out.println("ip3 =" + ip3);
    }

    public void testGetDestinationMAC() {
        String mac1 = this.ipmiLanCommand.getDestinationMAC((byte)1);
        String mac2 = this.ipmiLanCommand.getDestinationMAC((byte)2);
        String mac3 = this.ipmiLanCommand.getDestinationMAC((byte)3);
        TestIPMILanCommand.assertNotNull((Object)mac1);
        TestIPMILanCommand.assertNotNull((Object)mac2);
        TestIPMILanCommand.assertNotNull((Object)mac3);
        System.out.println("mac1 =" + mac1);
        System.out.println("mac2 =" + mac2);
        System.out.println("mac3 =" + mac3);
    }

    public void testGetGatewayIP() {
        String gatewayIP = this.ipmiLanCommand.getGatewayIP();
        TestIPMILanCommand.assertNotNull((Object)gatewayIP);
        System.out.println("gatewayIP =" + gatewayIP);
    }

    public void testGetGatewayMAC() {
        String gatewayMAC = this.ipmiLanCommand.getGatewayMAC();
        TestIPMILanCommand.assertNotNull((Object)gatewayMAC);
        System.out.println("gatewayMAC =" + gatewayMAC);
    }

    public void testGetIP() {
        String ip = this.ipmiLanCommand.getIP();
        TestIPMILanCommand.assertNotNull((Object)ip);
        System.out.println("ip =" + ip);
    }

    public void testGetMAC() {
        String mac = this.ipmiLanCommand.getMAC();
        TestIPMILanCommand.assertNotNull((Object)mac);
        System.out.println("mac =" + mac);
    }

    public void testGetNumberOfDestination() {
        int i2 = this.ipmiLanCommand.getNumberOfDestination();
        TestIPMILanCommand.assertNotSame((Object)new Integer(i2), (Object)new Integer(0));
        System.out.println(" Number of Destination=" + i2);
    }

    public void testGetSubnetMask() {
        String subnetMask = this.ipmiLanCommand.getSubnetMask();
        TestIPMILanCommand.assertNotNull((Object)subnetMask);
        System.out.println("subnetMask =" + subnetMask);
    }

    public void testSetDesitnationIPandMAC() {
        String testIP = "192.168.1.1";
        String testMAC = "00:11:22:33:44:55";
        for (int i2 = 0; i2 <= 3; ++i2) {
            String backupIP = this.ipmiLanCommand.getDestinationIP((byte)i2);
            String backupMAC = this.ipmiLanCommand.getDestinationMAC((byte)i2);
            this.ipmiLanCommand.setDesitnationIPandMAC((byte)i2, testIP, testMAC);
            String storedIP = this.ipmiLanCommand.getDestinationIP((byte)i2);
            String storedMAC = this.ipmiLanCommand.getDestinationMAC((byte)i2);
            TestIPMILanCommand.assertEquals((String)testIP, (String)storedIP);
            TestIPMILanCommand.assertEquals((String)testMAC, (String)storedMAC);
            this.ipmiLanCommand.setDesitnationIPandMAC((byte)i2, backupIP, backupMAC);
        }
    }

    public void testSetGatewayIP() {
        String backup = this.ipmiLanCommand.getGatewayIP();
        String gatewayIP = "192.168.1.1";
        boolean actualReturn = this.ipmiLanCommand.setGatewayIP(gatewayIP);
        String compare = this.ipmiLanCommand.getGatewayIP();
        TestIPMILanCommand.assertEquals((String)gatewayIP, (String)compare);
        this.ipmiLanCommand.setGatewayIP(backup);
    }

    public void testSetGatewayMAC() {
        String backup = this.ipmiLanCommand.getGatewayMAC();
        String gatewayMAC = "00:11:22:33:44:55";
        boolean actualReturn = this.ipmiLanCommand.setGatewayMAC(gatewayMAC);
        String compare = this.ipmiLanCommand.getGatewayMAC();
        TestIPMILanCommand.assertEquals((String)gatewayMAC, (String)compare);
        this.ipmiLanCommand.setGatewayMAC(backup);
    }

    public void testSetIP() {
        String backup = this.ipmiLanCommand.getIP();
        String ip = "192.168.1.1";
        boolean actualReturn = this.ipmiLanCommand.setIP(ip);
        String compare = this.ipmiLanCommand.getIP();
        TestIPMILanCommand.assertEquals((String)ip, (String)compare);
        this.ipmiLanCommand.setIP(backup);
    }

    public void testSetMAC() {
        String backup = this.ipmiLanCommand.getMAC();
        String mac = "00:11:22:33:44:55";
        boolean actualReturn = this.ipmiLanCommand.setMAC(mac);
        String compare = this.ipmiLanCommand.getMAC();
        TestIPMILanCommand.assertEquals((String)mac, (String)compare);
        this.ipmiLanCommand.setMAC(backup);
    }

    public void testSetSubnetMask() {
        String backup = this.ipmiLanCommand.getSubnetMask();
        String mask = "192.168.1.1";
        boolean actualReturn = this.ipmiLanCommand.setSubnetMask(mask);
        String compare = this.ipmiLanCommand.getSubnetMask();
        TestIPMILanCommand.assertEquals((String)mask, (String)compare);
        this.ipmiLanCommand.setSubnetMask(backup);
    }
}

