/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.junit.TestSuiteForIPMI;
import junit.framework.TestCase;

public class TestIPMIMessagingCommand
extends TestCase {
    private IPMIMessagingCommand ipmiMessageingCommand = null;
    ISessionController sessionController;

    public TestIPMIMessagingCommand(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sessionController = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface ipmiInterface = this.sessionController.startup(TestSuiteForIPMI.getIPMIInterfaceConfig());
        this.ipmiMessageingCommand = new IPMIMessagingCommand(ipmiInterface);
    }

    protected void tearDown() throws Exception {
        this.sessionController.closeSession();
    }

    public void testGetCountOfCurrentEnabledUser() {
        int number = this.ipmiMessageingCommand.getCountOfCurrentEnabledUser();
        TestIPMIMessagingCommand.assertNotSame((Object)new Integer(0), (Object)new Integer(number));
    }

    public void testGetNumberOfAvailableUser() {
        int number = this.ipmiMessageingCommand.getNumberOfAvailableUser();
        TestIPMIMessagingCommand.assertNotSame((Object)new Integer(0), (Object)new Integer(number));
    }

    public void testGetUserNameByID() {
        String name = this.ipmiMessageingCommand.getUserNameByID((byte)2);
        TestIPMIMessagingCommand.assertEquals((String)"ADMIN", (String)name);
    }

    public void testIsEnableUser() {
        boolean result = this.ipmiMessageingCommand.isEnableUser((byte)2);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
    }

    public void testSetDisableUserByID() {
        boolean result = this.ipmiMessageingCommand.setDisableUserByID((byte)5);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
    }

    public void testSetEnableUserByID() {
        boolean result = this.ipmiMessageingCommand.setEnableUserByID((byte)2);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
    }

    public void testSetUserNameByID() {
        String username = "uuuuuu";
        boolean result = this.ipmiMessageingCommand.setUserNameByID((byte)3, username);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        String name = this.ipmiMessageingCommand.getUserNameByID((byte)3);
        TestIPMIMessagingCommand.assertEquals((String)username, (String)name);
        result = this.ipmiMessageingCommand.setUserNameByID((byte)3, "");
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
    }

    public void testSetUserPasswordByID() {
        String username = "uuuuuu";
        String password = "aaaaaa";
        boolean result = this.ipmiMessageingCommand.setUserNameByID((byte)3, username);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        result = this.ipmiMessageingCommand.setUserPasswordByID((byte)3, password);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        result = this.ipmiMessageingCommand.setUserNameByID((byte)3, "");
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        result = this.ipmiMessageingCommand.setUserPasswordByID((byte)3, "");
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
    }

    public void testSetUserPrivilegeByID() {
        String username = "uuuuuu";
        boolean result = this.ipmiMessageingCommand.setUserNameByID((byte)3, username);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        result = this.ipmiMessageingCommand.setUserPrivilegeByID((byte)3, (byte)4);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result);
        byte privilege = this.ipmiMessageingCommand.getUserPrivilegeByID((byte)3);
        TestIPMIMessagingCommand.assertEquals((byte)4, (byte)privilege);
    }

    public void testCreateUserWithLogin() {
        int i2;
        boolean result1 = this.ipmiMessageingCommand.setUserNameByID((byte)3, "test");
        boolean result2 = this.ipmiMessageingCommand.setUserPasswordByID((byte)3, "test");
        boolean result3 = this.ipmiMessageingCommand.setEnableUserByID((byte)3);
        boolean result4 = this.ipmiMessageingCommand.setUserPrivilegeByID((byte)3, (byte)4);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result1);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result2);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result3);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result4);
        IPMIInterfaceConfig config = TestSuiteForIPMI.getIPMIInterfaceConfig();
        config.setUserName("test");
        config.setPassword("test");
        ISessionController sessionController1 = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface rmcp = sessionController1.startup(config);
        TestIPMIMessagingCommand.assertNotNull((Object)rmcp);
        sessionController1.closeSession();
        boolean result6 = this.ipmiMessageingCommand.setUserNameByID((byte)3, "");
        boolean result7 = this.ipmiMessageingCommand.setUserPasswordByID((byte)3, "");
        boolean result8 = this.ipmiMessageingCommand.setDisableUserByID((byte)3);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result6);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result7);
        TestIPMIMessagingCommand.assertEquals((boolean)true, (boolean)result8);
        for (i2 = 1; i2 <= 10; ++i2) {
            String name = this.ipmiMessageingCommand.getUserNameByID((byte)i2);
            System.out.println(i2 + ": " + name);
        }
        for (i2 = 1; i2 <= 10; ++i2) {
            boolean isEnable = this.ipmiMessageingCommand.isEnableUser((byte)i2);
            System.out.println(i2 + ": " + (isEnable ? "enable" : "disable"));
        }
    }
}

