/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.junit.TestSuiteForIPMI;
import java.util.ArrayList;
import java.util.Calendar;
import junit.framework.TestCase;

public class TestIPMISELCommand
extends TestCase {
    ISessionController sessionController;
    private IPMISELCommand ipmiSELCommand = null;

    public TestIPMISELCommand(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sessionController = TestSuiteForIPMI.getSessionController();
        IPMINetworkInterface ipmiInterface = this.sessionController.startup(TestSuiteForIPMI.getIPMIInterfaceConfig());
        this.ipmiSELCommand = new IPMISELCommand(ipmiInterface);
    }

    protected void tearDown() throws Exception {
        this.sessionController.closeSession();
    }

    public void testAddSEL() {
        this.ipmiSELCommand.clearSEL();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[] selRecord = new byte[]{3, 0, 2, 17, -84, -53, 67, 32, 0, 4, 4, 12, 1, 84, 0, 18};
        this.ipmiSELCommand.addSEL(selRecord);
        SELInfo selInfo = this.ipmiSELCommand.getSELInfoModal();
        System.out.println("log entrys after add = " + selInfo.getLogEntries());
        TestIPMISELCommand.assertEquals((int)selInfo.getLogEntries(), (int)1);
    }

    public void testClearSEL() {
        this.ipmiSELCommand.clearSEL();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SELInfo selInfo = this.ipmiSELCommand.getSELInfoModal();
        System.out.println("log entrys after clear = " + selInfo.getLogEntries());
        TestIPMISELCommand.assertEquals((int)selInfo.getLogEntries(), (int)0);
    }

    public void testGetReservationID() {
        byte[] reservationID = this.ipmiSELCommand.getSELReservationID();
        System.out.println("reservationID = " + ByteUtility.bytesToHex(reservationID));
        TestIPMISELCommand.assertNotNull((Object)reservationID);
    }

    public void testGetSELEntries() {
        this.ipmiSELCommand.clearSEL();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[] selRecord = new byte[]{3, 0, 2, 17, -84, -53, 67, 32, 0, 4, 4, 12, 1, 84, 0, 18};
        this.ipmiSELCommand.addSEL(selRecord);
        SELInfo selInfo = this.ipmiSELCommand.getSELInfoModal();
        ArrayList list = this.ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
        System.out.println("A entry =" + ((SELRecord)list.get(0)).toString());
        TestIPMISELCommand.assertEquals((int)list.size(), (int)1);
    }

    public void testGetSELInfoModal() {
        SELInfo selInfo = this.ipmiSELCommand.getSELInfoModal();
        System.out.println("selInfo =" + selInfo.toString());
        TestIPMISELCommand.assertNotNull((Object)selInfo);
    }

    public void testGetSELTimeWithFormat() {
        String time = this.ipmiSELCommand.getSELTimeWithFormat();
        System.out.println("SEL Time =" + time);
        TestIPMISELCommand.assertNotNull((Object)time);
    }

    public void testSetSELTimeByCalendar() {
        boolean result = this.ipmiSELCommand.setSELTimeByCalendar(Calendar.getInstance());
        String time = this.ipmiSELCommand.getSELTimeWithFormat();
        System.out.println("SEL Time after set=" + time);
        TestIPMISELCommand.assertEquals((boolean)result, (boolean)true);
    }
}

