/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.junit;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.RMCPPlusSessionController;
import com.supermicro.ipmi.RMCPSessionController;
import com.supermicro.ipmi.junit.TestIPMIChassisCommand;
import com.supermicro.ipmi.junit.TestIPMIFRUCommand;
import com.supermicro.ipmi.junit.TestIPMIGlobalCommand;
import com.supermicro.ipmi.junit.TestIPMILanCommand;
import com.supermicro.ipmi.junit.TestIPMIMessagingCommand;
import com.supermicro.ipmi.junit.TestIPMISDRCommand;
import com.supermicro.ipmi.junit.TestIPMISELCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSuiteForIPMI
extends TestCase {
    public TestSuiteForIPMI(String s) {
        super(s);
    }

    public static IPMIInterfaceConfig getIPMIInterfaceConfig() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setRetry(2);
        config.setTimeout(2);
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        return config;
    }

    public static ISessionController getSessionController() {
        ISessionController sessionController = null;
        int version = IPMIVersion.checkIPMIVersion(TestSuiteForIPMI.getIPMIInterfaceConfig());
        switch (version) {
            case 1: {
                sessionController = new RMCPSessionController();
                System.out.println("IPMI 2.0");
                break;
            }
            case 2: {
                sessionController = new RMCPPlusSessionController();
                System.out.println("IPMI 2.0+");
            }
        }
        return sessionController;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestIPMILanCommand.class);
        suite.addTestSuite(TestIPMISELCommand.class);
        suite.addTestSuite(TestIPMISDRCommand.class);
        suite.addTestSuite(TestIPMIFRUCommand.class);
        suite.addTestSuite(TestIPMIMessagingCommand.class);
        suite.addTestSuite(TestIPMIGlobalCommand.class);
        suite.addTestSuite(TestIPMIChassisCommand.class);
        return suite;
    }
}

