/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.loc;

import com.supermicro.ipmi.ByteUtility;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class TagLoc {
    public static byte TAGLOC_ID = (byte)-128;
    public static String[] MB_TYPE = new String[]{"unspecified", "MB_X9_UP", "MB_X9_DP", "MB_X9_MP", "MB_X8_UP", "MB_X8_DP", "MB_X8_MP", "MB_X7_UP", "MB_X7_DP", "MB_X7_MP", "MB_A+_UP", "MB_A+_DP", "MB_A+_MP", "MB_B9_UP", "MB_B9_DP", "MB_B9_MP", "MB_B8_UP", "MB_B8_DP", "MB_B8_MP", "MB_B7_UP", "MB_B7_DP", "MB_B7_MP"};
    public static String[] CHASSIS_TYPE = new String[]{"unspecified", "1U", "2U", "3U", "4U", "5U", "6U", "7U", "Tower", "MidTower", "MicroCloud", "1U-Twin", "2U-Twin", "2U-Twin2", "2U-Twin3", "SuperBlade", "CMM", "SBB", "DSS", "GPU Integrated"};
    public static String[] POWER_TYPE = new String[]{"unspecified", "PWS-1K01-1R", "PWS-1K22-1R", "PWS-1K21P-1R", "PWS-1K25P-PQ", "PWS-1K41P-1R", "PWS-1K41F-1R", "PWS-1K62P-1R", "PWS-1K81P-1R", "PWS-0020", "PWS-0043", "PWS-0043-20", "PWS-201-1H", "PWS-202-1H", "PWS-0019", "PWS-0021", "PWS-0055", "PWS-281-1H", "PWS-0054", "PWS-333-1H", "PWS-333-1H20", "PWS-0042-20", "PWS-0042-24", "PWS-351-1H", "PWS-361-1H", "PWS-361-1H20", "PWS-0036", "PWS-0064", "PWS-401-1R", "PWS-406P-1R", "PWS-0061", "PWS-0053", "PWS-0053-20", "PWS-451-1R", "PWS-0048", "PWS-501P-1R", "PWS-503P-1R", "PWS-504P-1R", "PWS-521-1H", "PWS-521-1H20", "PWS-0057", "PWS-561-1H", "PWS-561-1H20", "PWS-562-1H", "PWS-562-1H20", "PWS-563-1H", "PWS-563-1H20", "PWS-601-1H", "PWS-605P-1H", "PWS-651-1R", "PWS-702A-1R", "PWS-703P-1R", "PWS-704P-1R", "PWS-707-1S", "PWS-781-1S", "PWS-711-1R", "PWS-721P-1R", "PWS-741P-1R", "PWS-1K11P-1R", "PWS-920P-1R", "PWS-981-1S"};
    public static String[] OS_TYPE = new String[]{"unspecified", "Microsoft Windows", "Linux", "Solaris", "BSD", "IBM OS/2", "Mac OS", "Other"};
    public int dataCenter;
    public int room;
    public int row;
    public int rack;
    public byte majorNumber;
    public byte minorNumber;
    public byte mbType;
    public byte chassisType;
    public byte powerType;
    public byte osType;
    public byte[] date = new byte[4];
    public byte[] reserveIP = new byte[4];
    public byte[] oemString = new byte[20];
    public byte[] raw;

    public void setIP(String ip) throws Exception {
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                throw new Exception("IP format error!");
            }
            this.reserveIP[i2] = (byte)Integer.parseInt(st.nextToken());
        }
    }

    public String getIPString() {
        String ip = "";
        ip = (this.reserveIP[0] & 0xFF) + "." + (this.reserveIP[1] & 0xFF) + "." + (this.reserveIP[2] & 0xFF) + "." + (this.reserveIP[3] & 0xFF);
        return ip;
    }

    public byte[] toRaw() {
        byte[] data = new byte[42];
        byte[] dataCenterBytes = new byte[2];
        ByteUtility.intTo2Bytes(dataCenterBytes, 0, this.dataCenter);
        byte[] roomBytes = new byte[2];
        ByteUtility.intTo2Bytes(roomBytes, 0, this.room);
        byte[] rowBytes = new byte[2];
        ByteUtility.intTo2Bytes(rowBytes, 0, this.row);
        byte[] rackBytes = new byte[2];
        ByteUtility.intTo2Bytes(rackBytes, 0, this.rack);
        data[0] = dataCenterBytes[0];
        data[1] = dataCenterBytes[1];
        data[2] = roomBytes[0];
        data[3] = roomBytes[1];
        data[4] = rowBytes[0];
        data[5] = rowBytes[1];
        data[6] = rackBytes[0];
        data[7] = rackBytes[1];
        data[8] = this.majorNumber;
        data[9] = this.minorNumber;
        data[10] = this.mbType;
        data[11] = this.chassisType;
        data[12] = this.powerType;
        data[13] = this.osType;
        this.setCurrentDateTime();
        data[14] = this.date[0];
        data[15] = this.date[1];
        data[16] = this.date[2];
        data[17] = this.date[3];
        data[18] = this.reserveIP[0];
        data[19] = this.reserveIP[1];
        data[20] = this.reserveIP[2];
        data[21] = this.reserveIP[3];
        System.arraycopy(this.oemString, 0, data, 22, this.oemString.length);
        return data;
    }

    public void fromRaw(byte[] raw) {
        try {
            int index = 0;
            this.dataCenter = ByteUtility.twoBytesToInt(ByteUtility.getBytes(raw, index, 2));
            this.room = ByteUtility.twoBytesToInt(ByteUtility.getBytes(raw, index += 2, 2));
            this.row = ByteUtility.twoBytesToInt(ByteUtility.getBytes(raw, index += 2, 2));
            this.rack = ByteUtility.twoBytesToInt(ByteUtility.getBytes(raw, index += 2, 2));
            this.majorNumber = raw[index += 2];
            this.minorNumber = raw[++index];
            this.mbType = raw[++index];
            this.chassisType = raw[++index];
            this.powerType = raw[++index];
            this.osType = raw[++index];
            this.date[0] = raw[++index];
            this.date[1] = raw[++index];
            this.date[2] = raw[++index];
            this.date[3] = raw[++index];
            this.reserveIP[0] = raw[++index];
            this.reserveIP[1] = raw[++index];
            this.reserveIP[2] = raw[++index];
            this.reserveIP[3] = raw[++index];
            System.arraycopy(raw, ++index, this.oemString, 0, this.oemString.length);
            index += this.oemString.length;
            this.raw = raw;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        String str = "";
        str = str + "dataCenter    = " + this.dataCenter + "\n";
        str = str + "room          = " + this.room + "\n";
        str = str + "row           = " + this.row + "\n";
        str = str + "rack          = " + this.rack + "\n";
        str = str + "majorNumber   = " + this.unsignedByte(this.majorNumber) + "\n";
        str = str + "minorNumber   = " + this.unsignedByte(this.minorNumber) + "\n";
        str = str + "mbType        = " + this.unsignedByte(this.mbType) + "\n";
        str = str + "chassisType   = " + this.unsignedByte(this.chassisType) + "\n";
        str = str + "powerType     = " + this.unsignedByte(this.powerType) + "\n";
        str = str + "osType        = " + this.unsignedByte(this.osType) + "\n";
        str = str + "date          = " + ByteUtility.bytesToHex(this.date) + "\n";
        str = str + "ip            = " + ByteUtility.bytesToHex(this.reserveIP) + "\n";
        str = str + "iDString      = " + ByteUtility.bytesToHex(this.oemString) + "\n";
        str = str + "raw           = " + ByteUtility.bytesToHex(this.raw) + "\n";
        return str;
    }

    public String toShortFormatedString() {
        String str = String.format("DC:%2d |Room:%2d |Row:%2d |Rack:%2d |Num:%s |Type: %s", this.dataCenter, this.room, this.row, this.rack, this.getNumberString(), this.getChassisTypeString());
        str = str + "\n-----------------------------------------------------------\n";
        str = str + "OS          | " + this.getOSTypeString() + "\n";
        str = str + "OEM String  | " + new String(this.oemString) + "\n";
        str = str + "Update Time | " + this.getDateTimeString();
        return str;
    }

    public String getNumberString() {
        String number = this.minorNumber != 0 ? String.format("%2d.%d", this.unsignedByte(this.majorNumber), this.unsignedByte(this.minorNumber)) : String.format("%2d", this.unsignedByte(this.majorNumber));
        return number;
    }

    public String toFormatedString() {
        String formatTemplate = " %-15s | %-6s \n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "Tag Field", "ID"));
        formatedString.append(String.format(formatTemplate, "---------------", "------"));
        formatedString.append(String.format(formatTemplate, "Data Center", this.dataCenter));
        formatedString.append(String.format(formatTemplate, "Room", this.room));
        formatedString.append(String.format(formatTemplate, "Row", this.row));
        formatedString.append(String.format(formatTemplate, "Rack", this.rack));
        formatedString.append(String.format(formatTemplate, "Number major", this.unsignedByte(this.majorNumber)));
        formatedString.append(String.format(formatTemplate, "Number minor", this.unsignedByte(this.minorNumber)));
        if (this.unsignedByte(this.mbType) < MB_TYPE.length) {
            formatedString.append(String.format(formatTemplate, "MB Type", this.unsignedByte(this.mbType) + " (" + MB_TYPE[this.unsignedByte(this.mbType)] + ")"));
        } else {
            formatedString.append(String.format(formatTemplate, "MB Type", this.unsignedByte(this.mbType)));
        }
        if (this.unsignedByte(this.chassisType) < CHASSIS_TYPE.length) {
            formatedString.append(String.format(formatTemplate, "Chassis Type", this.unsignedByte(this.chassisType) + " (" + CHASSIS_TYPE[this.unsignedByte(this.chassisType)] + ")"));
        } else {
            formatedString.append(String.format(formatTemplate, "Chassis Type", this.unsignedByte(this.chassisType)));
        }
        if (this.unsignedByte(this.powerType) < POWER_TYPE.length) {
            formatedString.append(String.format(formatTemplate, "Power Type", this.unsignedByte(this.powerType) + " (" + POWER_TYPE[this.unsignedByte(this.powerType)] + ")"));
        } else {
            formatedString.append(String.format(formatTemplate, "Power Type", this.unsignedByte(this.powerType)));
        }
        if (this.unsignedByte(this.osType) < OS_TYPE.length) {
            formatedString.append(String.format(formatTemplate, "OS Type", this.unsignedByte(this.osType) + " (" + OS_TYPE[this.unsignedByte(this.osType)] + ")"));
        } else {
            formatedString.append(String.format(formatTemplate, "OS Type", this.unsignedByte(this.osType)));
        }
        formatedString.append(String.format(formatTemplate, "Update Time", this.getDateTimeString()));
        formatedString.append(String.format(formatTemplate, "OEM String", new String(this.oemString)));
        formatedString.append(String.format(formatTemplate, "IP (Runtime)", this.getIPString()));
        return formatedString.toString();
    }

    public String getMBTypeString() {
        if (this.unsignedByte(this.mbType) < MB_TYPE.length) {
            return MB_TYPE[this.unsignedByte(this.mbType)];
        }
        return "";
    }

    public String getChassisTypeString() {
        if (this.unsignedByte(this.chassisType) < CHASSIS_TYPE.length) {
            return CHASSIS_TYPE[this.unsignedByte(this.chassisType)];
        }
        return "";
    }

    public String getPowerTypeString() {
        if (this.unsignedByte(this.powerType) < POWER_TYPE.length) {
            return POWER_TYPE[this.unsignedByte(this.powerType)];
        }
        return "";
    }

    public String getOSTypeString() {
        if (this.unsignedByte(this.osType) < OS_TYPE.length) {
            return OS_TYPE[this.unsignedByte(this.osType)];
        }
        return "";
    }

    public void setOEMString(String aString) {
        byte[] byteArray = aString.getBytes();
        this.oemString = new byte[20];
        if (byteArray.length > 20) {
            System.arraycopy(byteArray, 0, this.oemString, 0, 20);
        } else {
            System.arraycopy(byteArray, 0, this.oemString, 0, byteArray.length);
        }
    }

    public void setCurrentDateTime() {
        Calendar c2 = Calendar.getInstance();
        long time = c2.getTime().getTime();
        ByteUtility.longTo4Bytes(this.date, 0, time /= 1000L);
    }

    public String getDateTimeString() {
        long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(this.date);
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        long k = timeStamp * 1000L;
        Date d2 = new Date(k);
        String dateString = f2.format(d2);
        return dateString;
    }

    public int unsignedByte(byte value) {
        return value & 0xFF;
    }

    public void toFile(String filename) throws IOException, FileNotFoundException {
        File f2 = new File(filename);
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        fos = new FileOutputStream(f2);
        dos = new DataOutputStream(fos);
        dos.writeByte(this.toRaw().length);
        dos.write(this.toRaw());
        dos.close();
        fos.close();
    }

    public void fromFile(String filename) throws IOException, FileNotFoundException {
        File f2 = new File(filename);
        FileInputStream fis = null;
        DataInputStream dis = null;
        fis = new FileInputStream(f2);
        dis = new DataInputStream(fis);
        byte length = dis.readByte();
        byte[] raw = new byte[length];
        dis.read(raw);
        this.fromRaw(raw);
        dis.close();
        fis.close();
    }
}

