/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;

public class BladeRemoteInfo
extends AbstractModuleInfo {
    public static final int NODE_REMOTE_INFO_STRUCTURE_LENGTH = 92;
    public byte present;
    public byte nodeCount;
    public byte[] reserved;
    public NodeRemoteInfo[] nodeRemoteInfos;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.present = raw[index];
        this.nodeCount = raw[++index];
        this.reserved = ByteUtility.getBytes(raw, ++index, 2);
        index += 2;
        this.nodeRemoteInfos = new NodeRemoteInfo[this.nodeCount];
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            this.nodeRemoteInfos[i2] = new NodeRemoteInfo();
            byte[] subRaw = ByteUtility.getBytes(raw, index, 92);
            index += 92;
            this.nodeRemoteInfos[i2].fromRaw(subRaw);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npresent =" + this.present);
        sb.append("\nnodeCount =" + this.nodeCount);
        sb.append("\reserved =" + ByteUtility.bytesToHex(this.reserved));
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            sb.append("\n===\n" + this.nodeRemoteInfos[i2].toString());
        }
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean isPresent() {
        return (byte)(this.present & 1) == 1;
    }

    public String getNodeBMCIP(int index) {
        return this.nodeRemoteInfos[index].getBMCPIP();
    }

    public String getNodeServerName(int index) {
        return this.nodeRemoteInfos[index].getServerName();
    }

    public String getNodeUsername(int index) {
        return this.nodeRemoteInfos[index].getDecryptedUsername();
    }

    public String getNodePassword(int index) {
        return this.nodeRemoteInfos[index].getDecryptedPassword();
    }

    public int getNodeKVMPort(int index) {
        return this.nodeRemoteInfos[index].getKVMPort();
    }

    public NodeRemoteInfo getNodeRemoteInfo(int index) {
        return this.nodeRemoteInfos[index];
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Blade", "M/S", "Status"));
        header.append(String.format(formatTemplate, "---", "---", "------"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.isPresent()) {
            return "";
        }
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "CMM " + this.getIndex();
        formatedString.append(String.format(formatTemplate, index, this.nodeCount, this.reserved));
        return formatedString.toString();
    }
}

