/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class NodeRemoteInfo
extends AbstractModuleInfo {
    public byte[] bmcIP;
    public byte[] bmcIPV6;
    public byte[] serverName;
    public byte[] username;
    public byte[] password;
    public byte validIPBit;
    public byte[] kvmPort;
    public static byte[] oemKey = new byte[]{-87, 35, -111, 46, 3, 41, -59, 9, -40, -38, 106, 68, -101, -126, -35, 28};

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.bmcIP = ByteUtility.getBytes(raw, index, 4);
        this.bmcIPV6 = ByteUtility.getBytes(raw, index += 4, 16);
        this.serverName = ByteUtility.getBytes(raw, index += 16, 17);
        this.username = ByteUtility.getBytes(raw, index += 17, 25);
        this.password = ByteUtility.getBytes(raw, index += 25, 25);
        this.validIPBit = raw[index += 25];
        this.kvmPort = ByteUtility.getBytes(raw, ++index, 2);
        index += 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nBMC ip =" + this.getBMCPIP());
        sb.append("\nBMC ip v6 =" + ByteUtility.bytesToHex(this.bmcIPV6));
        sb.append("\nServerName =" + this.getServerName());
        sb.append("\nUsername =" + this.getDecryptedUsername());
        sb.append("\nPassword =" + this.getDecryptedPassword());
        sb.append("\nvalidIPBit =" + this.validIPBit);
        sb.append("\nkvmPort =" + this.getKVMPort());
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public String getBMCPIP() {
        String ip = (this.bmcIP[0] & 0xFF) + "." + (this.bmcIP[1] & 0xFF) + "." + (this.bmcIP[2] & 0xFF) + "." + (this.bmcIP[3] & 0xFF);
        return ip;
    }

    public String getServerName() {
        String str = new String(this.serverName);
        return str;
    }

    public String getDecryptedUsername() {
        String str = "";
        try {
            byte[] b2 = ByteUtility.getBytes(this.username, 0, 24);
            str = NodeRemoteInfo.blowFishDecrypt(b2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return str;
    }

    public String getDecryptedPassword() {
        String str = "";
        try {
            byte[] b2 = ByteUtility.getBytes(this.password, 0, 24);
            str = NodeRemoteInfo.blowFishDecrypt(b2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return str;
    }

    public int getKVMPort() {
        int value = ByteUtility.twoBytesToInt(this.kvmPort);
        return value;
    }

    public static String blowFishDecrypt(byte[] encrypted) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(oemKey, "Blowfish");
        Cipher cipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
        cipher.init(2, secretKeySpec);
        byte[] hasil = cipher.doFinal(encrypted);
        return new String(hasil).trim();
    }
}

