/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import com.supermicro.ipmi.microblade.SB_B10DRE;
import com.supermicro.ipmi.microblade.SB_B10KNM;
import com.supermicro.ipmi.microblade.SB_B11DPE;
import com.supermicro.ipmi.microblade.SB_B11DPT;
import com.supermicro.ipmi.microblade.SB_B11QPI;
import com.supermicro.ipmi.microblade.SB_B11SCG;
import com.supermicro.ipmi.microblade.SB_B11SPE;
import com.supermicro.ipmi.microblade.SB_B11SRE;
import com.supermicro.ipmi.microblade.SB_B12DPE;
import com.supermicro.ipmi.microblade.SB_B12DPT;
import com.supermicro.ipmi.microblade.SB_B12SPE;
import com.supermicro.ipmi.microblade.SB_B13DEE;
import com.supermicro.ipmi.microblade.SB_B13DET;
import com.supermicro.ipmi.microblade.SB_B13SEE;
import com.supermicro.ipmi.microblade.SB_B13SEG;
import com.supermicro.ipmi.microblade.SB_B14DBT;
import com.supermicro.ipmi.microblade.SB_B14SBE;
import com.supermicro.ipmi.microblade.SB_B1DRI;
import com.supermicro.ipmi.microblade.SB_B1SA4F;
import com.supermicro.ipmi.microblade.SB_B1SD2;
import com.supermicro.ipmi.microblade.SB_B1SL1;
import com.supermicro.ipmi.microblade.SB_B2SC1;
import com.supermicro.ipmi.microblade.SB_B2SD2;
import com.supermicro.ipmi.microblade.SB_B2SS1;
import com.supermicro.ipmi.microblade.SB_B2SS2;
import com.supermicro.ipmi.microblade.SB_B2SS2_MTF;
import com.supermicro.ipmi.microblade.SB_B3ST1;
import com.supermicro.ipmi.microblade.SB_B4SA1;
import com.supermicro.ipmi.microblade.SB_BH12SSI;
import com.supermicro.ipmi.microblade.Sensor;
import java.text.DecimalFormat;

public class NodeSensorInfo
extends AbstractModuleInfo {
    private int sensorLength = 168;
    private int bladeIndex;
    public byte ok2GetSensor;
    public byte error;
    public byte unused1;
    public byte powerStatus;
    public byte uid;
    public byte cpuUsage;
    public byte kvmLaunched;
    public byte sol;
    public byte unused;
    public byte[] maxPowerUsage;
    public byte[] boardId;
    public byte[] curPower;
    public byte[] dimmSize;
    public byte[] dimmSpeed;
    public byte dimmCount;
    public byte cpuCount;
    public byte[] cpuId;
    public byte[] cpuSpeed;
    public byte[] vlanId;
    public byte vlanEnable;
    public byte ipSrc;
    public byte[] bmcIp;
    public byte[] bmcMask;
    public byte[] bmcGateway;
    public byte ipV6Src;
    public byte[] bmcIpV6;
    public byte[] bmcMaskIpV6;
    public byte[] bmcGatewayIpV6;
    public byte[] bmcMac;
    public byte[] hostMac;
    public byte[] serverName;
    public byte[] modelName;
    public byte[] biosVer;
    public byte[] biosDate;
    public byte lanCount;
    public byte[] userName;
    public byte[] password;
    public byte[] kvmPort;
    public byte[] bmcVer;
    public byte biosPostCode;
    public byte nodeCount;
    public byte lanSpeed;
    public byte productKeyActicate;
    public byte[] bladeCapabilities;
    public byte[] reserved;
    public AbstractSBEntity sBEntity = new SB_B1SA4F();
    public Sensor[] sensor;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.ok2GetSensor = raw[index];
        this.error = raw[index];
        this.unused1 = raw[index++];
        this.powerStatus = raw[index];
        this.uid = raw[index];
        this.cpuUsage = raw[index];
        this.kvmLaunched = raw[index];
        this.sol = raw[index];
        this.unused = raw[index++];
        this.maxPowerUsage = ByteUtility.getBytes(raw, index, 2);
        this.boardId = ByteUtility.getBytes(raw, index += 2, 2);
        this.curPower = ByteUtility.getBytes(raw, index += 2, 2);
        this.dimmSize = ByteUtility.getBytes(raw, index += 2, 4);
        this.dimmSpeed = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.dimmCount = raw[index++];
        this.cpuCount = raw[index++];
        this.cpuId = ByteUtility.getBytes(raw, index, 2);
        this.cpuSpeed = ByteUtility.getBytes(raw, index += 2, 4);
        this.vlanId = ByteUtility.getBytes(raw, index += 4, 2);
        index += 2;
        this.vlanEnable = raw[index++];
        this.ipSrc = raw[index++];
        this.bmcIp = ByteUtility.getBytes(raw, index, 4);
        this.bmcMask = ByteUtility.getBytes(raw, index += 4, 4);
        this.bmcGateway = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.ipV6Src = raw[index++];
        this.bmcIpV6 = ByteUtility.getBytes(raw, index, 16);
        this.bmcMaskIpV6 = ByteUtility.getBytes(raw, index += 16, 16);
        this.bmcGatewayIpV6 = ByteUtility.getBytes(raw, index += 16, 16);
        this.bmcMac = ByteUtility.getBytes(raw, index += 16, 6);
        this.hostMac = ByteUtility.getBytes(raw, index += 6, 6);
        this.serverName = ByteUtility.getBytes(raw, index += 6, 17);
        this.modelName = ByteUtility.getBytes(raw, index += 17, 17);
        this.biosVer = ByteUtility.getBytes(raw, index += 17, 8);
        this.biosDate = ByteUtility.getBytes(raw, index += 8, 16);
        index += 16;
        this.lanCount = raw[index++];
        this.userName = ByteUtility.getBytes(raw, index, 25);
        this.password = ByteUtility.getBytes(raw, index += 25, 25);
        this.kvmPort = ByteUtility.getBytes(raw, index += 25, 2);
        this.bmcVer = ByteUtility.getBytes(raw, index += 2, 4);
        index += 4;
        this.biosPostCode = raw[index++];
        this.nodeCount = raw[index++];
        this.lanSpeed = raw[index++];
        this.productKeyActicate = raw[index++];
        this.bladeCapabilities = ByteUtility.getBytes(raw, index, 4);
        this.reserved = ByteUtility.getBytes(raw, index += 4, 1);
        this.sBEntity.fromRaw(ByteUtility.getBytes(raw, ++index, this.sensorLength));
        this.sensor = new Sensor[56];
        for (int i2 = 0; i2 < 56; ++i2) {
            this.sensor[i2] = new Sensor();
            this.sensor[i2].fromRaw(ByteUtility.getBytes(raw, index, 12));
            if ((index += 12) + 12 > raw.length) break;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ok2GetSensor =" + this.ok2GetSensor);
        sb.append("\nok2GetSensor =" + this.getOk2GetSensor());
        sb.append("\nerror =" + this.error());
        sb.append("\nunused1 =" + this.unused1());
        sb.append("\npowerStatus =" + this.powerStatus);
        sb.append("\npowerStatus =" + this.getPowerStatus());
        sb.append("\nuid =" + this.getUid());
        sb.append("\ncpuUsage =" + this.getCpuUsage());
        sb.append("\nkvmLaunched =" + this.getKvmLaunched());
        sb.append("\nsol =" + this.getSol());
        sb.append("\nunused =" + this.unused());
        sb.append("\nmaxPowerUsage =" + this.getMaxPowerUsage());
        sb.append("\nboardId =" + this.getBoardId());
        sb.append("\ncurPower =" + this.getCurPower());
        sb.append("\ndimmSize =" + this.getDIMMSize());
        sb.append("\ndimmSpeed =" + this.getDIMMSpeed());
        sb.append("\ndimmCount =" + this.dimmCount);
        sb.append("\ncpuCount =" + this.cpuCount);
        sb.append("\ncpuId =" + this.getCPUId());
        sb.append("\ncpuSpeed =" + this.getCPUSpeed());
        sb.append("\nvlanId =" + this.getVANId());
        sb.append("\nvlanEnable =" + this.vlanEnable);
        sb.append("\nipSrc =" + this.ipSrc);
        sb.append("\nbmcIp =" + this.getBMCIP());
        sb.append("\nbmcMask =" + this.getBMCMask());
        sb.append("\nbmcGateway =" + this.getBMCGateway());
        sb.append("\nipV6Src =" + this.ipV6Src);
        sb.append("\nbmcIpV6 =" + ByteUtility.bytesToHex(this.bmcIpV6));
        sb.append("\nbmcMaskIpV6 =" + ByteUtility.bytesToHex(this.bmcMaskIpV6));
        sb.append("\nbmcGatewayIpV6 =" + ByteUtility.bytesToHex(this.bmcGatewayIpV6));
        sb.append("\nbmcMac =" + this.getBMCMAC());
        sb.append("\nhostMac =" + this.getHostMAC());
        sb.append("\nserverName =" + this.getServerName());
        sb.append("\nmodelName =" + this.getModelName());
        sb.append("\nbiosVer =" + this.getBIOSVer());
        sb.append("\nbiosDate =" + this.getBIOSDate());
        sb.append("\nlanCount =" + this.lanCount);
        sb.append("\nuserName =" + this.getDecryptedUsername());
        sb.append("\npassword =" + this.getDecryptedPassword());
        sb.append("\nkvmPort =" + this.getKVMPort());
        sb.append("\nbmcVer =" + this.getBMCVer());
        sb.append("\nbiosPostCode =" + this.biosPostCode);
        sb.append("\nreserved =" + ByteUtility.bytesToHex(this.reserved));
        for (int i2 = 0; i2 < 40; ++i2) {
            sb.append("\nsensor " + i2 + ":\n" + this.sensor[i2]);
        }
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public byte getOk2GetSensor() {
        return (byte)(this.ok2GetSensor & 1);
    }

    public byte error() {
        return (byte)(this.error & 6);
    }

    public byte unused1() {
        return (byte)(this.unused1 & 0xF8);
    }

    public byte getPowerStatus() {
        return (byte)(this.powerStatus & 1);
    }

    public byte getUid() {
        return (byte)(this.uid & 2);
    }

    public byte getCpuUsage() {
        return (byte)(this.cpuUsage & 0xC);
    }

    public byte getKvmLaunched() {
        return (byte)(this.kvmLaunched & 0x10);
    }

    public byte getSol() {
        return (byte)(this.sol & 0x20);
    }

    public byte unused() {
        return (byte)(this.unused & 0xC0);
    }

    public int getMaxPowerUsage() {
        return ByteUtility.twoBytesToInt(this.maxPowerUsage) & Short.MAX_VALUE;
    }

    public int getBoardId() {
        return ByteUtility.twoBytesToInt(this.boardId);
    }

    public int getCurPower() {
        return ByteUtility.twoBytesToInt(this.curPower);
    }

    public int getDIMMSize() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.dimmSize);
    }

    public int getDIMMSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.dimmSpeed);
    }

    public int getCPUId() {
        return ByteUtility.twoBytesToInt(this.cpuId);
    }

    public int getCPUSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.cpuSpeed);
    }

    public int getVANId() {
        return ByteUtility.twoBytesToInt(this.vlanId);
    }

    public String getBMCIP() {
        return (this.bmcIp[0] & 0xFF) + "." + (this.bmcIp[1] & 0xFF) + "." + (this.bmcIp[2] & 0xFF) + "." + (this.bmcIp[3] & 0xFF);
    }

    public String getBMCMask() {
        return (this.bmcMask[0] & 0xFF) + "." + (this.bmcMask[1] & 0xFF) + "." + (this.bmcMask[2] & 0xFF) + "." + (this.bmcMask[3] & 0xFF);
    }

    public String getBMCGateway() {
        return (this.bmcGateway[0] & 0xFF) + "." + (this.bmcGateway[1] & 0xFF) + "." + (this.bmcGateway[2] & 0xFF) + "." + (this.bmcGateway[3] & 0xFF);
    }

    public String getBMCIPV6() {
        return "0";
    }

    public String getBMCMaskIPV6() {
        return "0";
    }

    public String getBMCGatewayIPV6() {
        return "0";
    }

    public String getBMCMAC() {
        return ByteUtility.byteToHex(this.bmcMac[0]) + ":" + ByteUtility.byteToHex(this.bmcMac[1]) + ":" + ByteUtility.byteToHex(this.bmcMac[2]) + ":" + ByteUtility.byteToHex(this.bmcMac[3]) + ":" + ByteUtility.byteToHex(this.bmcMac[4]) + ":" + ByteUtility.byteToHex(this.bmcMac[5]);
    }

    public String getHostMAC() {
        return ByteUtility.byteToHex(this.hostMac[0]) + ":" + ByteUtility.byteToHex(this.hostMac[1]) + ":" + ByteUtility.byteToHex(this.hostMac[2]) + ":" + ByteUtility.byteToHex(this.hostMac[3]) + ":" + ByteUtility.byteToHex(this.hostMac[4]) + ":" + ByteUtility.byteToHex(this.hostMac[5]);
    }

    public String getHostMAC2() {
        return ByteUtility.byteToHex(this.hostMac[0]) + ":" + ByteUtility.byteToHex(this.hostMac[1]) + ":" + ByteUtility.byteToHex(this.hostMac[2]) + ":" + ByteUtility.byteToHex(this.hostMac[3]) + ":" + ByteUtility.byteToHex(this.hostMac[4]) + ":" + ByteUtility.byteToHex((byte)(this.hostMac[5] + 1));
    }

    public String getServerName() {
        return new String(this.serverName).trim();
    }

    public String getModelName() {
        return new String(this.modelName).trim();
    }

    public String getBIOSVer() {
        return new String(this.biosVer).trim();
    }

    public String getBIOSDate() {
        return new String(this.biosDate).trim();
    }

    public String getDecryptedUsername() {
        String str = "";
        try {
            byte[] b2 = ByteUtility.getBytes(this.userName, 0, 24);
            str = NodeRemoteInfo.blowFishDecrypt(b2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return str;
    }

    public String getDecryptedPassword() {
        String str = "";
        try {
            byte[] b2 = ByteUtility.getBytes(this.password, 0, 24);
            str = NodeRemoteInfo.blowFishDecrypt(b2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return str;
    }

    public int getKVMPort() {
        return ByteUtility.twoBytesToInt(this.kvmPort);
    }

    public String getBMCVer() {
        return this.bmcVer[0] + "." + ByteUtility.byteToHex(this.bmcVer[1]) + "." + ByteUtility.byteToHex(this.bmcVer[2]);
    }

    public int getBladeIndex() {
        return this.bladeIndex;
    }

    public void setBladeIndex(int bladeIndex) {
        this.bladeIndex = bladeIndex;
    }

    public static final int getBladeIndex(String index) {
        int alternateIndex = -1;
        if (index.equalsIgnoreCase("A1")) {
            alternateIndex = 0;
        } else if (index.equalsIgnoreCase("A2")) {
            alternateIndex = 1;
        } else if (index.equalsIgnoreCase("A3")) {
            alternateIndex = 2;
        } else if (index.equalsIgnoreCase("A4")) {
            alternateIndex = 3;
        } else if (index.equalsIgnoreCase("A5")) {
            alternateIndex = 4;
        } else if (index.equalsIgnoreCase("A6")) {
            alternateIndex = 5;
        } else if (index.equalsIgnoreCase("A7")) {
            alternateIndex = 6;
        } else if (index.equalsIgnoreCase("A8")) {
            alternateIndex = 7;
        } else if (index.equalsIgnoreCase("A9")) {
            alternateIndex = 8;
        } else if (index.equalsIgnoreCase("A10")) {
            alternateIndex = 9;
        } else if (index.equalsIgnoreCase("A11")) {
            alternateIndex = 10;
        } else if (index.equalsIgnoreCase("A12")) {
            alternateIndex = 11;
        } else if (index.equalsIgnoreCase("A13")) {
            alternateIndex = 12;
        } else if (index.equalsIgnoreCase("A14")) {
            alternateIndex = 13;
        } else if (index.equalsIgnoreCase("B1")) {
            alternateIndex = 14;
        } else if (index.equalsIgnoreCase("B2")) {
            alternateIndex = 15;
        } else if (index.equalsIgnoreCase("B3")) {
            alternateIndex = 16;
        } else if (index.equalsIgnoreCase("B4")) {
            alternateIndex = 17;
        } else if (index.equalsIgnoreCase("B5")) {
            alternateIndex = 18;
        } else if (index.equalsIgnoreCase("B6")) {
            alternateIndex = 19;
        } else if (index.equalsIgnoreCase("B7")) {
            alternateIndex = 20;
        } else if (index.equalsIgnoreCase("B8")) {
            alternateIndex = 21;
        } else if (index.equalsIgnoreCase("B9")) {
            alternateIndex = 22;
        } else if (index.equalsIgnoreCase("B10")) {
            alternateIndex = 23;
        } else if (index.equalsIgnoreCase("B11")) {
            alternateIndex = 24;
        } else if (index.equalsIgnoreCase("B12")) {
            alternateIndex = 25;
        } else if (index.equalsIgnoreCase("B13")) {
            alternateIndex = 26;
        } else if (index.equalsIgnoreCase("B14")) {
            alternateIndex = 27;
        }
        return alternateIndex;
    }

    public String locationString(int index) {
        return NodeSensorInfo.getBladeIndex(this.bladeIndex) + " Node " + ++index;
    }

    public static final String getBladeIndex(int index) {
        String alternateBladeIndex = null;
        switch (index) {
            case 0: {
                alternateBladeIndex = "A1";
                break;
            }
            case 1: {
                alternateBladeIndex = "A2";
                break;
            }
            case 2: {
                alternateBladeIndex = "A3";
                break;
            }
            case 3: {
                alternateBladeIndex = "A4";
                break;
            }
            case 4: {
                alternateBladeIndex = "A5";
                break;
            }
            case 5: {
                alternateBladeIndex = "A6";
                break;
            }
            case 6: {
                alternateBladeIndex = "A7";
                break;
            }
            case 7: {
                alternateBladeIndex = "A8";
                break;
            }
            case 8: {
                alternateBladeIndex = "A9";
                break;
            }
            case 9: {
                alternateBladeIndex = "A10";
                break;
            }
            case 10: {
                alternateBladeIndex = "A11";
                break;
            }
            case 11: {
                alternateBladeIndex = "A12";
                break;
            }
            case 12: {
                alternateBladeIndex = "A13";
                break;
            }
            case 13: {
                alternateBladeIndex = "A14";
                break;
            }
            case 14: {
                alternateBladeIndex = "B1";
                break;
            }
            case 15: {
                alternateBladeIndex = "B2";
                break;
            }
            case 16: {
                alternateBladeIndex = "B3";
                break;
            }
            case 17: {
                alternateBladeIndex = "B4";
                break;
            }
            case 18: {
                alternateBladeIndex = "B5";
                break;
            }
            case 19: {
                alternateBladeIndex = "B6";
                break;
            }
            case 20: {
                alternateBladeIndex = "B7";
                break;
            }
            case 21: {
                alternateBladeIndex = "B8";
                break;
            }
            case 22: {
                alternateBladeIndex = "B9";
                break;
            }
            case 23: {
                alternateBladeIndex = "B10";
                break;
            }
            case 24: {
                alternateBladeIndex = "B11";
                break;
            }
            case 25: {
                alternateBladeIndex = "B12";
                break;
            }
            case 26: {
                alternateBladeIndex = "B13";
                break;
            }
            case 27: {
                alternateBladeIndex = "B14";
            }
        }
        return alternateBladeIndex;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String f2 = " %-30s | %20s \n";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format(f2, "Location", "Blade " + this.locationString(this.getIndex())));
        stringBuffer.append(String.format(f2, "Model Name", this.getModelName()));
        stringBuffer.append(String.format(f2, "Blade Max Power", this.getMaxPowerUsage()));
        stringBuffer.append(String.format(f2, "Blade Current Power", this.getCurPower()));
        stringBuffer.append(String.format(f2, "Error", this.error() == 0 ? "Normal" : Byte.valueOf(this.error)));
        stringBuffer.append(String.format(f2, "Post Code", ByteUtility.byteToHex(this.biosPostCode)));
        stringBuffer.append(String.format(f2, "BMC Version", this.getBMCVer()));
        stringBuffer.append(String.format(f2, "BMC IP Address", this.getBMCIP()));
        stringBuffer.append(String.format(f2, "BMC MAC", this.getBMCMAC()));
        stringBuffer.append(String.format(f2, "KVM", this.getKvmLaunched() == 1 ? "Launched" : "Not Launched"));
        stringBuffer.append(String.format(f2, "Blade UID", this.getUid() == 1 ? "Enabled" : "Disabled"));
        stringBuffer.append(String.format(f2, "Name", this.getServerName()));
        stringBuffer.append(String.format(f2, "Power Status", this.getPowerStatus() == 1 ? "On" : "Off"));
        stringBuffer.append(String.format(f2, "BIOS ID", this.getModelName()));
        stringBuffer.append(String.format(f2, "BIOS Version", this.getBIOSVer()));
        stringBuffer.append(String.format(f2, "BIOS Build Date", this.getBIOSDate()));
        stringBuffer.append(String.format(f2, "Num of CPU", this.cpuCount));
        stringBuffer.append(String.format(f2, "CPU ID", this.getCPUId()));
        stringBuffer.append(String.format(f2, "CPU Speed", this.getCPUSpeed() + " Mhz"));
        stringBuffer.append(String.format(f2, "Num of DIMM", this.dimmCount));
        stringBuffer.append(String.format(f2, "Memory Size", NodeSensorInfo.readableFileSize((long)this.getDIMMSize() * 1024L * 1024L)));
        stringBuffer.append(String.format(f2, "Memory Speed", this.getDIMMSpeed() + " Mhz"));
        stringBuffer.append(String.format(f2, "Num of NIC", this.lanCount));
        stringBuffer.append(String.format(f2, "NIC1 MAC", this.getHostMAC()));
        stringBuffer.append(String.format(f2, "NIC2 MAC", this.getHostMAC2()));
        return stringBuffer.toString();
    }

    public String to7UStatusFormatedHeader() {
        String formatTemplate = " %-10s | %-6s | %-8s | %-3s | %-5s | %-3s | %5s | %-13s | %-10s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Blade", "Power", "KVM", "UID", "Error", "BMC", "Watt", "MB", "Name"));
        header.append(String.format(formatTemplate, "-----", "-----", "---", "---", "-----", "---", "----", "--", "----"));
        return header.toString();
    }

    public String to7UStatusFormatedString() {
        String formatTemplate = " %-10s | %-6s | %-8s | %-3s | %-5s | %-3s | %5s | %-13s | %-10s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "Blade " + NodeSensorInfo.getBladeIndex(this.bladeIndex);
        String power = this.getPowerStatus() == 1 ? "On" : "Off";
        String kvm = this.getKvmLaunched() == 1 ? "Selected" : "";
        String uid = this.getUid() == 1 ? "On" : "";
        String error = this.error() != 0 ? "Error" : "";
        String management = "Yes";
        String watt = "";
        String mb = this.getModelName();
        String bladeName = this.getServerName();
        formatedString.append(String.format(formatTemplate, index, power, kvm, uid, error, management, watt, mb, bladeName));
        return formatedString.toString();
    }

    public String to7UConfigFormatString() {
        String retStr = "MB ID           = " + this.getModelName() + "\nCPUs            = " + this.cpuCount + "\nCPU Type        = " + this.getCPUId() + "\nCPU Speed       = " + this.getCPUSpeed() + " Mhz\nDIMMs           = " + this.dimmCount + "\nMemory Size     = " + NodeSensorInfo.readableFileSize((long)this.getDIMMSize() * 1024L * 1024L) + "\nMemory Speed    = " + this.getDIMMSpeed() + " Mhz\n";
        retStr = retStr + "LANs            = " + (this.lanCount + 1) + "\n";
        for (int i2 = 0; i2 < this.lanCount + 1; ++i2) {
            if (i2 == 0) {
                retStr = retStr + "LAN 1 MAC       = " + this.getHostMAC() + "\n";
                continue;
            }
            if (i2 != 1) continue;
            retStr = retStr + "LAN 2 MAC       = " + this.getHostMAC2() + "\n";
        }
        return retStr;
    }

    public static final String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public void setSBEntityType(int type) {
        switch (type) {
            case 1633: {
                this.sBEntity = new SB_B1SA4F();
                this.sensorLength = 168;
                break;
            }
            case 2118: {
                this.sBEntity = new SB_B1DRI();
                this.sensorLength = 444;
                break;
            }
            case 2170: {
                this.sBEntity = new SB_B1SD2();
                this.sensorLength = 276;
                break;
            }
            case 2146: {
                this.sBEntity = new SB_B1SL1();
                this.sensorLength = 252;
                break;
            }
            case 2312: {
                this.sBEntity = new SB_B2SS2();
                this.sensorLength = 228;
                break;
            }
            case 2353: {
                this.sBEntity = new SB_B2SS1();
                this.sensorLength = 240;
                break;
            }
            case 2385: {
                this.sBEntity = new SB_B2SS2_MTF();
                this.sensorLength = 240;
                break;
            }
            case 2406: {
                this.sBEntity = new SB_B11DPT();
                this.sensorLength = 648;
                break;
            }
            case 2441: {
                this.sBEntity = new SB_B10DRE();
                this.sensorLength = 612;
                break;
            }
            case 2447: {
                this.sBEntity = new SB_B11QPI();
                this.sensorLength = 1200;
                break;
            }
            case 2455: {
                this.sBEntity = new SB_B11DPE();
                this.sensorLength = 744;
                break;
            }
            case 6660: {
                this.sBEntity = new SB_B10KNM();
                this.sensorLength = 504;
                break;
            }
            case 6663: {
                this.sBEntity = new SB_B11SPE();
                this.sensorLength = 492;
                break;
            }
            case 6953: {
                this.sBEntity = new SB_B2SC1();
                this.sensorLength = 312;
                break;
            }
            case 6963: {
                this.sBEntity = new SB_B11SRE();
                this.sensorLength = 396;
                break;
            }
            case 6969: {
                this.sBEntity = new SB_B11SCG(0);
                this.sensorLength = 336;
                break;
            }
            case 6973: {
                this.sBEntity = new SB_B11SCG(1);
                this.sensorLength = 336;
                break;
            }
            case 6984: {
                this.sBEntity = new SB_B2SD2();
                this.sensorLength = 336;
                break;
            }
            case 7025: {
                this.sBEntity = new SB_B12DPT();
                this.sensorLength = 660;
                break;
            }
            case 7055: {
                this.sBEntity = new SB_BH12SSI();
                this.sensorLength = 420;
                break;
            }
            case 7042: {
                this.sBEntity = new SB_B12SPE(0);
                this.sensorLength = 492;
                break;
            }
            case 7213: {
                this.sBEntity = new SB_B12SPE(1);
                this.sensorLength = 504;
                break;
            }
            case 7228: {
                this.sBEntity = new SB_B12DPE();
                this.sensorLength = 612;
                break;
            }
            case 7238: {
                this.sBEntity = new SB_B3ST1();
                this.sensorLength = 456;
                break;
            }
            case 7285: {
                this.sBEntity = new SB_B13DET();
                this.sensorLength = 708;
                break;
            }
            case 7312: {
                this.sBEntity = new SB_B13DEE();
                this.sensorLength = 672;
                break;
            }
            case 7297: {
                this.sBEntity = new SB_B13SEE();
                this.sensorLength = 456;
                break;
            }
            case 7318: 
            case 7459: {
                this.sBEntity = new SB_B4SA1();
                this.sensorLength = 420;
                break;
            }
            case 7456: {
                this.sBEntity = new SB_B13SEG();
                this.sensorLength = 648;
                break;
            }
            case 7528: {
                this.sBEntity = new SB_B14SBE();
                this.sensorLength = 444;
                break;
            }
            case 7536: {
                this.sBEntity = new SB_B14DBT();
                this.sensorLength = 744;
            }
        }
    }
}

