/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;

public class PowerSupplyInfo
extends AbstractModuleInfo {
    public static final String CELSIUS_UNIT = "\u00b0C";
    public byte present;
    public byte psType;
    public byte temp;
    public byte tempHLimit;
    public byte[] fan1Speed;
    public byte[] fan1SpeedLLimit;
    public byte[] fan2Speed;
    public byte[] fan2SpeedLLimit;
    public byte powerStatus;
    public byte[] acRMSCur;
    public byte dcOutputCur;
    public byte firmwareVer;
    public byte fruVer;
    public byte acCurLimit;
    public byte dcCurLimit;
    public byte[] psWatt;
    public byte[] fanSpeed;
    public byte i2CError;
    public byte initialized;
    public byte pollCount;
    public byte psStatusCnt;
    public byte selReportError;
    public byte error;
    public byte lastPwrOnState;
    public byte numOfFans;
    public byte pollFanCount;
    public byte i2CResetCount;
    public byte ambientTemp;
    public byte[] modelName;
    public byte[] CurPowerConsumption;
    public byte[] PIN;
    public byte[] POUT;
    public byte[] fan3Speed;
    public byte[] acInputVolt;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.present = raw[index++];
        this.psType = raw[index++];
        this.temp = raw[index++];
        this.tempHLimit = raw[index++];
        this.fan1Speed = ByteUtility.getBytes(raw, index, 4);
        this.fan1SpeedLLimit = ByteUtility.getBytes(raw, index += 4, 4);
        this.fan2Speed = ByteUtility.getBytes(raw, index += 4, 4);
        this.fan2SpeedLLimit = ByteUtility.getBytes(raw, index += 4, 4);
        this.acRMSCur = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.powerStatus = raw[index++];
        this.dcOutputCur = raw[index++];
        this.firmwareVer = raw[index++];
        this.fruVer = raw[index++];
        this.acCurLimit = raw[index++];
        this.dcCurLimit = raw[index++];
        this.psWatt = ByteUtility.getBytes(raw, index += 2, 4);
        this.fanSpeed = ByteUtility.getBytes(raw, index += 4, 4);
        index += 4;
        this.i2CError = raw[index++];
        this.initialized = raw[index++];
        this.pollCount = raw[index++];
        this.psStatusCnt = raw[index++];
        this.selReportError = raw[index++];
        ++index;
        ++index;
        int n = ++index;
        this.error = raw[n];
        int n2 = ++index;
        this.lastPwrOnState = raw[n2];
        int n3 = ++index;
        this.numOfFans = raw[n3];
        int n4 = ++index;
        this.pollFanCount = raw[n4];
        int n5 = ++index;
        ++index;
        this.i2CResetCount = raw[n5];
        int n6 = ++index;
        this.ambientTemp = raw[n6];
        this.modelName = ByteUtility.getBytes(raw, ++index, 17);
        this.CurPowerConsumption = ByteUtility.getBytes(raw, index += 17, 4);
        this.PIN = ByteUtility.getBytes(raw, index += 4, 4);
        this.POUT = ByteUtility.getBytes(raw, index += 4, 4);
        this.fan3Speed = ByteUtility.getBytes(raw, index += 4, 4);
        this.acInputVolt = ByteUtility.getBytes(raw, index += 4, 2);
        index += 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("present =" + this.present);
        sb.append("\npresent =" + this.isPresent());
        sb.append("\npsType =" + this.psType);
        sb.append("\ntemp =" + this.temp);
        sb.append("\ntempHLimit =" + this.tempHLimit);
        sb.append("\nfan1Speed =" + this.getFan1Speed());
        sb.append("\nfan1SpeedLimit =" + this.getFan1SpeedLimit());
        sb.append("\nfan2Speed =" + this.getFan2Speed());
        sb.append("\nfan2SpeedLimit =" + this.getFan2SpeedLimit());
        sb.append("\npowerStatus =" + this.powerStatus);
        sb.append("\nacRMSCur =" + this.getACRMSCur());
        sb.append("\ndcOutputCur =" + this.dcOutputCur);
        sb.append("\nfirmwareVer =" + this.firmwareVer);
        sb.append("\nfirmwareVer =" + this.getfirmwareVer());
        sb.append("\nfruVer =" + this.fruVer);
        sb.append("\nacCurLimit =" + this.acCurLimit);
        sb.append("\ndcCurLimit =" + this.dcCurLimit);
        sb.append("\npsWatt =" + this.getPSWatt());
        sb.append("\nfanSpeed =" + this.getFanSpeed());
        sb.append("\ni2CError =" + this.i2CError);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\npsStatusCnt =" + this.psStatusCnt);
        sb.append("\nselReportError =" + this.selReportError);
        sb.append("\nerror =" + this.error);
        sb.append("\nlastPwrOnState =" + this.lastPwrOnState);
        sb.append("\nnumOfFans =" + this.numOfFans);
        sb.append("\npollFanCount =" + this.pollFanCount);
        sb.append("\ni2CResetCount =" + this.i2CResetCount);
        sb.append("\nacInputVolt =" + this.getAcInputVolt());
        sb.append("\nmodelName =" + this.getModelName());
        sb.append("\nPowerConsumption =" + this.getCurPowerConsumption());
        return sb.toString();
    }

    public boolean isPresent() {
        return (byte)(this.present & 1) == 1;
    }

    public String getfirmwareVer() {
        String ver = ByteUtility.byteToHex(this.firmwareVer);
        return ver.substring(0, 1) + "." + ver.substring(1, 2);
    }

    public int getFan1Speed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan1Speed);
    }

    public int getFan1SpeedLimit() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan1SpeedLLimit);
    }

    public int getFan2Speed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan2Speed);
    }

    public int getFan2SpeedLimit() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan2SpeedLLimit);
    }

    public float getACRMSCur() {
        return ByteBuffer.wrap(this.acRMSCur).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public int getPSWatt() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.psWatt);
    }

    public int getFanSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fanSpeed);
    }

    public int getAcInputVolt() {
        return ByteUtility.twoBytesToIntLSB(this.acInputVolt);
    }

    public int getDCOutputCurr() {
        return this.dcOutputCur & 0xFF;
    }

    public String getModelName() {
        return new String(this.modelName).trim();
    }

    public int getCurPowerConsumption() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.CurPowerConsumption);
    }

    public int getFan3Speed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.fan3Speed);
    }

    public static final int getIndex(String index) {
        int alternateIndex = -1;
        if (index.equalsIgnoreCase("A1")) {
            alternateIndex = 0;
        } else if (index.equalsIgnoreCase("A2")) {
            alternateIndex = 1;
        } else if (index.equalsIgnoreCase("A3")) {
            alternateIndex = 2;
        } else if (index.equalsIgnoreCase("A4")) {
            alternateIndex = 3;
        } else if (index.equalsIgnoreCase("B1")) {
            alternateIndex = 4;
        } else if (index.equalsIgnoreCase("B2")) {
            alternateIndex = 5;
        } else if (index.equalsIgnoreCase("B3")) {
            alternateIndex = 6;
        } else if (index.equalsIgnoreCase("B4")) {
            alternateIndex = 7;
        }
        return alternateIndex;
    }

    public static final String getIndex(int index) {
        String alternateIndex = null;
        switch (index) {
            case 0: {
                alternateIndex = "A1";
                break;
            }
            case 1: {
                alternateIndex = "A2";
                break;
            }
            case 2: {
                alternateIndex = "A3";
                break;
            }
            case 3: {
                alternateIndex = "A4";
                break;
            }
            case 4: {
                alternateIndex = "B1";
                break;
            }
            case 5: {
                alternateIndex = "B2";
                break;
            }
            case 6: {
                alternateIndex = "B3";
                break;
            }
            case 7: {
                alternateIndex = "B4";
            }
        }
        return alternateIndex;
    }

    public static final int getFanIndex(String index) {
        int alternateIndex = -1;
        if (index.equalsIgnoreCase("C1")) {
            alternateIndex = 0;
        } else if (index.equalsIgnoreCase("C2")) {
            alternateIndex = 1;
        } else if (index.equalsIgnoreCase("C3")) {
            alternateIndex = 2;
        }
        return alternateIndex;
    }

    public static final String getFanIndex(int index) {
        String alternateIndex = null;
        switch (index) {
            case 0: {
                alternateIndex = "C1";
                break;
            }
            case 1: {
                alternateIndex = "C2";
                break;
            }
            case 2: {
                alternateIndex = "C3";
            }
        }
        return alternateIndex;
    }

    public String to7UFormatedHeader() {
        String formatTemplate = " %-8s | %-5s | %5s | %5s | %5s | %5s | %-8s | %5s | %6s | %6s | %3s | %3s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "PS", "Power", "Fan 1", "Fan 2", "Fan 3", "Fan 4", "Temp.", "Watts", "DC", "AC", "F/W", "FRU"));
        header.append(String.format(formatTemplate, "--", "-----", "-----", "-----", "-----", "-----", "-----", "-----", "--", "--", "---", "---"));
        return header.toString();
    }

    public String to7UFormatedString() {
        String formatTemplate = " %-8s | %-5s | %5s | %5s | %5s | %5s | %-8s | %5s | %6s | %6s | %3s | %3s\n";
        String index = "PS " + PowerSupplyInfo.getIndex(this.getIndex());
        StringBuffer formatedString = new StringBuffer();
        String power = this.powerStatus == 1 ? "On" : "Off";
        String fan1 = "" + (this.getFan1Speed() == 0 ? "N/A" : Integer.valueOf(this.getFan1Speed()));
        String fan2 = "" + (this.getFan2Speed() == 0 ? "N/A" : Integer.valueOf(this.getFan2Speed()));
        String fan3 = "N/A";
        String fan4 = "N/A";
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String dc = this.getDCOutputCurr() > 0 ? this.getDCOutputCurr() + " A" : "N/A";
        String ac = this.getACRMSCur() > 0.0f ? decimalFormat.format(this.getACRMSCur()) + " A" : "N/A";
        String watts = "" + (this.getPSWatt() > 0 ? Integer.valueOf(this.getPSWatt()) : "N/A");
        String temperature = this.showCandF(this.temp);
        String fVersion = this.getfirmwareVer();
        String fru = ByteUtility.byteToHex(this.fruVer);
        formatedString.append(String.format(formatTemplate, index, power, fan1, fan2, fan3, fan4, temperature, watts, dc, ac, fVersion, fru));
        return formatedString.toString();
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (!this.isPresent()) {
            return "";
        }
        String f2 = " %-30s | %20s \n";
        StringBuffer stringBuffer = new StringBuffer();
        String index = "Power Supply " + PowerSupplyInfo.getIndex(this.getIndex());
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        stringBuffer.append(String.format(f2, "Power Supply", index));
        stringBuffer.append(String.format(f2, "Model Name", this.getModelName()));
        stringBuffer.append(String.format(f2, "Power Status", this.powerStatus == 1 ? "On" : "Off"));
        stringBuffer.append(String.format(f2, "Temperature", this.temp > 0 ? this.temp + CELSIUS_UNIT : "N/A"));
        stringBuffer.append(String.format(f2, "Fan1 Speed (RPM)", this.getFan1Speed()));
        if (this.numOfFans > 1) {
            stringBuffer.append(String.format(f2, "Fan2 Speed (RPM)", this.getFan2Speed()));
        }
        if (this.numOfFans > 2) {
            stringBuffer.append(String.format(f2, "Fan3 Speed (RPM)", this.getFan3Speed()));
        }
        stringBuffer.append(String.format(f2, "AC Input Voltage", this.getAcInputVolt() > 0 ? this.getAcInputVolt() + " V" : "N/A"));
        stringBuffer.append(String.format(f2, "Max Watt", this.getPSWatt() > 0 ? this.getPSWatt() + " W" : "N/A"));
        stringBuffer.append(String.format(f2, "AC Input Current", this.getACRMSCur() > 0.0f ? decimalFormat.format(this.getACRMSCur()) + " A" : "N/A"));
        stringBuffer.append(String.format(f2, "DC Output Current", this.getDCOutputCurr() > 0 ? this.getDCOutputCurr() + " A" : "N/A"));
        stringBuffer.append(String.format(f2, "Current Power Usage", this.getDCOutputCurr() > 0 ? decimalFormat.format((float)(100 * this.getDCOutputCurr() * 12) / (float)this.getPSWatt()) + "%" : "N/A"));
        stringBuffer.append(String.format(f2, "FW Version", this.getfirmwareVer()));
        stringBuffer.append(String.format(f2, "FRU Version", this.fruVer));
        stringBuffer.append(String.format(f2, "Error", this.error == 0 ? "Normal" : Byte.valueOf(this.error)));
        return stringBuffer.toString();
    }

    public String toFanFormatedString() {
        if (!this.isPresent()) {
            return "";
        }
        String f2 = " %-30s | %20s \n";
        StringBuffer stringBuffer = new StringBuffer();
        String index = "Fan " + PowerSupplyInfo.getFanIndex(this.getIndex());
        stringBuffer.append(String.format(f2, "Fan", index));
        stringBuffer.append(String.format(f2, "Model Name", this.getModelName()));
        stringBuffer.append(String.format(f2, "Power Status", this.powerStatus == 1 ? "On" : "Off"));
        stringBuffer.append(String.format(f2, "Fan1 Speed (RPM)", this.getFan1Speed()));
        if (this.numOfFans > 1) {
            stringBuffer.append(String.format(f2, "Fan2 Speed (RPM)", this.getFan2Speed()));
        }
        if (this.numOfFans > 2) {
            stringBuffer.append(String.format(f2, "Fan3 Speed (RPM)", this.getFan3Speed()));
        }
        return stringBuffer.toString();
    }

    protected String showCandF(byte c2) {
        if (c2 == -127) {
            return "N/A";
        }
        long f2 = Math.round(1.8 * (double)c2 + 32.0);
        return c2 + "C/" + (f2 < 100L ? " " : "") + f2 + "F";
    }
}

