/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;
import com.supermicro.ipmi.text.MOut;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class SB_B10KNM
extends AbstractSBEntity {
    public Sensor cpu1Temp = new Sensor();
    public Sensor pchTemp = new Sensor();
    public Sensor cpu1vrm1Temp = new Sensor();
    public Sensor cpu1vrm2Temp = new Sensor();
    public Sensor dimmABCvrmTemp = new Sensor();
    public Sensor dimmDEFvrmTemp = new Sensor();
    public Sensor system1Temp = new Sensor();
    public Sensor system2Temp = new Sensor();
    public Sensor inletTemp = new Sensor();
    public Sensor AOC_IBHTTemp = new Sensor();
    public Sensor vCCPTemp = new Sensor();
    public Sensor vCCUTemp = new Sensor();
    public Sensor vCC_CLRTemp = new Sensor();
    public Sensor vCC_MLBTemp = new Sensor();
    public Sensor p1DimmA1Temp = new Sensor();
    public Sensor p1DimmB1Temp = new Sensor();
    public Sensor p1DimmC1Temp = new Sensor();
    public Sensor p1DimmD1Temp = new Sensor();
    public Sensor p1DimmE1Temp = new Sensor();
    public Sensor p1DimmF1Temp = new Sensor();
    public Sensor v12SB = new Sensor();
    public Sensor v5SB = new Sensor();
    public Sensor v3P3 = new Sensor();
    public Sensor vBAT = new Sensor();
    public Sensor vCpu_core = new Sensor();
    public Sensor vCCU = new Sensor();
    public Sensor vCCCLR = new Sensor();
    public Sensor vDIMMABC = new Sensor();
    public Sensor vDIMMDEF = new Sensor();
    public Sensor v3P3SB = new Sensor();
    public Sensor vCCMLB = new Sensor();
    public Sensor vCCPIO = new Sensor();
    public Sensor p1V05_PCH = new Sensor();
    public Sensor vCCP0123 = new Sensor();
    public Sensor p1V5_PCH = new Sensor();
    public Sensor vCCP4567 = new Sensor();
    public Sensor AOC_OPHTemp = new Sensor();
    public Sensor watchdog = new Sensor();
    public Sensor pwr = new Sensor();
    public Sensor AOM_B_4MTemp = new Sensor();
    public Sensor AOC_B25GTemp = new Sensor();
    public Sensor nvme1_SSDTemp = new Sensor();

    @Override
    public void fromRaw(byte[] raw) {
        Field[] fields;
        super.fromRaw(raw);
        int index = 0;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                ((Sensor)field.get(this)).fromRaw(ByteUtility.getBytes(raw, index, 12));
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            index += 12;
        }
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        LinkedHashMap<Sensor, String[]> map = new LinkedHashMap<Sensor, String[]>();
        map.put(this.cpu1Temp, new String[]{"CPU Temp", "T"});
        map.put(this.pchTemp, new String[]{"PCH Temp", "T"});
        map.put(this.cpu1vrm1Temp, new String[]{"CPUVRM Temp", "T"});
        map.put(this.vCCUTemp, new String[]{"VCCU Temp", "T"});
        map.put(this.vCC_CLRTemp, new String[]{"VCC CLR Temp", "T"});
        map.put(this.vCC_MLBTemp, new String[]{"VCC MLB Temp", "T"});
        map.put(this.dimmABCvrmTemp, new String[]{"DIMMABCVRM Temp", "T"});
        map.put(this.dimmDEFvrmTemp, new String[]{"DIMMDEFVRM Temp", "T"});
        map.put(this.system1Temp, new String[]{"System Temp", "T"});
        map.put(this.system2Temp, new String[]{"Peripheral Temp", "T"});
        map.put(this.inletTemp, new String[]{"Inlet Temp", "T"});
        map.put(this.AOC_B25GTemp, new String[]{"AOC-B25G Temp", "T"});
        map.put(this.AOC_IBHTTemp, new String[]{"AOC-IBH Temp", "T"});
        map.put(this.AOC_OPHTemp, new String[]{"AOC-OPH Temp", "T"});
        map.put(this.AOM_B_4MTemp, new String[]{"AOM-B-4M Temp", "T"});
        map.put(this.p1DimmA1Temp, new String[]{"P1-DIMMA1 Temp", "T"});
        map.put(this.p1DimmB1Temp, new String[]{"P1-DIMMB1 Temp", "T"});
        map.put(this.p1DimmC1Temp, new String[]{"P1-DIMMC1 Temp", "T"});
        map.put(this.p1DimmD1Temp, new String[]{"P1-DIMMD1 Temp", "T"});
        map.put(this.p1DimmE1Temp, new String[]{"P1-DIMME1 Temp", "T"});
        map.put(this.p1DimmF1Temp, new String[]{"P1-DIMMF1 Temp", "T"});
        map.put(this.v12SB, new String[]{"12VSB", "V"});
        map.put(this.v5SB, new String[]{"5VSB", "V"});
        map.put(this.v3P3SB, new String[]{"3.3VSB", "V"});
        map.put(this.v3P3, new String[]{"3.3VCC", "V"});
        map.put(this.vBAT, new String[]{"VBAT", "B"});
        map.put(this.vCpu_core, new String[]{"Vcpu_core", "V"});
        map.put(this.vCCU, new String[]{"VCCU", "V"});
        map.put(this.vCCCLR, new String[]{"VCCCLR", "V"});
        map.put(this.vCCPIO, new String[]{"VCCPIO", "V"});
        map.put(this.vDIMMABC, new String[]{"VDIMMABC", "V"});
        map.put(this.vDIMMDEF, new String[]{"VDIMMDEF", "V"});
        map.put(this.vCCMLB, new String[]{"VCCMLB", "V"});
        map.put(this.vCCP0123, new String[]{"VCCP0123", "V"});
        map.put(this.vCCP4567, new String[]{"VCCP4567", "V"});
        map.put(this.p1V05_PCH, new String[]{"1.05V PCH", "V"});
        map.put(this.p1V5_PCH, new String[]{"1.5V PCH", "V"});
        map.put(this.watchdog, new String[]{"Watchdog", "W"});
        map.put(this.pwr, new String[]{"PW Consumption", "P"});
        map.put(this.nvme1_SSDTemp, new String[]{"NVMe1_SSD Temp", "T"});
        for (Map.Entry entry : map.entrySet()) {
            try {
                Sensor sensor = (Sensor)entry.getKey();
                String name = ((String[])entry.getValue())[0];
                String type = ((String[])entry.getValue())[1];
                if (sensor.reading == 0) {
                    formatedString.append(String.format(this.formatTemplate, "N/A", name, "N/A", "N/A", "N/A"));
                    continue;
                }
                if ("T".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(true), name, sensor.getHumanReading(sensor.reading) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.min) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.max) + "\u00b0C"));
                    continue;
                }
                if ("V".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(false), name, sensor.getHumanReading(sensor.reading) + " V", sensor.getHumanReading(sensor.min) + " V", sensor.getHumanReading(sensor.max) + " V"));
                    continue;
                }
                if ("B".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, this.vBAT.getStatusString(false).contains("Lower") ? this.vBAT.getStatusString(false) : "Normal", "VBAT", "presence", "N/A", "N/A"));
                    continue;
                }
                if ("W".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
                    continue;
                }
                if ("P".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
                    continue;
                }
                MOut.G().println("Sensor Type Not Found.");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 42;
    }
}

