/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import java.text.DecimalFormat;

public class Sensor
extends AbstractModuleInfo {
    public static final int SENSOR_LENGTH = 12;
    public byte reading;
    public byte[] m;
    public byte[] b;
    public byte k1;
    public byte k2;
    public byte min;
    public byte max;
    public byte readingType;
    public byte[] reserved;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.reading = raw[index++];
        this.m = ByteUtility.getBytes(raw, index, 2);
        this.b = ByteUtility.getBytes(raw, index += 2, 2);
        this.k1 = raw[index += 2];
        this.k2 = raw[index++];
        this.min = raw[index++];
        this.max = raw[index++];
        this.readingType = raw[index++];
        this.reserved = ByteUtility.getBytes(raw, index, 3);
        index += 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("reading =" + this.reading + "(" + ByteUtility.byteToHex(this.reading) + "h)");
        sb.append("\nm =" + this.m() + "(" + ByteUtility.bytesToHex(this.m) + "h)");
        sb.append("\nb =" + this.b() + "(" + ByteUtility.bytesToHex(this.b) + "h)");
        sb.append("\nk1 =" + this.k1 + "(" + ByteUtility.byteToHex(this.k1) + "h)");
        sb.append("\nk1 =" + this.k1());
        sb.append("\nk2 =" + this.k2());
        sb.append("\nmin =" + this.min + "(" + ByteUtility.byteToHex(this.min) + "h)");
        sb.append("\nmax =" + this.max + "(" + ByteUtility.byteToHex(this.max) + "h)");
        sb.append("\nreserved =" + ByteUtility.bytesToHex(this.reserved));
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public int m() {
        int tempM = ByteUtility.twoBytesToInt(this.m);
        int temp = tempM & 0x3FF;
        if (temp >= 512) {
            return (byte)(-(512 - (temp & 0x1F)));
        }
        return temp;
    }

    public int b() {
        int tempB = ByteUtility.twoBytesToInt(this.b);
        int temp = tempB & 0x3FF;
        if (temp >= 512) {
            return (byte)(-(512 - (temp & 0x1F)));
        }
        return temp;
    }

    public byte k1() {
        byte bexp = (byte)(this.k1 & 0xF);
        if (bexp >= 8) {
            bexp = (byte)(-(8 - (bexp & 7)));
        }
        return bexp;
    }

    public byte k2() {
        byte rexp = (byte)((this.k2 & 0xF0) >> 4);
        if (rexp >= 8) {
            rexp = (byte)(-(8 - (rexp & 7)));
        }
        return rexp;
    }

    public String getHumanReading(int reading) {
        return new DecimalFormat("#.###").format(this.calSensorReading(reading & 0xFF));
    }

    public String getHumanReadingWithSign(int reading) {
        return new DecimalFormat("#.###").format(this.calSensorReading(reading));
    }

    public double calSensorReading(int reading) {
        double rawx = ((double)(this.m() * reading) + (double)this.b() * Math.pow(10.0, this.k1())) * Math.pow(10.0, this.k2());
        return rawx;
    }

    public String getStatusString(boolean sign) {
        double maximum;
        double minimum;
        double read = this.calSensorReading(this.reading & 0xFF);
        if (sign) {
            minimum = this.calSensorReading(this.min);
            maximum = this.calSensorReading(this.max);
        } else {
            minimum = this.calSensorReading(this.min & 0xFF);
            maximum = this.calSensorReading(this.max & 0xFF);
        }
        if (read == 0.0) {
            return "N/A";
        }
        if (read > maximum && maximum != 0.0) {
            return "Higher High CT";
        }
        if (read < minimum) {
            return "Lower Low CT";
        }
        return "Normal";
    }

    public String getSSDStatusString(int reading) {
        if (reading == 0) {
            return "N/A";
        }
        if (reading == 1) {
            return "Present";
        }
        if (reading == 3) {
            return "Error";
        }
        return "Unknown";
    }
}

