/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SetNodeManagerPolicyAlertThreasholds {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte domainId;
    private byte policyId;
    private int numOfthresholds;
    private byte[] alertThresholdArray;

    public SetNodeManagerPolicyAlertThreasholds(IPMINM20Command ipmiCommand, byte domainId, byte policyId, int count, byte[] alertThresholdArray) {
        this.ipmiCommand = ipmiCommand;
        this.domainId = domainId;
        this.policyId = policyId;
        this.numOfthresholds = count;
        this.alertThresholdArray = alertThresholdArray;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.setNodeManagerAlertThresholdsCommand(this.domainId, this.policyId, (byte)this.numOfthresholds, this.alertThresholdArray);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetNodeManagerPolicyAlertThreasholds failed");
        }
    }

    public String toString() {
        return "SetNodeManagerPolicyAlertThreasholds [domainId=" + this.domainId + ", policyId=" + this.policyId + ", numOfthresholds=" + this.numOfthresholds + ", alertThresholdArray=" + Arrays.toString(this.alertThresholdArray) + "]";
    }

    static {
        completionCodeToString.put("80", "Policy ID Invalid.");
        completionCodeToString.put("81", "Domain ID Invalid.");
        completionCodeToString.put("82", "Unknown or unsupported Policy Trigger Type.");
        completionCodeToString.put("84", "Alert Thresholds is out of range.");
        completionCodeToString.put("87", "Number of thresholds is too large or power limits are invalid.");
        completionCodeToString.put("D4", "Insufficient privilege level due wrong responder LUN.");
    }
}

