/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.ByteUtility;
import java.util.Arrays;

public class PowerLimit {
    private static final int OFF_EXCEPTION_ACTION = 3;
    private static final int OFF_POWER_LIMIT = 4;
    private static final int OFF_CORRECTION_TIME = 6;
    private static final int OFF_PERIODS = 12;
    public final int exceptionAction;
    public final int powerLimit;
    public final int correctionTime;
    public final int period;

    public PowerLimit(int action, int powerLimit, int correctionTime, int period) {
        this.exceptionAction = action;
        this.powerLimit = powerLimit;
        this.correctionTime = correctionTime;
        this.period = period;
    }

    public PowerLimit(byte[] raw) {
        this.exceptionAction = raw[3];
        this.powerLimit = ByteUtility.twoBytesToInt(Arrays.copyOfRange(raw, 4, 6));
        this.correctionTime = ByteUtility.twoBytesToInt(Arrays.copyOfRange(raw, 6, 10));
        this.period = ByteUtility.twoBytesToInt(Arrays.copyOfRange(raw, 12, 14));
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Exception actions     :" + this.getExceptionActionString(this.exceptionAction) + "\n");
        sb.append("Power limit requested :" + this.powerLimit + "W\n");
        sb.append("Correction time limit :" + this.correctionTime + "ms\n");
        sb.append("Management application statistics sampling period :" + this.period + "s\n");
        return sb.toString();
    }

    private String getExceptionActionString(int action) {
        switch (action) {
            case 0: {
                return "No action";
            }
            case 1: {
                return "Hard Power Off system and log event to SEL";
            }
            case 17: {
                return "Log event to SEL";
            }
        }
        return "Undefined";
    }
}

