/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.dcmi.PowerLimit;
import java.util.HashMap;
import java.util.Map;

public class SetPowerLimit {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMIDCMICommand dcmi;
    private PowerLimit limit;

    public SetPowerLimit(IPMIDCMICommand dcmi, PowerLimit limit) {
        this.dcmi = dcmi;
        this.limit = limit;
    }

    public void execute() throws IPMIException {
        byte[] powerLimitInBytes = new byte[2];
        byte[] correctionTimeInBytes = new byte[4];
        byte[] periodInBytes = new byte[2];
        ByteUtility.intTo2Bytes(powerLimitInBytes, 0, this.limit.powerLimit);
        ByteUtility.intTo4Bytes(correctionTimeInBytes, 0, this.limit.correctionTime);
        ByteUtility.intTo2Bytes(periodInBytes, 0, this.limit.period);
        IPMIMessage resMessage = this.dcmi.setPowerLimitCommand((byte)0, (byte)0, (byte)0, (byte)this.limit.exceptionAction, powerLimitInBytes, correctionTimeInBytes, (byte)0, (byte)0, periodInBytes);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetPowerLimit failed");
        }
    }

    static {
        completionCodeToString.put("84", "Power Limit out of range.");
        completionCodeToString.put("85", "Correction Time out of range.");
        completionCodeToString.put("89", "Statistics Reporting Period out of range.");
        completionCodeToString.put("C1", "Returned if DCMI mode is not present.");
    }
}

