/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import org.apache.commons.lang3.ArrayUtils;

public class PcieInfo
extends TypeStruct {
    byte[] classCode;
    byte[] slotNumber;
    byte[] vendorId;
    byte[] deviceId;
    byte[] subVendorId;
    byte[] subDeviceId;
    byte[] linkSpeed;
    byte[] linkWidth;

    public PcieInfo(byte[] dataByte) {
        super(dataByte);
        this.classCode = this.getTypeLength(this.BYTE);
        this.slotNumber = this.getTypeLength(this.WORD);
        this.vendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.vendorId);
        this.deviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.deviceId);
        this.subVendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.subVendorId);
        this.subDeviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.subDeviceId);
        this.linkSpeed = this.getTypeLength(this.DWORD);
        this.linkWidth = this.getTypeLength(this.DWORD);
        this.strFieldCount = 3;
    }

    byte getClassCode() {
        return this.classCode[0];
    }

    int getSlotNumber() {
        return ByteUtility.twoBytesToIntLSB(this.slotNumber);
    }

    String getVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.vendorId);
    }

    String getDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.deviceId);
    }

    String getSubVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.subVendorId);
    }

    String getSubDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.subDeviceId);
    }

    int getLinkSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.linkSpeed);
    }

    int getLinkWidth() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.linkWidth);
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "PCIe Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "PCI Class Code", "0x" + ByteUtility.byteToHex(this.getClassCode())));
        fStr.append(String.format(format, "Slot Number", this.getSlotNumber()));
        fStr.append(String.format(format, "Vendor ID", "0x" + this.getVendorId()));
        fStr.append(String.format(format, "Device ID", "0x" + this.getDeviceId()));
        fStr.append(String.format(format, "SubVendor ID", "0x" + this.getSubVendorId()));
        fStr.append(String.format(format, "SubDevice ID", "0x" + this.getSubDeviceId()));
        fStr.append(String.format(format, "Link Speed", this.getLinkSpeed()));
        fStr.append(String.format(format, "Link Width", this.getLinkWidth()));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

