/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbpbi;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.smbpbi.pattern.OnHandleDisplayEventListenser;
import com.supermicro.ipmi.smbpbi.pattern.command.SMBPBIInfoCommand;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2BaseboardID;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2BaseboardRevision;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2FPGAImageVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2FPGALoadIndex;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2PCIeRetimerEEPROMVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2PCIeRetimerSourceVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2PCIeRetimerSystemIdentifier;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2PCIeRetimerVendorDeviceIDs;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.HGX2PEX8725EEPROMVersion;
import com.supermicro.ipmi.smbpbi.pattern.concreteCommand.OEMHGX2BoardDetect;
import com.supermicro.ipmi.smbpbi.pattern.invoker.SMBPBIInfoInvoker;
import com.supermicro.ipmi.smbpbi.pattern.receiver.SMBPBIInfoReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class HGX2InfoCommand {
    private final int SUB_COMMAND_COUNT = 9;
    private SMBPBIInfoReceiver receiver;
    private SMBPBIInfoInvoker invoker;
    private SMBPBIInfoCommand oemHGX2BoardDetectCommand;
    private SMBPBIInfoCommand hgx2FPGAImageVersionCommand;
    private SMBPBIInfoCommand hgx2FPGALoadIndexCommand;
    private SMBPBIInfoCommand hgx2PEX8725EEPROMVersionCommand;
    private SMBPBIInfoCommand hgx2BaseboardRevisionCommand;
    private SMBPBIInfoCommand hgx2BaseboardIDCommand;
    private List<SMBPBIInfoCommand> hgx2PCIeRetimerEEPROMVersionList;
    private List<SMBPBIInfoCommand> hgx2PCIeRetimerVendorDeviceIDList;
    private List<SMBPBIInfoCommand> hgx2PCIeRetimerSystemIdentifierList;
    private List<SMBPBIInfoCommand> hgx2PCIeRetimerSourceVersionList;
    private final OnHandleDisplayEventListenser listenser = new OnHandleDisplayEventListenser(){

        @Override
        public boolean onDisplayHandleEvent(Vector<String> resultVec, Vector<Integer> args) {
            if (resultVec.size() > 0) {
                int idx;
                int subItemIdx = 0;
                String INDENT = "  ";
                String formatTemplate = " %-40s | %15s \n";
                StringBuffer content = new StringBuffer();
                content.append(String.format(" %-40s | %15s \n", "Item", "Value"));
                content.append(String.format(" %-40s | %15s \n", "----", "-----"));
                content.append(String.format(" %-40s | %15s \n", "FPGA Image Version:", resultVec.get(subItemIdx++)));
                content.append(String.format(" %-40s | %15s \n", "FPGA Load Index:", resultVec.get(subItemIdx++)));
                content.append(String.format(" %-40s | %15s \n", "PEX8725 EEPROM Version:", resultVec.get(subItemIdx++)));
                content.append(String.format(" %-40s | %15s \n", "Baseboard Revision:", resultVec.get(subItemIdx++)));
                content.append(String.format(" %-40s | %15s \n", "Baseboard ID:", resultVec.get(subItemIdx++)));
                content.append(String.format(" %-40s | %15s \n", "PCIe Retimer EEPROM Versions", ""));
                for (idx = 0; idx < 9; ++idx) {
                    content.append(String.format(" %-40s | %15s \n", "  PCIe Retimer #" + (idx + 1) + " EEPROM Version:", resultVec.get(subItemIdx++)));
                }
                content.append(String.format(" %-40s | %15s \n", "PCIe Retimer VendorIDs", ""));
                for (idx = 0; idx < 9; ++idx) {
                    content.append(String.format(" %-40s | %15s \n", "  PCIe Retimer #" + (idx + 1) + ": ", resultVec.get(subItemIdx + idx).substring(0, 4)));
                }
                content.append(String.format(" %-40s | %15s \n", "PCIe Retimer DeviceIDs", ""));
                for (idx = 0; idx < 9; ++idx) {
                    content.append(String.format(" %-40s | %15s \n", "  PCIe Retimer #" + (idx + 1) + ": ", resultVec.get(subItemIdx++).substring(4, 8)));
                }
                content.append(String.format(" %-40s | %15s \n", "PCIe Retimer System Identifiers", ""));
                for (idx = 0; idx < 9; ++idx) {
                    content.append(String.format(" %-40s | %15s \n", "  PCIe Retimer #" + (idx + 1) + " System Identifier:", resultVec.get(subItemIdx++)));
                }
                content.append(String.format(" %-40s | %15s \n", "PCIe Retimer Source Versions", ""));
                for (idx = 0; idx < 9; ++idx) {
                    content.append(String.format(" %-40s | %15s \n", "  PCIe Retimer #" + (idx + 1) + " Source Version:", resultVec.get(subItemIdx++)));
                }
                System.out.println("");
                System.out.println("HGX2_Baseboard #" + args.get(0));
                System.out.println(content.toString());
                return true;
            }
            return false;
        }
    };

    public HGX2InfoCommand(IPMIMessagingCommand mCommand) {
        this.receiver = new SMBPBIInfoReceiver(mCommand);
        this.invoker = new SMBPBIInfoInvoker();
        this.oemHGX2BoardDetectCommand = new OEMHGX2BoardDetect(this.receiver);
        this.hgx2FPGAImageVersionCommand = new HGX2FPGAImageVersion(this.receiver);
        this.hgx2FPGALoadIndexCommand = new HGX2FPGALoadIndex(this.receiver);
        this.hgx2PEX8725EEPROMVersionCommand = new HGX2PEX8725EEPROMVersion(this.receiver);
        this.hgx2BaseboardRevisionCommand = new HGX2BaseboardRevision(this.receiver);
        this.hgx2BaseboardIDCommand = new HGX2BaseboardID(this.receiver);
        this.hgx2PCIeRetimerEEPROMVersionList = new ArrayList<SMBPBIInfoCommand>();
        this.hgx2PCIeRetimerVendorDeviceIDList = new ArrayList<SMBPBIInfoCommand>();
        this.hgx2PCIeRetimerSystemIdentifierList = new ArrayList<SMBPBIInfoCommand>();
        this.hgx2PCIeRetimerSourceVersionList = new ArrayList<SMBPBIInfoCommand>();
        for (int idx = 0; idx < 9; ++idx) {
            this.hgx2PCIeRetimerEEPROMVersionList.add(new HGX2PCIeRetimerEEPROMVersion(this.receiver, (byte)idx));
            this.hgx2PCIeRetimerVendorDeviceIDList.add(new HGX2PCIeRetimerVendorDeviceIDs(this.receiver, (byte)idx));
            this.hgx2PCIeRetimerSystemIdentifierList.add(new HGX2PCIeRetimerSystemIdentifier(this.receiver, (byte)idx));
            this.hgx2PCIeRetimerSourceVersionList.add(new HGX2PCIeRetimerSourceVersion(this.receiver, (byte)idx));
        }
        this.invoker.addCommand(this.oemHGX2BoardDetectCommand);
        this.invoker.addCommand(this.hgx2FPGAImageVersionCommand);
        this.invoker.addCommand(this.hgx2FPGALoadIndexCommand);
        this.invoker.addCommand(this.hgx2PEX8725EEPROMVersionCommand);
        this.invoker.addCommand(this.hgx2BaseboardRevisionCommand);
        this.invoker.addCommand(this.hgx2BaseboardIDCommand);
        this.invoker.addCommands(this.hgx2PCIeRetimerEEPROMVersionList);
        this.invoker.addCommands(this.hgx2PCIeRetimerVendorDeviceIDList);
        this.invoker.addCommands(this.hgx2PCIeRetimerSystemIdentifierList);
        this.invoker.addCommands(this.hgx2PCIeRetimerSourceVersionList);
    }

    public void exec() {
        Vector<Integer> args = new Vector<Integer>();
        int starIdx = 1;
        int endIdx = 2;
        for (int idx = starIdx; idx <= endIdx; ++idx) {
            args.clear();
            args.add(idx);
            this.receiver.setIndexNumber(idx, 1);
            this.invoker.sendCommand();
            this.invoker.display(this.listenser, args);
        }
    }

    public void setDebugMode(boolean inDebug) {
        this.receiver.setDebugMode(inDebug);
    }
}

