/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.MessageCenter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Observable;

public class MBScanner
extends Observable
implements Runnable {
    public HashMap foundDevice = new LinkedHashMap();
    String startIP;
    String endIP;
    String netMask;
    boolean turnOn = true;
    int scanIntervalInSec = 30;
    int scanTimeout = 5;
    int scanRetry = 1;
    Thread selfThread;
    int count = 0;

    public MBScanner(String startIP, String endIP, String netMask) {
        this.startIP = startIP;
        this.endIP = endIP;
        this.netMask = netMask;
    }

    public void startScan() {
        this.turnOn = true;
        this.selfThread = new Thread(this);
        this.selfThread.start();
    }

    public void stopScan() {
        this.turnOn = false;
    }

    @Override
    public void run() {
        while (this.turnOn) {
            System.out.println("Start scan BMC devices: " + ByteUtility.getDateTimeString());
            try {
                this.foundDevice.clear();
                this.findIPMIDevice(this.startIP, this.endIP, this.netMask);
                ++this.count;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            System.out.println("End scan BMC devices: " + ByteUtility.getDateTimeString());
        }
    }

    public void findIPMIDevice(String startIP, String endIP, String netMask) throws Exception {
        ArrayList<String> list = this.allAddress(startIP, endIP, netMask);
        ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
        this.findIPMIDevice(devices);
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        InetAddress startInet = InetAddress.getByName(startIP);
        InetAddress endInet = InetAddress.getByName(endIP);
        InetAddress maskInet = InetAddress.getByName(netmask);
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i2 = startInet.hashCode(); i2 <= endInet.hashCode(); ++i2) {
            list.add(this.intToIP(i2));
        }
        return list;
    }

    public ArrayList<FindDevice> getAllPossibleIPMIDevice(ArrayList<String> list) {
        ArrayList<FindDevice> devices = new ArrayList<FindDevice>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FindDevice device = new FindDevice(list.get(i2), this.scanTimeout, this.scanRetry);
            devices.add(device);
        }
        return devices;
    }

    public void findIPMIDevice(ArrayList<FindDevice> devices) {
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            devices.get(i2).start();
        }
        try {
            Thread.sleep(this.scanIntervalInSec * 1000);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        boolean isFoundAny = false;
        int deviceCount = 0;
        for (int i3 = 0; i3 < devices.size(); ++i3) {
            if (!devices.get((int)i3).doneGet) continue;
            ++deviceCount;
            this.foundDevice.put(devices.get((int)i3).ip, devices.get((int)i3).type);
            isFoundAny = true;
        }
        if (isFoundAny) {
            for (String ip : this.foundDevice.keySet()) {
                System.out.println(ip);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String intToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    public int getCount() {
        return this.count;
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        MBScanner scanner1 = new MBScanner("2.133.1.1", "2.133.1.255", "255.255.255.0");
        scanner1.startScan();
        try {
            Thread.sleep(10000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class FindDevice
    extends Thread {
        public String ip;
        public String type;
        boolean doneGet = false;
        int timeout;
        int retry;
        IPMIInterfaceConfig config;

        public FindDevice(String ip) {
            this(ip, 5, 1);
        }

        public FindDevice(String ip, int timeout, int retry) {
            this.ip = ip;
            this.timeout = timeout;
            this.retry = retry;
            this.config = new IPMIInterfaceConfig();
            this.config.setIp(ip);
            this.config.setTimeout(timeout);
            this.config.setRetry(retry);
        }

        @Override
        public void run() {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.ip, this.timeout, this.retry);
            if (guid != null) {
                this.type = IPMIMessagingCommand.getFWTypeByGUID(guid);
                this.doneGet = true;
            }
        }

        @Override
        public String toString() {
            String format = "  %-20s \t %-20s";
            String retStr = String.format(format, this.ip, this.type);
            return retStr;
        }
    }
}

