/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOOBLicenseCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.IPMISoftwareFRUCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.activation.CSWProductKey;
import com.supermicro.ipmi.activation.SoftwareFRU;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;

public class ActivationAPI {
    private byte[] mac;
    private IPMIInterface ipmiInterface;
    private IPMIBMCFileCommand ipmiBMCFileCommand;
    private IPMILanCommand ipmiLanCommand;
    private IPMISELCommand ipmiSELCommand;
    private IPMISoftwareFRUCommand ipmiSoftwareFRUCommand;
    private IPMIOOBLicenseCommand ipmiOOBLicenseCommand;
    private IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand;
    public int delay = 3000;
    public String key;

    private void clearSoftwareFRUByID(byte fruID) throws Exception {
        byte[] fru = new byte[256];
        Arrays.fill(fru, (byte)-1);
        byte[] swFRUID = new byte[1];
        Arrays.fill(swFRUID, (byte)-1);
        this.ipmiSoftwareFRUCommand.writeSoftwareFRUIndexByID((byte)0, fruID, swFRUID);
        this.ipmiSoftwareFRUCommand.writeSoftwareFRUByID(fruID, fru);
    }

    private void clearSignSoftwareFRUByID(byte fruID) throws Exception {
        byte[] fru = new byte[256];
        Arrays.fill(fru, (byte)-1);
        byte[] swFRUID = new byte[1];
        Arrays.fill(swFRUID, (byte)-1);
        this.ipmiSoftwareFRUCommand.writeSignSoftwareFRUIndexByID((byte)0, fruID, swFRUID);
        this.ipmiSoftwareFRUCommand.writeSignSoftwareFRUByID(fruID, fru);
    }

    private void sleep() throws InterruptedException {
        Thread.sleep(this.delay);
    }

    private int findBlankIndex() throws IPMIException {
        try {
            byte[] fru0 = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)0);
            int i2 = 1;
            while (i2 < fru0.length) {
                if (fru0[i2] == 0 || fru0[i2] == -1) {
                    return i2;
                }
                ++i2;
            }
        }
        catch (IPMIException e2) {
            return 1;
        }
        return -1;
    }

    private long getSELTime() throws Exception {
        IPMIMessage message = this.ipmiSELCommand.getSELTimeCommand();
        if (message.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(message.completionCode));
        }
        return ByteUtility.fourBytesToIntByLSBFirst(message.data);
    }

    public ActivationAPI(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        this.ipmiLanCommand = new IPMILanCommand(this.ipmiInterface);
        this.ipmiSELCommand = new IPMISELCommand(this.ipmiInterface);
        this.ipmiSoftwareFRUCommand = new IPMISoftwareFRUCommand(this.ipmiInterface);
        this.ipmiOOBLicenseCommand = new IPMIOOBLicenseCommand(this.ipmiInterface);
        this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
    }

    public ActivationAPI(IPMIInterface ipmiInterface, String key) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        this.ipmiLanCommand = new IPMILanCommand(this.ipmiInterface);
        this.ipmiSELCommand = new IPMISELCommand(this.ipmiInterface);
        this.ipmiSoftwareFRUCommand = new IPMISoftwareFRUCommand(this.ipmiInterface);
        this.ipmiOOBLicenseCommand = new IPMIOOBLicenseCommand(this.ipmiInterface);
        this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiInterface);
        this.key = key;
    }

    public boolean activateOOBKey(String key) throws Exception {
        byte[] productKey = ByteUtility.fromFormatKey(key);
        try {
            boolean result = this.ipmiX9BIOSOEMCommand.biosSetProductKey(productKey);
            return result;
        }
        catch (IPMIException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void activateNodeProductKey() throws Exception {
        int index;
        CSWProductKey ck;
        SoftwareFRU sf;
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (this.key != null) {
            this.key.replaceAll("\n", "");
        }
        if (type == IPMISoftwareFRUCommand.Type.Legacy) {
            if (this.mac == null) {
                String macStr = this.ipmiLanCommand.getMAC().replaceAll(":", "");
                this.mac = ByteUtility.hexToBytes(macStr);
            }
            long selTime = this.getSELTime();
            sf = new SoftwareFRU(this.mac, Base64.getDecoder().decode(this.key));
            ck = sf.toCSWProductKey();
            ArrayList<Object> list = new ArrayList();
            list = this.getNodeProductKeyList();
            for (CSWProductKey cSWProductKey : list) {
                if (!cSWProductKey.swIDToString().equals(ck.swIDToString())) continue;
                throw new Exception("Node product key has already been activated.");
            }
            long l = ByteUtility.fourBytesToIntByLSBFirst(ck.expirationDate);
            if (l > 0L && selTime >= l) {
                ck.bExpire = true;
            }
            if (ck.bExpire) {
                throw new Exception("Node product key has expired.");
            }
            index = this.findBlankIndex();
            if (index == -1) {
                throw new Exception("Space for storing node product keys is full.");
            }
        } else {
            if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
                throw new Exception("Not supported.");
            }
            throw new Exception("Unknown platform.");
        }
        byte[] swFRUID = new byte[]{ck.swIDToByte()};
        this.ipmiSoftwareFRUCommand.writeSoftwareFRUIndexByID((byte)0, (byte)index, swFRUID);
        this.ipmiSoftwareFRUCommand.writeSoftwareFRUByID((byte)index, sf.raw);
    }

    public void clearLicense() throws Exception {
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
            throw new Exception("Not supported.");
        }
        if (!this.ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
            this.ipmiOOBLicenseCommand.clearOOBLicense();
        }
        if (type == IPMISoftwareFRUCommand.Type.Legacy && type == IPMISoftwareFRUCommand.Type.Legacy) {
            byte[] fru0 = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)0);
            int i2 = 1;
            while (i2 < fru0.length) {
                if (fru0[i2] != 0 && fru0[i2] != -1) {
                    this.clearSoftwareFRUByID((byte)i2);
                }
                ++i2;
            }
        }
    }

    public void clearOOBLicense() throws Exception {
        if (!this.ipmiX9BIOSOEMCommand.checkIfProductNotActivated()) {
            this.ipmiOOBLicenseCommand.clearOOBLicense();
        }
    }

    public void clearNodeProductKeyAll() throws Exception {
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
            throw new Exception("Not supported.");
        }
        if (type == IPMISoftwareFRUCommand.Type.Unknown) {
            throw new Exception("Unknown platform.");
        }
        byte[] fru0 = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)0);
        int i2 = 1;
        while (i2 < fru0.length) {
            if (fru0[i2] != 0 && fru0[i2] != -1) {
                this.clearSoftwareFRUByID((byte)i2);
            }
            ++i2;
        }
    }

    public void clearNodeProductKeyByFRUID(byte fruID) throws Exception {
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
            throw new Exception("Not supported.");
        }
        if (type == IPMISoftwareFRUCommand.Type.Unknown) {
            throw new Exception("Unknown platform.");
        }
        byte[] fru0 = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)0);
        if (fru0[fruID] == 0 || fru0[fruID] == -1) {
            throw new Exception("No such FRU ID.");
        }
        this.clearSoftwareFRUByID(fruID);
    }

    public boolean checkOOBKey() throws Exception {
        return !this.ipmiX9BIOSOEMCommand.checkIfProductNotActivated();
    }

    public License getProductKeyLicense() throws Exception {
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (type == IPMISoftwareFRUCommand.Type.Legacy) {
            try {
                ArrayList<CSWProductKey> list = this.getNodeProductKeyList();
                for (CSWProductKey ck : list) {
                    if (ck.bExpire) continue;
                    return License.SFT_DCMS_SINGLE;
                }
            }
            catch (Exception ck) {
                // empty catch block
            }
            boolean result = this.ipmiX9BIOSOEMCommand.checkIfProductNotActivated();
            if (!result) {
                return License.SFT_OOB_LIC;
            }
            return License.NoProductKey;
        }
        if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
            boolean result = this.ipmiX9BIOSOEMCommand.checkIfProductNotActivated();
            if (!result) {
                return License.SFT_OOB_LIC;
            }
            return License.NotSupported;
        }
        return License.Unknown;
    }

    public ArrayList<CSWProductKey> getNodeProductKeyList() throws Exception {
        IPMISoftwareFRUCommand.Type type = this.ipmiSoftwareFRUCommand.getActivationType();
        if (type == IPMISoftwareFRUCommand.Type.Legacy) {
            ArrayList<CSWProductKey> list = new ArrayList<CSWProductKey>();
            if (this.mac == null) {
                String macStr = this.ipmiLanCommand.getMAC().replaceAll(":", "");
                this.mac = ByteUtility.hexToBytes(macStr);
            }
            long selTime = this.getSELTime();
            byte[] fru0 = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)0);
            int i2 = 1;
            while (i2 < fru0.length) {
                if (fru0[i2] != 0 && fru0[i2] != -1) {
                    byte[] fru = this.ipmiSoftwareFRUCommand.readSoftwareFRUByID((byte)i2);
                    SoftwareFRU sf = new SoftwareFRU(this.mac, fru);
                    CSWProductKey ck = sf.toCSWProductKey();
                    ck.swFRULocation = (byte)i2;
                    ck.setSwName(ck.swIDToString());
                    long expirationTime = ByteUtility.fourBytesToIntByLSBFirst(ck.expirationDate);
                    if (expirationTime != 0L && selTime >= expirationTime) {
                        ck.bExpire = true;
                    }
                    list.add(ck);
                }
                ++i2;
            }
            return list;
        }
        if (type == IPMISoftwareFRUCommand.Type.NotSupported) {
            return null;
        }
        throw new Exception("Unknown platform.");
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.163.55.200");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface ipmiInterface = sessionController.startup(config);
        if (ipmiInterface == null) {
            System.out.println("Can not connect to device");
            return;
        }
        ActivationAPI actAPI = new ActivationAPI(ipmiInterface);
        try {
            ArrayList<CSWProductKey> keys = actAPI.getNodeProductKeyList();
            int i2 = 0;
            while (i2 < keys.size()) {
                CSWProductKey ck = keys.get(i2);
                System.out.println(ck.getSwName());
                System.out.println(ck.getCreateDate());
                System.out.println(ck.getExpireDate());
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static enum License {
        NotSupported,
        NoProductKey,
        SFT_OOB_LIC,
        SFT_DCMS_SINGLE,
        Unknown;

    }
}

