/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import nn.pp.drvredir.ByteUtility;

public class BBPShutDownSettingCommand
extends SuperBladeCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand() throws Exception {
        if (this.parameters == null) {
            MOut.G(this).println("Parameter error");
            this.statusCode = 147;
            return;
        }
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean busID = false;
        boolean slaveAddr = false;
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.detectSlaveAddressFRUBBP();
        if (ipmiI2CPMBusCommand.getBusID() == 0) {
            MOut.G(this).println("Cannot detect BusID");
            this.statusCode = 0;
            return;
        }
        if (ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP() == null) {
            MOut.G(this).println("Cannot detect BBP FRU slave address");
            this.statusCode = 0;
            return;
        }
        if (this.parameters[0].equalsIgnoreCase("off")) {
            try {
                ipmiAMIOEMCommand.disablebbpShutdownTime();
                MOut.G(this).print("ShutDown Timeout has been disabled.\n");
            }
            catch (Exception e2) {
                MOut.G(this).println(e2.getMessage());
            }
        } else {
            if (!this.parameters[0].equalsIgnoreCase("on")) {
                MOut.G(this).println("Parameter error");
                this.statusCode = 147;
                return;
            }
            if (this.parameters.length == 1) {
                byte[] data = new byte[2];
                try {
                    byte[] time = ipmiAMIOEMCommand.getbbpTimeout();
                    System.arraycopy(time, 0, data, 0, 2);
                    ipmiAMIOEMCommand.enablebbpShutdownTime(data);
                    MOut.G(this).print("ShutDown Timeout has been enabled.\n");
                }
                catch (Exception e3) {
                    MOut.G(this).println(e3.getMessage());
                }
            } else {
                int sec = Integer.parseInt(this.parameters[1]);
                byte[] data = new byte[2];
                ByteUtility.intTo2Bytes(data, 0, sec);
                try {
                    ipmiAMIOEMCommand.enablebbpShutdownTime(data);
                    MOut.G(this).print("ShutDown Timeout has been enabled.\n");
                    if (sec < 1 || sec > 600) {
                        MOut.G(this).print("The range of timeout should between 1 to 600(s).\n");
                    }
                }
                catch (Exception e4) {
                    MOut.G(this).println(e4.getMessage());
                }
            }
        }
        this.statusCode = 0;
    }
}

