/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BBPThrottleStatusCommand
extends SuperBladeCommand {
    private static final byte BBP_STATUS_THROTTLE_AND_DISCHARGE = 85;
    private static final byte BBP_STATUS_NO_THROTTLE_AND_CHARGE = -86;
    private static final byte BBP_STATUS_NO_THROTTLE_AND_DISCHARGE_TO_EMPTY = 102;

    @Override
    public boolean preValidate() {
        if (super.getParameters() != null) {
            int param2;
            int param1 = this.convertStringToInt(super.getParameters()[0]);
            if (param1 >= 0 && 1 >= param1 && (super.getParameters().length <= 1 || (param2 = this.convertStringToInt(super.getParameters()[1])) >= 0 && 2 >= param2)) {
                return true;
            }
            MOut.G(this).println("Invalid parameter");
        } else {
            MOut.G(this).println("Insufficient parameter");
        }
        MOut.G(this).println(this.usage());
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand command = new IPMII2CPMBusCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte cmmType = this.convertStringToByte(super.getParameters()[0]);
        if (super.getParameters().length == 1) {
            byte res = command.getBBPThrottleStatus(cmmType);
            switch (res) {
                case 85: {
                    MOut.G(this).println("active");
                    this.statusCode = 0;
                    break;
                }
                case 102: {
                    MOut.G(this).println("inactive and discharge battery to 0%");
                    this.statusCode = 0;
                    break;
                }
                case -86: {
                    MOut.G(this).println("inactive");
                    this.statusCode = 0;
                    break;
                }
                default: {
                    MOut.G(this).println(MessageCenter.getInstance().getMessage());
                    this.statusCode = 149;
                    break;
                }
            }
        } else {
            byte value = this.convertStringToByte(super.getParameters()[1]);
            byte status = this.convertEnumToByte(value);
            boolean res = command.setBBPThrottleStatus(cmmType, status);
            if (res) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        }
    }

    private int convertStringToInt(String value) {
        int res = -1;
        try {
            res = Integer.parseUnsignedInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    private byte convertStringToByte(String value) {
        byte res = 0;
        try {
            res = Byte.parseByte(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    private byte convertEnumToByte(Byte value) {
        byte status = 0;
        switch (value) {
            case 0: {
                status = -86;
                break;
            }
            case 1: {
                status = 85;
                break;
            }
            case 2: {
                status = 102;
            }
        }
        return status;
    }

    private String usage() {
        String usage = "Usage: bbp throttling <type> [status]" + System.lineSeparator() + "type:" + System.lineSeparator() + "  0: CMM-3" + System.lineSeparator() + "  1: CMM-6" + System.lineSeparator() + "status:" + System.lineSeparator() + "  0: inactive" + System.lineSeparator() + "  1: active";
        return usage;
    }
}

