/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ATENFlashBios;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIOEMRoTCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishFlash;
import com.supermicro.redfish.RedfishFlashARM;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.util.HashMap;

public class BIOSUpdateRedfishCommand
extends SuperBladeCommand {
    public static final String NEWHII = "InternalFwVersion/NewHII";
    public static final String BIOS_RUNTIME_UPDATE = "InternalFwVersion/BIOSRuntimeUpdate";
    String HIIVersion = "00.00";
    String runtimeUpdate = "00.00";
    boolean preserveNVRAM = false;
    boolean preserveSMBIOS = false;
    boolean preserveME = false;
    boolean preserveOA = false;
    boolean preserveSetupConfig = false;
    boolean preserveSetupPWD = false;
    boolean preserveSecBootKey = false;
    boolean preserveBootConfig = false;
    String backupImage = "false";
    boolean reboot = false;
    boolean forceUpdate = false;
    boolean checkboardID = true;
    boolean isUpdateByRedfishARM = false;
    boolean isUpdateByRedfishLegacy = false;
    boolean isUpdateByCGI = false;

    @Override
    public boolean preValidate() {
        this.preserveNVRAM = false;
        this.preserveSMBIOS = false;
        this.preserveME = false;
        this.preserveOA = false;
        this.preserveSetupConfig = false;
        this.preserveSetupPWD = false;
        this.preserveSecBootKey = false;
        this.preserveBootConfig = false;
        this.reboot = false;
        this.forceUpdate = false;
        this.backupImage = "false";
        if (this.parameters == null) {
            MOut.G(this).println("BIOS image filename is needed");
            MOut.G(this).println("");
            MOut.G(this).println("Preserve option");
            MOut.G(this).println("-me              Preserve ME");
            MOut.G(this).println("-smbios          Preserve SMBIOS");
            MOut.G(this).println("-nvram           Preserve NVRAM");
            MOut.G(this).println("-oa              Preserve OA  (For Tatlow and later platform)");
            MOut.G(this).println("-setupconfig     Preserve BIOS Setup Configuration (For Tatlow and later platform)");
            MOut.G(this).println("-setuppwd        Preserve BIOS Setup password  (For Tatlow and later platform)");
            MOut.G(this).println("-seckey          Preserve BIOS Secure Boot Keys  (For Tatlow and later platform)");
            MOut.G(this).println("-bootconfig      Preserve BIOS Boot Options Configuration  (For Tatlow and later platform)");
            MOut.G(this).println("-backup          Backup image (Rot only)");
            MOut.G(this).println("-reboot          Force power down to proceed update if needed / Perform reset after update");
            MOut.G(this).println("-forceUpdate     Force BIOS to ignore update check");
            MOut.G(this).println("");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        String options = "";
        if (this.parameters.length > 1) {
            for (int i2 = 1; i2 < this.parameters.length; ++i2) {
                options = options + this.parameters[i2] + " ";
            }
            if (options.toLowerCase().indexOf("-nvram") != -1) {
                MOut.G(this).println("Option: preserve NVRAM");
                this.preserveNVRAM = true;
            }
            if (options.toLowerCase().indexOf("-smbios") != -1) {
                MOut.G(this).println("Option: preserve SMBIOS");
                this.preserveSMBIOS = true;
            }
            if (options.toLowerCase().indexOf("-me") != -1) {
                MOut.G(this).println("Option: preserve ME");
                this.preserveME = true;
            }
            if (options.toLowerCase().indexOf("-oa") != -1) {
                MOut.G(this).println("Option: preserve OA");
                this.preserveOA = true;
            }
            if (options.toLowerCase().indexOf("-setupconfig") != -1) {
                MOut.G(this).println("Option: preserve Setup Configuration");
                this.preserveSetupConfig = true;
            }
            if (options.toLowerCase().indexOf("-setuppwd") != -1) {
                MOut.G(this).println("Option: preserve Setup Password");
                this.preserveSetupPWD = true;
            }
            if (options.toLowerCase().indexOf("-seckey") != -1) {
                MOut.G(this).println("Option: preserve Secure Boot Key");
                this.preserveSecBootKey = true;
            }
            if (options.toLowerCase().indexOf("-bootconfig") != -1) {
                MOut.G(this).println("Option: preserve Boot Options Configuration");
                this.preserveBootConfig = true;
            }
            if (options.toLowerCase().indexOf("-reboot") != -1) {
                MOut.G(this).println("Option: Force power down to proceed update if needed");
                MOut.G(this).println("        Perform reset after update");
                this.reboot = true;
            }
            if (options.toLowerCase().indexOf("-forceupdate") != -1) {
                MOut.G(this).println("Option: Bios force updating");
                this.forceUpdate = true;
            }
            if (options.toLowerCase().indexOf("-backup") != -1) {
                MOut.G(this).println("Option: Backup image");
                this.backupImage = "true";
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand() throws Exception {
        byte[] boardIDfromBMC;
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (!IPMIMessagingCommand.isH12GUID(guid) && IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB12RoTHW1GUID(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid)) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        this.isUpdateByCGI = false;
        this.isUpdateByRedfishLegacy = false;
        this.isUpdateByRedfishARM = false;
        if (IPMIMessagingCommand.isH12GUID(guid)) {
            LicenseManager lm = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
            if (!lm.checkIfLicenseExist()) {
                MOut.G(this).println("The node product key needs to be activated for this device");
                this.statusCode = 155;
                return;
            }
            if (lm.checkIfDCMSLicenseExist()) {
                this.isUpdateByRedfishLegacy = true;
            } else {
                this.isUpdateByCGI = true;
            }
        } else if (IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid)) {
            this.isUpdateByRedfishARM = true;
            this.checkboardID = false;
        }
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            byte[] featureFlagArray = ipmiBMCFileCommand.generalFileDownloadbyArray((byte)10, false, false);
            if (featureFlagArray[1] >= 2 && (featureFlagArray[20] & 0x20) == 32 || featureFlagArray[1] >= 8 && (featureFlagArray[21] & 8) == 8) {
                MOut.G(this).println("This device does not support OOB BIOS update");
                this.statusCode = 153;
                return;
            }
        }
        catch (Exception featureFlagArray) {
            // empty catch block
        }
        String filename = this.parameters[0];
        File biosFile = new File(filename);
        if (!biosFile.isFile()) {
            MOut.G(this).println("File is not found");
            this.statusCode = 147;
            return;
        }
        if (!(this.isUpdateByRedfishLegacy || this.isUpdateByRedfishARM || this.isUpdateByCGI)) {
            String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
            String url = "https://" + ip + "/restapi/smci/BmcInfo/";
            RedfishHttpUtils utils = new RedfishHttpUtils();
            utils.sendRedfishGet(this.config, url);
            HashMap<String, String> entryMap = utils.getEntry();
            if (entryMap.get(NEWHII) != null) {
                this.HIIVersion = entryMap.get(NEWHII);
            }
            if (entryMap.get(BIOS_RUNTIME_UPDATE) != null) {
                this.runtimeUpdate = entryMap.get(BIOS_RUNTIME_UPDATE);
            }
            if (this.HIIVersion.equals("00.00")) {
                if (this.preserveOA) {
                    MOut.G(this).println("-oa is not supported on this platform");
                    this.statusCode = 147;
                    return;
                }
                if (this.preserveSetupConfig) {
                    MOut.G(this).println("-setupconfig is not supported on this platform");
                    this.statusCode = 147;
                    return;
                }
                if (this.preserveSetupPWD) {
                    MOut.G(this).println("-setuppwd is not supported on this platform");
                    this.statusCode = 147;
                    return;
                }
                if (this.preserveSecBootKey) {
                    MOut.G(this).println("-seckey is not supported on this platform");
                    this.statusCode = 147;
                    return;
                }
                if (this.preserveBootConfig) {
                    MOut.G(this).println("-bootconfig is not supported on this platform");
                    this.statusCode = 147;
                    return;
                }
            }
        }
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean isPowerOn = ipmiChassisCommand.isPowerOn();
        if (!this.isUpdateByRedfishLegacy && !this.isUpdateByRedfishARM && !this.isUpdateByCGI && this.runtimeUpdate.equals("00.00") && !IPMIMessagingCommand.isNonROT(guid) && isPowerOn) {
            if (!this.reboot) {
                MOut.G(this).println("Update BIOS image requires system power off");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Update BIOS image requires system power off");
            MOut.G(this).println("\nGoing to force shutdown the system");
            ipmiChassisCommand.powerDown();
            Thread.sleep(2000L);
            int i2 = 0;
            MOut.G(this).println("Detecting system power status");
            while (true) {
                Thread.sleep(1000L);
                if (i2++ >= 10) {
                    MOut.G(this).println("Can not shut down this system");
                    this.statusCode = 149;
                    return;
                }
                try {
                    if (ipmiChassisCommand.isPowerOn()) continue;
                }
                catch (IPMIException iPMIException) {
                    continue;
                }
                break;
            }
            MOut.G(this).println("\nSystem power status: off");
            Thread.sleep(2000L);
        }
        long start = System.currentTimeMillis();
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        MOut.G(this).println("===============");
        MOut.G(this).println("BIOS Image info");
        MOut.G(this).println("===============");
        IPMIX9BIOSOEMCommand.BIOSInfo biosFileInfo = null;
        try {
            biosFileInfo = ipmiX9BIOSOEMCommand.checkBIOSImage(filename, false, 8192);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (biosFileInfo == null) {
            try {
                biosFileInfo = ipmiX9BIOSOEMCommand.checkBIOSImage(filename, false, 10240);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (biosFileInfo == null) {
            MOut.G(this).println("BIOS File invalid");
            this.statusCode = 147;
            return;
        }
        MOut.G(this).println(biosFileInfo.toStringFromBIOSImage());
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.checkboardID && ((boardIDfromBMC = ipmiOEMCommand.getProductID())[0] != biosFileInfo.boardID[0] || boardIDfromBMC[1] != biosFileInfo.boardID[1])) {
            String fileBIOSID = ByteUtility.bytesToHex(biosFileInfo.boardID);
            String bmcBIOSID = ByteUtility.bytesToHex(boardIDfromBMC);
            MOut.G(this).println("BIOS File invalid (Board ID mismatch. (" + fileBIOSID + ")(" + bmcBIOSID + "))");
            this.statusCode = 149;
            return;
        }
        if (this.forceUpdate) {
            IPMIOEMRoTCommand ipmiROTCommand = new IPMIOEMRoTCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmiROTCommand.setBIOSForceUpdate(true);
        }
        String body = "{\"Targets\":[\"/redfish/v1/Systems/1/Bios\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\",\r\n\"Oem\":{\"Supermicro\":{\"BIOS\":{\"PreserveME\":" + this.preserveME + ",\r\n\"PreserveNVRAM\":" + this.preserveNVRAM + ",\r\n\"PreserveSMBIOS\":" + this.preserveSMBIOS + ",\r\n\"BackupBIOS\":" + this.backupImage + "}}}}";
        if (this.HIIVersion.equals("01.00")) {
            body = "{\"Targets\":[\"/redfish/v1/Systems/1/Bios\"],\r\n\"@Redfish.OperationApplyTime\":\"Immediate\",\r\n\"Oem\":{\"Supermicro\":{\"BIOS\":{\"PreserveME\":" + this.preserveME + ",\r\n\"PreserveNVRAM\":" + this.preserveNVRAM + ",\r\n\"PreserveSMBIOS\":" + this.preserveSMBIOS + ",\r\n\"PreserveOA\":" + this.preserveOA + ",\r\n\"PreserveSETUPCONF\":" + this.preserveSetupConfig + ",\r\n\"PreserveSETUPPWD\":" + this.preserveSetupPWD + ",\r\n\"PreserveSECBOOTKEY\":" + this.preserveSecBootKey + ",\r\n\"PreserveBOOTCONF\":" + this.preserveBootConfig + ",\r\n\"BackupBIOS\":" + this.backupImage + "}}}}";
        }
        if (this.isUpdateByRedfishLegacy) {
            body = "{\"PreserveME\":" + this.preserveME + ",\r\n\"PreserveNVRAM\":" + this.preserveNVRAM + ",\r\n\"PreserveSMBIOS\":" + this.preserveSMBIOS + "}";
        }
        this.sessionController.closeSession();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.setMOut(MOut.G(this));
        MOut.G(this).println("");
        MOut.G(this).println("==================");
        MOut.G(this).println("Start BIOS Upgrade");
        MOut.G(this).println("==================");
        if (this.isUpdateByRedfishLegacy) {
            if (!redfishFlash.flashBIOSLegacy(this.config, this.parameters[0], body)) {
                this.statusCode = 149;
                return;
            }
        } else if (this.isUpdateByRedfishARM) {
            RedfishFlashARM utils = new RedfishFlashARM();
            if (!utils.flash(this.config, this.parameters[0], 1)) {
                this.statusCode = 149;
                return;
            }
        } else if (this.isUpdateByCGI) {
            ATENFlashBios cgiFlash = new ATENFlashBios();
            cgiFlash.setProgress(cgiFlash);
            cgiFlash.flashWorker(this.config, filename, this.preserveME, this.preserveNVRAM, this.preserveSMBIOS);
        } else if (!redfishFlash.flashBIOS(this.config, this.parameters[0], body)) {
            this.statusCode = 149;
            return;
        }
        redfishFlash.printTimeString("\nTotal Elapsed Time", System.currentTimeMillis() - start);
        if (IPMIMessagingCommand.isNonROT(guid) && this.reboot || this.isUpdateByRedfishLegacy && this.reboot || this.isUpdateByCGI && this.reboot) {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, ipmiChassisCommand);
            if (ipmiChassisCommand.isPowerOn()) {
                ipmiChassisCommand.reset();
                MOut.G(this).println("System will perform reset soon.");
            } else {
                ipmiChassisCommand.powerUp();
                MOut.G(this).println("System will be powered up soon.");
            }
        } else if (!IPMIMessagingCommand.isNonROT(guid) && this.reboot) {
            if (IPMIMessagingCommand.isB4SA1GUID(guid)) {
                this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, ipmiChassisCommand);
                if (ipmiChassisCommand.isPowerOn()) {
                    ipmiChassisCommand.reset();
                    MOut.G(this).println("System will perform reset soon.");
                } else {
                    ipmiChassisCommand.powerUp();
                    MOut.G(this).println("System will be powered up soon.");
                }
            } else if (!this.runtimeUpdate.equals("00.00") && isPowerOn) {
                this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, ipmiChassisCommand);
                ipmiChassisCommand.reset();
                MOut.G(this).println("System will perform reset soon.");
            }
        }
        this.statusCode = 0;
        this.ignoreSessionClose(true);
    }
}

