/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class BIOSVerCommand
extends BIOSAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        if (this.parameters != null && this.parameters.length == 1 && this.parameters[0].equalsIgnoreCase("-rom")) {
            if (!this.checkIfSupportBIOSUpdate()) {
                MOut.G(this).println("This device doesn't support BIOS commands");
                MOut.G(this).println("BIOS commands only support X9 series montherboards");
                this.statusCode = 153;
                return;
            }
            IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            if (acpiInfo.getSystemState() == 0 || acpiInfo.getSystemState() == 1 || acpiInfo.getSystemState() == 2 || acpiInfo.getSystemState() == 3) {
                if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                    this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    try {
                        String amiBIOSVerString = this.ipmiX9BIOSOEMCommand.getBIOSVersionForAMIX9AndSystemIsOn();
                        MOut.G(this).println(amiBIOSVerString);
                        this.statusCode = 0;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        this.statusCode = 149;
                        MOut.G(this).println("Get BIOS Info failed");
                    }
                    return;
                }
            }
            if (!this.getBIOSInfo()) {
                MOut.G(this).println("Get BIOS Info failed");
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println(this.biosInfo.toStringFromBMC());
            this.statusCode = 0;
        } else {
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            byte[] bytes = ipmiOEMCommand.getBiosDate();
            if (bytes == null) {
                MOut.G(this).println("Can not get BIOS date");
                this.statusCode = 0;
                return;
            }
            String dateString = new String(bytes);
            char c2 = dateString.toCharArray()[0];
            if (c2 != '\u0000') {
                dateString = ByteUtility.transferDateFormatFromBiosFormat(dateString);
            }
            if ((bytes = ipmiOEMCommand.getBiosVer()) == null) {
                MOut.G(this).println("Can not get BIOS Rev.");
                this.statusCode = 0;
                return;
            }
            String revString = new String(bytes).trim();
            MOut.G(this).println("BIOS Date : " + dateString + " Rev " + revString);
            this.statusCode = 0;
        }
    }
}

