/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCNetmaskSettingCommand
extends SuperBladeCommand {
    public BladeBMCNetmaskSettingCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            if (this.parameters != null && this.parameters.length == 1) {
                String newIP = this.parameters[0];
                if (!IPMILanCommand.isIPAddress(newIP)) {
                    MOut.G(this).println("Netmask format error!");
                    this.statusCode = 147;
                    return;
                }
                boolean b2 = this.writeSIMBLNetmask(newIP);
                if (b2) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
            } else if (bladeSystem.isIsSupportIPMB()) {
                this.showSIMBLNetmask();
                this.statusCode = 0;
            } else {
                MOut.G(this).println("BMC installed, but cannot get Netmask");
                this.statusCode = 149;
            }
        } else {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
        }
    }

    public void showSIMBLNetmask() throws IPMIException {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.sessionController != null) {
            this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(false);
            String ip = ipmiLanCommand.getSubnetMaskEx();
            this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(true);
            if (ip != null) {
                MOut.G(this).println(ip);
            } else {
                MOut.G(this).println("BMC Installed");
            }
        }
    }

    public boolean writeSIMBLNetmask(String ip) throws IPMIException {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        boolean b2 = false;
        this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(false);
        b2 = ipmiLanCommand.setSubnetMaskEx(ip);
        this.ipmiCMMOEMCommand.setEnabledNormalFunctionCommand(true);
        return b2;
    }
}

