/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCUserAddCommand
extends SuperBladeCommand {
    byte userID;
    String username;
    String password;
    byte privilege;

    public BladeBMCUserAddCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        String usage = "Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nCallback            : 1";
        if (this.parameters == null || this.parameters.length != 4) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        this.username = this.parameters[1];
        if (this.username.length() > 20) {
            MOut.G(this).println("username should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        this.password = this.parameters[2];
        if (this.password.length() > 20) {
            MOut.G(this).println("password should less then 20 characters");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("privilege should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.privilege < 1 || this.privilege > 4) {
            MOut.G(this).println("Privilege level error");
            MOut.G(this).println("Administrator level : 4");
            MOut.G(this).println("operator level      : 3");
            MOut.G(this).println("user level          : 2");
            MOut.G(this).println("callback            : 1");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMB ipmb = new IPMB(ipmiMessagingCommand.getIPMIInterface());
            ipmb.setIpmbType(1);
            ipmiMessagingCommand.setIPMIInterface(ipmb);
            byte index = Byte.parseByte((String)this.preParameters.get(1));
            ipmb.setChannel(index);
            boolean b1 = ipmiMessagingCommand.setUserNameByID(this.userID, this.username);
            if (!b1) {
                MOut.G(this).println("Set user name failed");
                this.statusCode = 149;
                return;
            }
            boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, this.password);
            if (!b2) {
                MOut.G(this).println("Set user password failed");
                this.statusCode = 149;
                return;
            }
            boolean b3 = ipmiMessagingCommand.setEnableUserByID(this.userID);
            if (!b3) {
                MOut.G(this).println("Set enable user failed");
                this.statusCode = 149;
                return;
            }
            boolean b4 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, this.privilege);
            if (!b4) {
                MOut.G(this).println("Set user privilege failed");
                this.statusCode = 149;
                return;
            }
            boolean b5 = ipmiMessagingCommand.setEnableUserPlusByID(this.userID, this.privilege);
            if (!b5) {
                MOut.G(this).println("Set enable user(+) failed");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
        }
    }
}

