/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCUserListCommand
extends SuperBladeCommand {
    public BladeBMCUserListCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMB ipmb = new IPMB(ipmiMessagingCommand.getIPMIInterface());
            ipmb.setIpmbType(1);
            ipmiMessagingCommand.setIPMIInterface(ipmb);
            byte index = Byte.parseByte((String)this.preParameters.get(1));
            ipmb.setChannel(index);
            int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
            int countOfCurrentEnabledUser = ipmiMessagingCommand.getCountOfCurrentEnabledUser();
            MOut.G(this).println("Maximum number of Users          : " + numberOfAvailableUser);
            MOut.G(this).println("Count of currently enabled Users : " + countOfCurrentEnabledUser);
            String formatTemplate = "%8s | %-14s | %-18s | %-12s \n";
            MOut.G(this).printf(formatTemplate, "User ID", "User Name", "Privilege Level", "Enable");
            MOut.G(this).printf(formatTemplate, "-------", "-----------", "---------------", "------");
            for (int i2 = 2; i2 <= numberOfAvailableUser; ++i2) {
                String name = ipmiMessagingCommand.getUserNameByID((byte)i2);
                if (name == null || name.length() == 0) continue;
                byte privilege = ipmiMessagingCommand.getUserPrivilegeByID((byte)i2);
                boolean isEnabled = ipmiMessagingCommand.isEnableUser((byte)i2);
                MOut.G(this).printf(formatTemplate, "" + i2, name, this.getPriviledgeString(privilege), isEnabled ? "Yes" : "No");
            }
            this.statusCode = 0;
        } else {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
        }
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "CallBack";
            }
        }
        return "";
    }
}

