/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCVLANCommand
extends SuperBladeCommand {
    public BladeBMCVLANCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (!bladeEntity.isSimCardDetectPin()) {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
            return;
        }
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.parameters != null && this.parameters.length == 2) {
            int vlanTag = 0;
            boolean isEnable = false;
            boolean result = false;
            if (this.parameters[0].equalsIgnoreCase("enable")) {
                isEnable = true;
            } else if (this.parameters[0].equalsIgnoreCase("disable")) {
                isEnable = false;
            } else {
                MOut.G(this).println("Parameter error!");
                this.statusCode = 147;
                return;
            }
            try {
                vlanTag = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("VLAN Tag invalid");
                this.statusCode = 147;
                return;
            }
            if (vlanTag > 4094 || vlanTag < 0) {
                MOut.G(this).println("VLAN Tag Invalid. 0 < vlanTag < 4095 ");
                this.statusCode = 147;
                return;
            }
            try {
                result = ipmiLanCommand.setVLANEnabled(isEnable, vlanTag);
                if (result) {
                    MOut.G(this).println("Done");
                    this.printVLANStatus(ipmiLanCommand);
                    this.statusCode = 0;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
            catch (IPMIException ex1) {
                MOut.G(this).println(ex1.getMessage());
                this.statusCode = 149;
                return;
            }
        } else {
            this.printVLANStatus(ipmiLanCommand);
        }
    }

    private void printVLANStatus(IPMILanCommand ipmiLanCommand) {
        int vlanTag;
        boolean isEnable;
        try {
            isEnable = ipmiLanCommand.isVLANEnabled();
            vlanTag = ipmiLanCommand.getVLANTag();
        }
        catch (IPMIException ex) {
            MOut.G(this).println("failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("VLAN : " + (isEnable ? "Enable" : "Disable"));
        MOut.G(this).println("VLAN Tag: " + vlanTag);
    }
}

