/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class BladeBurstAbstractCommand
extends SuperBladeCommand {
    byte type;
    byte[] b;

    public BladeBurstAbstractCommand() {
        super.setMasterCheckingRequired(true);
    }

    public boolean getBladeIndexes() {
        int i2;
        int maxBlade = this.getBladeMaxSize();
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i2 = 0; i2 < this.parameters.length; ++i2) {
            try {
                byte value = Byte.parseByte(this.parameters[i2]);
                if (value <= 0 || value > maxBlade) continue;
                list.add(value);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return false;
        }
        this.b = new byte[list.size()];
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.b[i2] = (Byte)list.get(i2);
        }
        return true;
    }

    public boolean getMicroBladeIndexes() {
        int i2;
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i2 = 0; i2 < this.parameters.length; ++i2) {
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(this.parameters[i2]);
            if (bIndex == -1) continue;
            list.add(bIndex);
        }
        if (list.size() == 0) {
            return false;
        }
        this.b = new byte[list.size()];
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.b[i2] = (Byte)list.get(i2);
        }
        return true;
    }

    public void getAllPresentMicroBlade(IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand) throws IPMIException {
        int i2;
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i2 = 0; i2 < 28; i2 = (int)((byte)(i2 + 1))) {
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo((byte)i2);
            if (!bladeRemoteInfo.isPresent()) continue;
            list.add((byte)i2);
        }
        this.b = new byte[list.size()];
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.b[i2] = (Byte)list.get(i2);
        }
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            if (this.b.length == 1 && this.b[0] == -1) {
                this.getAllPresentMicroBlade(ipmiMicroBladeOEMCommand);
            }
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                try {
                    int nodeCount = ipmiMicroBladeOEMCommand.getBladeRemoteInfo((byte)this.b[i2]).nodeCount;
                    for (int j2 = 0; j2 < nodeCount; ++j2) {
                        boolean result = ipmiMicroBladeOEMCommand.cmmBurst(this.b[i2], (byte)j2, this.type);
                        if (result) continue;
                        MOut.G(this).println("Error happened when executing on blade " + NodeSensorInfo.getBladeIndex(this.b[i2]));
                    }
                    continue;
                }
                catch (IPMIException e2) {
                    MOut.G(this).println("Error happened when executing on blade " + NodeSensorInfo.getBladeIndex(this.b[i2]));
                }
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        try {
            byte result = this.ipmiCMMOEMCommand.burstPowerControl(this.type, this.b);
            if (result == 0) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else if (result == 1) {
                MOut.G(this).println("No enough power");
                this.statusCode = 149;
            } else {
                MOut.G(this).println("Unknown error (" + ByteUtility.byteToHex(result) + "h)");
                this.statusCode = 149;
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Not a supported command");
            this.statusCode = 153;
        }
    }
}

