/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DCPMMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.LinkedList;

public class DCPMMStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        DCPMMCommand dcpmmCommand = new DCPMMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] bitmap = dcpmmCommand.getDCMMPresentBitmap();
        LinkedList<DCPMMCommand.DIMM> presentDimm = new LinkedList<DCPMMCommand.DIMM>();
        if (bitmap == null) {
            MOut.G(this).println("Can't execute GetDCPMM Bitmap Command");
            this.statusCode = 149;
            return;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((bitmap[i2] & 1 << j2) != 1 << j2) continue;
                DCPMMCommand dCPMMCommand = dcpmmCommand;
                dCPMMCommand.getClass();
                DCPMMCommand.DIMM dimm = dCPMMCommand.new DCPMMCommand.DIMM(i2, j2);
                presentDimm.add(dimm);
            }
        }
        String f2 = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(f2, "DIMM Locate", "Firmware version"));
        fStr.append(String.format(f2, "---------------", "-------------------------"));
        for (int i3 = 0; i3 < presentDimm.size(); ++i3) {
            DCPMMCommand.DIMM dimm = (DCPMMCommand.DIMM)presentDimm.get(i3);
            String fwVersion = dcpmmCommand.getDimmFWVersion((byte)dimm.getCpu(), (byte)dimm.getChannel(), (byte)dimm.getSlot());
            if (fwVersion != null) {
                dimm.setVersion(fwVersion);
                fStr.append(String.format(f2, ((DCPMMCommand.DIMM)presentDimm.get(i3)).getName(), ((DCPMMCommand.DIMM)presentDimm.get(i3)).getVersion()));
                continue;
            }
            fStr.append(String.format(f2, ((DCPMMCommand.DIMM)presentDimm.get(i3)).getName(), ""));
        }
        MOut.G(this).println(fStr.toString());
        this.statusCode = 0;
    }
}

