/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.text.Diagnostics.DiagDetect;
import com.supermicro.ipmi.text.Diagnostics.DiagHeader;
import com.supermicro.ipmi.text.Diagnostics.DiagInfo;
import com.supermicro.ipmi.text.Diagnostics.Diagnostic;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import jline.console.ConsoleReader;
import org.apache.commons.lang3.math.NumberUtils;

public class DiagDisplayCommand
extends SuperBladeCommand {
    private static String INFO = "info";
    private static String PASS = "pass";
    private static String FAIL = "fail";
    private static String LINE = "line";
    private static String ABORTED = "aborted";
    private static String REMEDIAL = "remedial";
    private static String SUMMARY = "summary";
    private static String SYS_COMPONENT_DETECT = "system component detection";
    private static String DIAGNOSTICS = "diagnostics";
    private static String INFORMATION = "information";
    private static String COPYRIGHT = "smc.copyright";
    private static String ODATATYPE = "odata.type";
    private static String TIMESTAMP = "timestamp";
    private String condition1 = null;
    private String condition2 = null;
    private byte[] header;
    int showLine = -1;
    int formatLine = 20;
    int count = 0;

    @Override
    public boolean preValidate() {
        this.showLine = -1;
        this.condition1 = null;
        this.condition2 = null;
        this.count = 0;
        if (this.parameters == null) {
            MOut.G(this).println("File name is needed");
            MOut.G(this).println("Usage: ");
            MOut.G(this).println("String filter could be added as [pass|fail|info]");
            MOut.G(this).println("Example: diag display <JSON file> pass");
            MOut.G(this).println("Display lines could be set as [line[number]]");
            MOut.G(this).println("Example: diag display <JSON file> line 20");
            return false;
        }
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            if (this.parameters[i2].toLowerCase().startsWith(LINE)) {
                if (i2 < this.parameters.length - 1) {
                    if (NumberUtils.isNumber(this.parameters[i2 + 1])) {
                        if (Integer.parseInt(this.parameters[i2 + 1]) > 0) {
                            this.showLine = Integer.parseInt(this.parameters[i2 + 1]);
                        } else {
                            MOut.G(this).println("Type invalid line number, use default " + this.formatLine + " lines");
                            this.showLine = this.formatLine;
                        }
                        ++i2;
                        continue;
                    }
                    MOut.G(this).println("Type invalid line number, use default " + this.formatLine + " lines");
                    this.showLine = this.formatLine;
                    continue;
                }
                this.showLine = this.formatLine;
                continue;
            }
            if (!this.parameters[i2].toLowerCase().startsWith(INFO) && !this.parameters[i2].toLowerCase().startsWith(PASS) && !this.parameters[i2].toLowerCase().startsWith(FAIL)) continue;
            if (i2 < this.parameters.length - 1) {
                if (this.parameters[i2 + 1].toLowerCase().startsWith(LINE)) continue;
                this.condition1 = this.parameters[i2];
                this.condition2 = this.parameters[i2 + 1];
                ++i2;
                continue;
            }
            this.condition1 = this.parameters[i2];
            this.condition2 = null;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String fileName = this.parameters[0];
        String newStr = this.refactoryMultiJson(fileName);
        if (newStr == null) {
            MOut.G(this).println("Unable to open file " + fileName);
            this.statusCode = 149;
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        try {
            JsonNode rootArray = mapper.readTree(newStr);
            Diagnostic diagnostic = null;
            diagnostic = this.condition1 != null && this.condition1.toLowerCase().equals(INFO) ? this.getInfo(rootArray) : (this.condition1 != null && this.condition1.toLowerCase().equals(PASS) ? this.getDiag(rootArray) : (this.condition1 != null && this.condition1.toLowerCase().equals(FAIL) ? this.getDiag(rootArray) : this.getAll(rootArray)));
            StringBuffer outputBuffer = new StringBuffer();
            if (diagnostic != null) {
                this.sessionController.closeSession();
                this.isSessionClosed = true;
                this.printResult(diagnostic, 1, outputBuffer);
                String[] lines = outputBuffer.toString().split("\\n");
                ConsoleReader reader = new ConsoleReader();
                for (String s : lines) {
                    if (this.showLine != -1 && this.count >= this.showLine) {
                        MOut.G(this).println("Press any key to continue...");
                        try {
                            int n = reader.readCharacter();
                            if (n == 4) break;
                            this.count = 0;
                        }
                        catch (IOException e2) {
                            MOut.G(this).println("Get system input fail");
                        }
                    }
                    MOut.G(this).println(s);
                    ++this.count;
                }
            }
            this.statusCode = 0;
        }
        catch (IOException e3) {
            this.statusCode = 149;
            MOut.G(this).println(e3.getMessage());
        }
    }

    private String getHeaderInfo() {
        try {
            byte[] b2 = this.header;
            DiagHeader diagHeader = DiagHeader.fromRaw(b2);
            return diagHeader.toReadableString();
        }
        catch (NumberFormatException e2) {
            MOut.G(this).println(e2.getMessage());
            return "";
        }
    }

    public Diagnostic getAll(JsonNode rootArray) {
        DiagInfo diagRoot = new DiagInfo();
        for (JsonNode node : rootArray) {
            Iterator<Map.Entry<String, JsonNode>> iteratorMails = node.fields();
            int layer = 1;
            DiagInfo diagnostic = null;
            while (iteratorMails.hasNext()) {
                diagnostic = new DiagInfo();
                Map.Entry<String, JsonNode> entry = iteratorMails.next();
                String key = entry.getKey();
                if (key.toLowerCase().contains(COPYRIGHT) || key.toLowerCase().contains(ODATATYPE) || key.toLowerCase().contains(TIMESTAMP)) continue;
                this.getSubNode(entry, layer, diagnostic);
                diagRoot.addChild(diagnostic);
            }
        }
        return diagRoot;
    }

    public Diagnostic getInfo(JsonNode rootArray) {
        DiagInfo diagInfoRoot = new DiagInfo();
        for (JsonNode node : rootArray) {
            Iterator<Map.Entry<String, JsonNode>> iteratorMails = node.fields();
            int layer = 1;
            DiagInfo diagInfo = null;
            while (iteratorMails.hasNext()) {
                diagInfo = new DiagInfo();
                Map.Entry<String, JsonNode> entry = iteratorMails.next();
                String key = entry.getKey();
                if (key.toLowerCase().contains(COPYRIGHT) || key.toLowerCase().contains(ODATATYPE) || key.toLowerCase().contains(TIMESTAMP)) continue;
                if (key.toLowerCase().contains(INFORMATION)) {
                    if (this.condition2 != null) {
                        if (this.queryKeyByCondition(key)) {
                            this.getSubNode(entry, layer, diagInfo);
                        }
                    } else {
                        this.getSubNode(entry, layer, diagInfo);
                    }
                }
                diagInfoRoot.addChild(diagInfo);
            }
        }
        return diagInfoRoot;
    }

    public Diagnostic getDiag(JsonNode rootArray) {
        DiagDetect diagDetectRoot = new DiagDetect();
        for (JsonNode node : rootArray) {
            Iterator<Map.Entry<String, JsonNode>> iteratorMails = node.fields();
            int layer = 1;
            DiagDetect diagDetect = null;
            while (iteratorMails.hasNext()) {
                diagDetect = new DiagDetect();
                Map.Entry<String, JsonNode> entry = iteratorMails.next();
                String key = entry.getKey();
                if (key.toLowerCase().contains(COPYRIGHT) || key.toLowerCase().contains(ODATATYPE) || key.toLowerCase().contains(TIMESTAMP)) continue;
                if (key.toLowerCase().contains(SYS_COMPONENT_DETECT) || key.toLowerCase().contains(DIAGNOSTICS)) {
                    if (this.condition2 != null) {
                        this.getDetectNode(entry, layer, diagDetect);
                    } else {
                        this.getSubNode(entry, layer, diagDetect);
                    }
                }
                if (diagDetect == null) continue;
                diagDetectRoot.addChild(diagDetect);
            }
        }
        return diagDetectRoot;
    }

    public void printResult(Diagnostic diagnostic, int layer, StringBuffer outputBuffer) {
        for (Diagnostic d2 : diagnostic.diagnostics) {
            if (d2.diagnostics != null && d2.diagnostics.size() != 0) {
                outputBuffer.append(this.makeSpace(d2.layer) + d2.key + ":  \n");
                this.printResult(d2, layer, outputBuffer);
                continue;
            }
            if (d2.key == null || d2.value == null) continue;
            outputBuffer.append(this.makeSpace(d2.layer) + d2.key + ":  " + d2.value + "\n");
        }
        ++layer;
    }

    public boolean queryKeyByCondition(String key) {
        return key.toLowerCase().contains(this.condition2.toLowerCase());
    }

    public void getDetectNode(Map.Entry<String, JsonNode> entry, int layer, Diagnostic diag) {
        String key = entry.getKey();
        JsonNode jsonNode = entry.getValue();
        Iterator<Map.Entry<String, JsonNode>> subNode = jsonNode.fields();
        DiagDetect diagSub = null;
        diag.setKey(key);
        diag.setLayer(layer);
        while (subNode.hasNext()) {
            boolean res;
            diagSub = new DiagDetect();
            Map.Entry<String, JsonNode> detectEntry = subNode.next();
            key = detectEntry.getKey();
            if (this.condition2 != null) {
                if (!this.queryKeyByCondition(key)) continue;
                res = this.getSubNode(detectEntry, layer + 1, diagSub);
                if (diagSub == null || !res) continue;
                diag.addChild(diagSub);
                continue;
            }
            res = this.getSubNode(detectEntry, layer + 1, diagSub);
            if (diagSub == null || !res) continue;
            diag.addChild(diagSub);
        }
    }

    public boolean getSubNode(Map.Entry<String, JsonNode> entry, int layer, Diagnostic diag) {
        String key = entry.getKey();
        JsonNode jsonNode = entry.getValue();
        boolean flag = false;
        if (jsonNode.isContainerNode()) {
            diag.setKey(key);
            diag.setLayer(layer);
            Iterator<Map.Entry<String, JsonNode>> subNode = jsonNode.fields();
            ++layer;
            DiagDetect diagSub = null;
            while (subNode.hasNext()) {
                diagSub = new DiagDetect();
                boolean res = this.getSubNode(subNode.next(), layer, diagSub);
                if (diagSub == null || !res) continue;
                diag.addChild(diagSub);
                flag = true;
            }
        } else {
            String str = jsonNode.toString().replace("\"", "");
            if (this.condition1 != null && this.condition1.toLowerCase().equals(INFO)) {
                flag = true;
                diag.setKey(key);
                diag.setValue(str);
                diag.setLayer(layer);
            } else if (this.condition1 != null && this.condition1.toLowerCase().equals(PASS)) {
                if (str.toLowerCase().contains(PASS)) {
                    flag = true;
                    diag.setKey(key);
                    diag.setValue(str);
                    diag.setLayer(layer);
                }
            } else if (this.condition1 != null && this.condition1.toLowerCase().equals(FAIL)) {
                if (str.toLowerCase().contains(FAIL) || str.toLowerCase().contains(ABORTED) || key.toLowerCase().contains(REMEDIAL)) {
                    flag = true;
                    diag.setKey(key);
                    diag.setValue(str);
                    diag.setLayer(layer);
                }
            } else {
                flag = true;
                diag.setKey(key);
                diag.setValue(str);
                diag.setLayer(layer);
            }
        }
        return flag;
    }

    public void saveHeader(byte[] header) {
        this.header = header;
    }

    public String refactoryMultiJson(String fileName) {
        String newStr = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            byte[] data = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            int readCount = fileInputStream.read(data);
            fileInputStream.close();
            if (readCount < 0) {
                MOut.G(this).println("Error reading file '" + fileName + "', read count < 0");
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            byte[] contentBytes = null;
            if (ByteUtility.bytesToHexNoSpace(data).substring(0, 2).equals("5B")) {
                String contentStr = ByteUtility.bytesToHexNoSpace(data);
                contentBytes = new BigInteger(contentStr, 16).toByteArray();
            } else {
                int firstLeftBrackets = ByteUtility.bytesToHexNoSpace(data).indexOf("5B");
                String headerStr = ByteUtility.bytesToHexNoSpace(data).substring(0, firstLeftBrackets);
                String contentStr = ByteUtility.bytesToHexNoSpace(data).substring(firstLeftBrackets);
                byte[] headerBytes = new BigInteger(headerStr, 16).toByteArray();
                contentBytes = new BigInteger(contentStr, 16).toByteArray();
                this.saveHeader(headerBytes);
                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                writer.write(new String(contentBytes));
                writer.close();
            }
            stringBuffer.setLength(0);
            stringBuffer.append(new String(contentBytes));
            newStr = stringBuffer.toString().replaceAll("\n", "").trim();
        }
        catch (FileNotFoundException ex) {
            MOut.G(this).println("Unable to open file '" + fileName + "'");
        }
        catch (IOException ex) {
            MOut.G(this).println("Error reading file '" + fileName + "'");
        }
        return newStr;
    }

    public String outputSummary(String fileName) {
        String line = null;
        String newStr = null;
        try {
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                MOut.G(this).println(line);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException ex) {
            MOut.G(this).println("Unable to open file '" + fileName + "'");
        }
        catch (IOException ex) {
            MOut.G(this).println("Error reading file '" + fileName + "'");
        }
        return newStr;
    }

    private String makeSpace(int number) {
        StringBuffer spaceStr = new StringBuffer();
        char s = ' ';
        for (int x = 0; x < number - 1; ++x) {
            spaceStr.append(s).append(s).append(s).append(s);
        }
        return spaceStr.toString();
    }
}

