/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.DiagnosticCommand;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import tw.com.aten.vstorage.VirtualStorage;
import tw.com.aten.vstorage.VirtualStorageManager;

public class DiagStartCommand
extends SuperBladeCommand {
    private GlobalDefine.BootDevice bootDevice = GlobalDefine.BootDevice.UEFI_USB_KEY;
    int diagExecuteTime = 1800;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            this.printUsage();
            return false;
        }
        if (!this.parameters[0].equalsIgnoreCase("iso") && !this.parameters[0].equalsIgnoreCase("drv")) {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMCommand ipmiOEMCommand;
        boolean isOlderBootOrder;
        boolean boolResult;
        boolean isForceStunnelVer11 = false;
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        DiagnosticCommand diagCommand = new DiagnosticCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!diagCommand.isDiagnosticSupported()) {
            MOut.G(this).println("this device does not support diagnostic");
            this.statusCode = 153;
            return;
        }
        DiagnosticCommand.Diagnostic diag = diagCommand.fromRaw(diagCommand.getDiagnosticRaw());
        if (diag.currentCase == -91) {
            diagCommand.beginDiagnostic();
        }
        if (this.parameters[0].equalsIgnoreCase("iso")) {
            this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_CDDVD;
            if (this.parameters.length > 2 && "ssl".equalsIgnoreCase(this.parameters[2])) {
                isForceStunnelVer11 = true;
            }
            if (!this.dev2iso(this.parameters[1], isForceStunnelVer11)) {
                this.statusCode = 0;
                return;
            }
        } else if (this.parameters[0].equalsIgnoreCase("drv")) {
            this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_KEY;
            if (this.parameters.length > 2 && "ssl".equalsIgnoreCase(this.parameters[2])) {
                isForceStunnelVer11 = true;
            }
            if (this.parameters.length > 3 && "ssl".equalsIgnoreCase(this.parameters[3])) {
                isForceStunnelVer11 = true;
            }
            if (!this.dev1Drv(this.parameters[1], isForceStunnelVer11)) {
                this.statusCode = 0;
                return;
            }
        }
        if (this.parameters.length == 3) {
            if (this.parameters[2].equalsIgnoreCase("1")) {
                this.bootDevice = GlobalDefine.BootDevice.PXE;
            } else if (this.parameters[2].equalsIgnoreCase("2")) {
                this.bootDevice = GlobalDefine.BootDevice.HD_DEFAULT;
            } else if (this.parameters[2].equalsIgnoreCase("3")) {
                this.bootDevice = GlobalDefine.BootDevice.CD_DVD;
            } else if (this.parameters[2].equalsIgnoreCase("4")) {
                this.bootDevice = GlobalDefine.BootDevice.BIOS;
            } else if (this.parameters[2].equalsIgnoreCase("5")) {
                this.bootDevice = GlobalDefine.BootDevice.USB_KEY;
            } else if (this.parameters[2].equalsIgnoreCase("6")) {
                this.bootDevice = GlobalDefine.BootDevice.USB_HDD;
            } else if (this.parameters[2].equalsIgnoreCase("7")) {
                this.bootDevice = GlobalDefine.BootDevice.USB_FLOPPY;
            } else if (this.parameters[2].equalsIgnoreCase("8")) {
                this.bootDevice = GlobalDefine.BootDevice.USB_CD_DVD;
            } else if (this.parameters[2].equalsIgnoreCase("9")) {
                this.bootDevice = GlobalDefine.BootDevice.UEFI_HD;
            } else if (this.parameters[2].equalsIgnoreCase("10")) {
                this.bootDevice = GlobalDefine.BootDevice.UEFI_CD_DVD;
            } else if (this.parameters[2].equalsIgnoreCase("11")) {
                this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_KEY;
            } else if (this.parameters[2].equalsIgnoreCase("12")) {
                this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_HDD;
            } else if (this.parameters[2].equalsIgnoreCase("13")) {
                this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_CDDVD;
            }
        }
        if (!(boolResult = ipmiChassisCommand.setBootDeviceOption(this.bootDevice, isOlderBootOrder = (ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface())).isOlderBootOptionDevice()))) {
            MOut.G(this).println("Set boot device failed");
            this.statusCode = 149;
        }
        if (!(boolResult = ipmiChassisCommand.keepBootFlagValidBit())) {
            MOut.G(this).println("Can't keep boot flag valid bit");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Set boot device done");
        boolResult = ipmiChassisCommand.powerDown();
        if (!boolResult) {
            MOut.G(this).println("Power off System Failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Powering off system for diagnostic initialization");
        Thread.sleep(10000L);
        boolResult = ipmiChassisCommand.powerUp();
        if (!boolResult) {
            MOut.G(this).println("Power up System Failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Powering up the system");
        Thread.sleep(10000L);
        String status = "";
        byte lastState = 0;
        byte currentState = 0;
        byte lastU8Progress = 0;
        byte u8Progress = 0;
        int countdown = 0;
        do {
            if (countdown++ > this.diagExecuteTime / 10) {
                MOut.G(this).println("Exceed timeout " + this.diagExecuteTime + " seconds");
                this.statusCode = 148;
                break;
            }
            if (currentState != lastState) {
                lastState = currentState;
                countdown = 0;
            }
            if (u8Progress != lastU8Progress) {
                lastU8Progress = u8Progress;
                countdown = 0;
            }
            if (!(diag = diagCommand.fromRaw(diagCommand.getDiagnosticRaw())).getAction().equalsIgnoreCase(status)) {
                status = diag.getAction();
                System.out.println("Action: " + status);
            }
            u8Progress = diag.getProgress();
            Thread.sleep(10000L);
        } while ((currentState = diag.currentCase) != -91);
        if (this.parameters[0].equalsIgnoreCase("iso")) {
            this.dev2Unmount(this.parameters[1]);
        } else {
            this.dev1Unmount(this.parameters[1]);
        }
        MOut.G(this).println("Diagnostic complete, please use diagnostic download command to download result");
        this.statusCode = 0;
    }

    public void dev1Unmount(String p1) {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev1IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        MOut.G(this).println("unmount " + vs.getDev1Array()[index]);
        vs.dev1Unmount();
    }

    public void dev2Unmount(String fileName) {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        if (vs == null) {
            this.statusCode = 149;
            return;
        }
        File f2 = new File(fileName);
        if (!f2.exists()) {
            return;
        }
        MOut.G(this).println("unmount " + fileName);
        vs.dev2Unmount();
    }

    public boolean dev2iso(String fileName, boolean isForceStunnelVer11) {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, isForceStunnelVer11);
        String p1 = fileName;
        if (vs == null) {
            MOut.G(this).println("VirtualStorage does not exist");
            return false;
        }
        File f2 = new File(p1);
        if (!f2.exists()) {
            MOut.G(this).println(p1 + " does not exist");
            return false;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return false;
        }
        MOut.G(this).println("Mounting ISO file: " + p1);
        vs.dev2ISOMount(p1);
        MOut.G(this).print(vs.lastMessage());
        return true;
    }

    public boolean dev1Drv(String p1, boolean isForceStunnelVer11) {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config, isForceStunnelVer11);
        if (vs == null) {
            MOut.G(this).println("VirtualStorage does not exist");
            return false;
        }
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
        if (!vs.checkIsDev1IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return false;
        }
        if (vs.getDev1MountIndex() != 0) {
            MOut.G(this).print("Device 1 is mounted already");
            return false;
        }
        MOut.G(this).println("Mounting " + vs.getDev1Array()[index]);
        vs.dev1Mount(index);
        MOut.G(this).print(vs.lastMessage());
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("diag start iso <iso file>");
        MOut.G(this).println("diag start drv <index> ");
    }

    @Deprecated
    public byte checkProductVer() throws Exception {
        IPMINM20Command ipmiNM20Command = null;
        IPMISDRCommand ipmiSDRCommand = null;
        ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            return -1;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiNM20Command = new IPMINM20Command(ipmb);
        } else {
            ipmiNM20Command = new IPMINM20Command(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        DeviceInfo deviceID = ipmiNM20Command.getDeviceID();
        return deviceID.raw[9];
    }
}

