/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.Diagnostics;

import com.supermicro.ipmi.ByteUtility;

public class DiagHeader {
    public byte[] signature;
    public byte revision;
    public byte[] length;
    public byte[] time;
    public byte[] reserve;
    public byte[] checksum;

    public static DiagHeader fromRaw(byte[] raw) {
        DiagHeader header = null;
        try {
            header = new DiagHeader();
            int index = 0;
            header.signature = new byte[5];
            System.arraycopy(raw, index, header.signature, 0, 5);
            header.revision = raw[index += 5];
            header.length = new byte[4];
            header.time = new byte[7];
            header.reserve = new byte[13];
            header.checksum = new byte[2];
            System.arraycopy(raw, ++index, header.length, 0, 4);
            System.arraycopy(raw, index += 4, header.time, 0, 7);
            System.arraycopy(raw, index += 7, header.reserve, 0, 13);
            System.arraycopy(raw, index += 13, header.checksum, 0, 2);
        }
        catch (Exception e2) {
            return null;
        }
        return header;
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        StringBuffer signatureSB = new StringBuffer();
        String hex = ByteUtility.bytesToHexNoSpace(this.signature);
        for (int i2 = 0; i2 < hex.length(); i2 += 2) {
            String str = hex.substring(i2, i2 + 2);
            signatureSB.append((char)Integer.parseInt(str, 16));
        }
        sb.append("signature = " + signatureSB.toString() + "\n");
        sb.append("revision = " + ByteUtility.byteToHex(this.revision) + "h \n");
        signatureSB.setLength(0);
        try {
            String size = "";
            hex = ByteUtility.bytesToHexNoSpace(this.length);
            for (int i3 = 0; i3 < hex.length(); i3 += 2) {
                String str = hex.substring(i3, i3 + 2);
                size = str + size;
            }
            sb.append("size = " + Integer.parseInt(size, 16) + " \n");
            hex = ByteUtility.bytesToHexNoSpace(this.time);
            String format = "/";
            String year = hex.substring(2, 4) + hex.substring(0, 2);
            signatureSB.append(Integer.parseInt(year, 16) + format);
            for (int i4 = 4; i4 < hex.length(); i4 += 2) {
                String str = hex.substring(i4, i4 + 2);
                format = i4 >= 2 && i4 < 6 ? "/" : (i4 == 6 ? " " : ":");
                signatureSB.append(Integer.parseInt(str, 16) + format);
            }
            sb.append("time = " + signatureSB.delete(signatureSB.length() - 1, signatureSB.length()).toString() + " \n");
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
        }
        sb.append("checksum = " + ByteUtility.bytesToHex(this.checksum) + " \n");
        return sb.toString();
    }

    public static long sevenBytesToLong(byte[] b2) {
        long b7 = 0L;
        long b6 = b2[6] & 0xFF;
        long b5 = b2[5] & 0xFF;
        long b4 = b2[4] & 0xFF;
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b0 << 56) + (b1 << 48) + (b22 << 40) + (b3 << 32) + (b4 << 24) + (b5 << 16) + (b6 << 8) + b7;
    }

    public static long sevenBytesToLongByLSBFirst(byte[] b2) {
        long b7 = 0L;
        long b6 = b2[6] & 0xFF;
        long b5 = b2[5] & 0xFF;
        long b4 = b2[4] & 0xFF;
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b7 << 56) + (b6 << 48) + (b5 << 40) + (b4 << 32) + (b3 << 24) + (b22 << 16) + (b1 << 8) + b0;
    }
}

