/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.MOut;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FindCommand
extends Command {
    public static HashMap<String, String> foundDevice = new LinkedHashMap<String, String>();
    private ThreadPoolExecutor excutor;
    private static final int THREAD_POOL_SIZE = 2048;
    private static final int FIND_DEVICE_LIMITATION = 65536;

    @Override
    public void execute() {
        this.excutor = null;
        this.excutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2048);
        if (this.parameters != null) {
            if (this.parameters.length >= 3) {
                String arg;
                String startIP = this.parameters[0];
                String endIP = this.parameters[1];
                String netMask = this.parameters[2];
                boolean showGUID = false;
                String[] stringArray = this.parameters;
                int n = stringArray.length;
                for (int k = 0; k < n && !(showGUID = (arg = stringArray[k]).equals("-g")); ++k) {
                }
                this.findIPMIDevice(startIP, endIP, netMask, showGUID);
                this.statusCode = 0;
            } else {
                MOut.G(this).println("parameter error!");
                this.statusCode = 147;
            }
        } else {
            this.findLocalIPMIDevice();
            this.statusCode = 0;
        }
    }

    public void findIPMIDevice(String startIP, String endIP, String netMask, boolean showGUID) {
        try {
            ArrayList<String> list = this.allAddress(startIP, endIP, netMask);
            ArrayList<FindDeviceRunnable> devices = this.getAllPossibleIPMIDevice(list);
            this.findIPMIDevice(devices, showGUID);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
    }

    public void findLocalIPMIDevice() {
        ArrayList<String> list = this.findLocalIPs();
        ArrayList<FindDeviceRunnable> devices = this.getAllPossibleIPMIDevice(list);
        this.findIPMIDevice(devices, false);
    }

    public void findIPMIDevice(ArrayList<FindDeviceRunnable> devices, boolean showGUID) {
        MOut.G(this).println("Finding IPMI Devices ...");
        long monitorBeginTimestamp = System.currentTimeMillis();
        long monitorTimeToLive = 600000L;
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            this.excutor.submit(devices.get(i2));
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        do {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
        } while (this.excutor.getCompletedTaskCount() < (long)devices.size() && System.currentTimeMillis() - monitorBeginTimestamp <= 600000L);
        this.excutor.shutdown();
        try {
            if (!this.excutor.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                this.excutor.shutdownNow();
            }
        }
        catch (InterruptedException e2) {
            this.excutor.shutdownNow();
        }
        this.excutor = null;
        boolean isFoundAny = false;
        int deviceCount = 0;
        for (int i3 = 0; i3 < devices.size(); ++i3) {
            if (!devices.get((int)i3).doneGet) continue;
            IPMIInterfaceConfig aConfig = new IPMIInterfaceConfig();
            aConfig.setIp(devices.get((int)i3).ip);
            aConfig.setUserName(this.config.getUserName());
            aConfig.setPassword(this.config.getPassword());
            HostCenter.getInstance().getFoundHostBuffer().addHost(aConfig);
            ++deviceCount;
            MOut.G(this).println(devices.get(i3).toString(showGUID));
            foundDevice.put(devices.get((int)i3).ip, devices.get((int)i3).type);
            isFoundAny = true;
        }
        if (!isFoundAny) {
            MOut.G(this).println("No IPMI Device found!");
        } else {
            try {
                HostCenter.getInstance().getFoundHostBuffer().setFilename("found.ser");
                HostCenter.getInstance().getFoundHostBuffer().save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Elapsed time: " + (System.currentTimeMillis() - monitorBeginTimestamp) / 1000L + " sec");
            MOut.G(this).println("" + deviceCount + " IPMI device(s) found. Use \"found\" to list found devices");
        }
    }

    public ArrayList<FindDeviceRunnable> getAllPossibleIPMIDevice(ArrayList<String> list) {
        ArrayList<FindDeviceRunnable> devices = new ArrayList<FindDeviceRunnable>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FindDeviceRunnable device = new FindDeviceRunnable(list.get(i2), 3, 2);
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<String> findLocalIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        InetAddress[] ia = null;
        try {
            ia = this.getAllLocalUsingNetworkInterface();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (int i2 = 0; ia != null && i2 < ia.length; ++i2) {
            ArrayList<String> l = this.allAddress(ia[i2].getHostAddress());
            ips.addAll(l);
        }
        return ips;
    }

    private InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e2 = null;
        try {
            e2 = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e2.hasMoreElements()) {
            NetworkInterface ni = e2.nextElement();
            Enumeration<InetAddress> e22 = ni.getInetAddresses();
            while (e22.hasMoreElements()) {
                addresses.add(e22.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i2 = 0; i2 < iAddresses.length; ++i2) {
            iAddresses[i2] = (InetAddress)addresses.get(i2);
        }
        return iAddresses;
    }

    public ArrayList<String> allAddress(String ip) {
        ArrayList<String> list = new ArrayList<String>();
        if (IPMILanCommand.isIPAddress(ip) && !ip.equals("127.0.0.1")) {
            String cClass = ip.substring(0, ip.lastIndexOf("."));
            for (int i2 = 1; i2 < 255; ++i2) {
                list.add(cClass + "." + i2);
            }
        }
        return list;
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        InetAddress startInet = InetAddress.getByName(startIP);
        InetAddress endInet = InetAddress.getByName(endIP);
        InetAddress maskInet = InetAddress.getByName(netmask);
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i2 = startInet.hashCode(); i2 <= endInet.hashCode(); ++i2) {
            list.add(this.intToIP(i2));
        }
        if (list.size() > 65536) {
            throw new Exception("Device count is out of limitation(65536)");
        }
        return list;
    }

    public String intToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        FindCommand f2 = new FindCommand();
        InetAddress saddress = null;
        try {
            saddress = InetAddress.getByName("2.168.10.1");
            MOut.G().println(f2.intToIP(saddress.hashCode() + 1));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            ArrayList<String> list = f2.allAddress("2.168.1.1", "2.168.1.24", "255.255.255.0");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                System.out.println(list.get(i2));
            }
        }
        catch (Exception ex1) {
            MOut.G().println(ex1.getMessage());
        }
    }

    class FindDeviceRunnable
    implements Runnable {
        public String ip;
        public String type;
        public String guid;
        boolean doneGet = false;
        int timeout;
        int retry;
        IPMIInterfaceConfig config;

        public FindDeviceRunnable(String ip, int timeout, int retry) {
            this.ip = ip;
            this.timeout = timeout;
            this.retry = retry;
            this.config = new IPMIInterfaceConfig();
            this.config.setIp(ip);
            this.config.setTimeout(timeout);
            this.config.setRetry(retry);
        }

        @Override
        public void run() {
            if (this.isReachable(this.config.getIp(), 623, 3000)) {
                byte[] guid = null;
                try {
                    guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp(), this.timeout, this.retry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (guid != null) {
                    String temp = new String(guid);
                    int endIndex = temp.contains("MS") ? temp.indexOf("MS") + 2 : temp.length();
                    this.guid = temp.substring(0, endIndex);
                    this.type = IPMIMessagingCommand.getFWTypeByGUID(guid);
                    this.doneGet = true;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isReachable(String addr, int openPort, int timeOutMillis) {
            try (Socket soc = new Socket();){
                soc.connect(new InetSocketAddress(addr, openPort), timeOutMillis);
                soc.close();
                boolean throwable3 = true;
                return throwable3;
            }
            catch (IOException ex) {
                try (Socket soc2 = new Socket();){
                    soc2.connect(new InetSocketAddress(addr, 22), 1500);
                    soc2.close();
                    boolean throwable8 = true;
                    return throwable8;
                }
                catch (IOException ex2) {
                    return false;
                }
            }
        }

        public String toString(boolean moreInfo) {
            String format = moreInfo ? "  %-20s \t %-10s \t %-20s" : "  %-20s \t %-20s";
            String retStr = moreInfo ? String.format(format, this.ip, this.guid, this.type) : String.format(format, this.ip, this.type);
            return retStr;
        }
    }
}

