/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBStatusCommand
extends SuperBladeCommand {
    boolean isMicroBlade = false;

    public GBStatusCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            this.isMicroBlade = true;
            if (SwitchInfo.getIndex((String)this.preParameters.get(1)) == -1) {
                MOut.G(this).println("Gigabit switch Index out of range");
                return false;
            }
            return true;
        }
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            MOut.G(this).println("Gigabit switch Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.isMicroBlade) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            int sIndex = SwitchInfo.getIndex((String)this.preParameters.get(1));
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)sIndex, (byte)1);
            if (switchInfo.isPresent()) {
                sb.append(switchInfo.to7UStatusFormatedString1());
                sb2.append(switchInfo.to7UStatusFormatedStringLine2());
            }
            MOut.G(this).print(switchInfo.to7UStatusFormatedHeader1());
            MOut.G(this).print(sb.toString());
            MOut.G(this).println("");
            MOut.G(this).print(switchInfo.to7UStatusFormatedHeaderLine2());
            MOut.G(this).print(sb2.toString());
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryGigabitSwitchEntity(true);
        bladeSystem.setIsQueryInfiniBandEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        if (index == 1 || index == 2) {
            GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
            if (gb.getPresent() == 0) {
                MOut.G(this).println("Gigabit Switch " + index + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).print(gb.toFormatedHeader());
            MOut.G(this).print(gb.toFormatedString());
            if (gb.showModelName) {
                MOut.G(this).print(gb.toFormatedHeaderLine2());
                MOut.G(this).print(gb.toFormatedStringLine2());
            }
        } else if (index == 3 || index == 4) {
            if (bladeSystem.getGigabitSwitchs().length == 4) {
                GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
                if (gb.getPresent() == 0) {
                    MOut.G(this).println("Gigabit Switch " + index + " is not presented");
                    this.statusCode = 151;
                    return;
                }
                MOut.G(this).print(gb.toFormatedHeader());
                MOut.G(this).print(gb.toFormatedString());
                if (gb.showModelName) {
                    MOut.G(this).print(gb.toFormatedHeaderLine2());
                    MOut.G(this).print(gb.toFormatedStringLine2());
                }
            } else {
                TenGSwitchEntity g2 = bladeSystem.getTenGSwitches()[index - 3];
                if (g2.getPresent() > 0 && g2.is10GSwitch()) {
                    MOut.G(this).print(g2.toFormatedHeader());
                    MOut.G(this).print(g2.toFormatedString());
                    if (g2.showModelName) {
                        MOut.G(this).print(g2.toFormatedHeaderLine2());
                        MOut.G(this).print(g2.toFormatedStringLine2());
                    }
                } else {
                    MOut.G(this).println("10 Gigabit Switch " + index + " is not presented");
                    this.statusCode = 151;
                    return;
                }
            }
        }
        this.statusCode = 0;
    }
}

